/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.webservices;

import java.util.Iterator;
import javax.xml.namespace.QName;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.ServiceImplBeanBean;
import weblogic.j2ee.descriptor.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;

public class WebServicesProcessor
extends JAXRPCProcessor {
    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        WebservicesBean webservicesBean = this.getWebservicesBean(this.moduleInfo);
        this.fillWebServices(jAXRPCWebServiceInfo.getWebService(), webservicesBean);
    }

    private WebservicesBean getWebservicesBean(ModuleInfo moduleInfo) {
        WebservicesBean webservicesBean = moduleInfo.getWebServicesBean();
        if (webservicesBean == null) {
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            webservicesBean = (WebservicesBean)editableDescriptorManager.createDescriptorRoot(WebservicesBean.class).getRootBean();
            webservicesBean.setVersion("1.2");
            moduleInfo.setWebServicesBean(webservicesBean);
        }
        return webservicesBean;
    }

    private void fillWebServices(WebServiceSEIDecl webServiceSEIDecl, WebservicesBean webservicesBean) {
        WebserviceDescriptionBean webserviceDescriptionBean = webservicesBean.createWebserviceDescription();
        webserviceDescriptionBean.setWebserviceDescriptionName(webServiceSEIDecl.getJClass().getQualifiedName());
        webserviceDescriptionBean.setWsdlFile(WebServicesProcessor.getWsdlFile(webServiceSEIDecl));
        webserviceDescriptionBean.setJaxrpcMappingFile(WebServicesProcessor.getRoot(webServiceSEIDecl) + '/' + webServiceSEIDecl.getArtifactName() + ".xml");
        Iterator<PortDecl> iterator = webServiceSEIDecl.getDDPorts();
        while (iterator.hasNext()) {
            PortDecl portDecl = iterator.next();
            PortComponentBean portComponentBean = webserviceDescriptionBean.createPortComponent();
            portComponentBean.setPortComponentName(portDecl.getPortName());
            portComponentBean.setWsdlPort(new QName(webServiceSEIDecl.getTargetNamespace(), portDecl.getPortName()));
            portComponentBean.setServiceEndpointInterface(webServiceSEIDecl.getEndpointInterfaceName());
            ServiceImplBeanBean serviceImplBeanBean = portComponentBean.createServiceImplBean();
            if (webServiceSEIDecl.isEjb()) {
                serviceImplBeanBean.setEjbLink(webServiceSEIDecl.getDeployedName());
            } else {
                serviceImplBeanBean.setServletLink(webServiceSEIDecl.getDeployedName() + portDecl.getProtocol());
            }
            webServiceSEIDecl.getHandlerChainDecl().populatePort(portComponentBean, null);
        }
    }

    private static String getRoot(WebServiceDecl webServiceDecl) {
        return webServiceDecl.isEjb() ? "META-INF" : "WEB-INF";
    }

    private static String getWsdlFile(WebServiceSEIDecl webServiceSEIDecl) {
        if (webServiceSEIDecl.getCowReader() == null) {
            return WebServicesProcessor.getRoot(webServiceSEIDecl) + "/" + webServiceSEIDecl.getWsdlFile();
        }
        String string = webServiceSEIDecl.getWsdlLocation();
        if (webServiceSEIDecl.isEjb() && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }
}

