/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.wlsdd;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import java.util.Iterator;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WebserviceAddressBean;
import weblogic.j2ee.descriptor.wl.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WebserviceSecurityBean;
import weblogic.j2ee.descriptor.wl.WsdlBean;
import weblogic.jws.StreamAttachments;
import weblogic.jws.WSDL;
import weblogic.jws.security.UserDataConstraint;
import weblogic.jws.security.WssConfiguration;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.util.JamUtil;

public class WlsWebservices
extends JAXRPCProcessor {
    private static final String TRANSPORT_GUARANTEE_INTEGRAL = "INTEGRAL";
    private static final String TRANSPORT_GUARANTEE_CONFIDENTIAL = "CONFIDENTIAL";

    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        WeblogicWebservicesBean weblogicWebservicesBean = this.getWeblogicWebservicesBean(this.moduleInfo);
        WlsWebservices.fillWebServices(jAXRPCWebServiceInfo.getWebService(), weblogicWebservicesBean);
    }

    private WeblogicWebservicesBean getWeblogicWebservicesBean(ModuleInfo moduleInfo) {
        WeblogicWebservicesBean weblogicWebservicesBean = moduleInfo.getWeblogicWebservicesBean();
        if (weblogicWebservicesBean == null) {
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            weblogicWebservicesBean = (WeblogicWebservicesBean)editableDescriptorManager.createDescriptorRoot(WeblogicWebservicesBean.class).getRootBean();
            moduleInfo.setWeblogicWebservicesBean(weblogicWebservicesBean);
        }
        return weblogicWebservicesBean;
    }

    private static void fillWebServices(WebServiceSEIDecl webServiceSEIDecl, WeblogicWebservicesBean weblogicWebservicesBean) throws WsBuildException {
        WebserviceDescriptionBean webserviceDescriptionBean = weblogicWebservicesBean.createWebserviceDescription();
        WlsWebservices.fillWebservice(webServiceSEIDecl, webserviceDescriptionBean);
        WlsWebservices.fillWebserviceSecurity(webServiceSEIDecl, weblogicWebservicesBean);
    }

    private static void fillWebserviceSecurity(WebServiceDecl webServiceDecl, WeblogicWebservicesBean weblogicWebservicesBean) throws WsBuildException {
        String string;
        JAnnotationValue jAnnotationValue;
        JAnnotation jAnnotation = webServiceDecl.getJClass().getAnnotation(WssConfiguration.class);
        if (jAnnotation != null && (jAnnotationValue = jAnnotation.getValue("value")) != null && (string = jAnnotationValue.asString()) != null) {
            if (weblogicWebservicesBean.getWebserviceSecurity() != null) {
                if (string.equals(weblogicWebservicesBean.getWebserviceSecurity().getMbeanName())) {
                    return;
                }
                throw new WsBuildException("Webservices in a module cannot point to more than one WebserviceSecurity MBean");
            }
            WebserviceSecurityBean webserviceSecurityBean = weblogicWebservicesBean.createWebserviceSecurity();
            webserviceSecurityBean.setMbeanName(string);
        }
    }

    private static void fillWebservice(WebServiceSEIDecl webServiceSEIDecl, WebserviceDescriptionBean webserviceDescriptionBean) {
        Iterator<PortDecl> iterator = webServiceSEIDecl.getDDPorts();
        while (iterator.hasNext()) {
            boolean bl;
            PortDecl portDecl = iterator.next();
            PortComponentBean portComponentBean = webserviceDescriptionBean.createPortComponent();
            JAnnotation jAnnotation = webServiceSEIDecl.getJClass().getAnnotation(WSDL.class);
            if (jAnnotation != null && !(bl = JamUtil.getAnnotationBooleanValue(jAnnotation, "exposed", true))) {
                WsdlBean wsdlBean = portComponentBean.createWsdl();
                wsdlBean.setExposed(bl);
            }
            webserviceDescriptionBean.setWebserviceDescriptionName(webServiceSEIDecl.getJClass().getQualifiedName());
            webserviceDescriptionBean.setWebserviceType(webServiceSEIDecl.getType().toString());
            WlsWebservices.fillPortComponent(webServiceSEIDecl, portDecl, portComponentBean);
        }
    }

    private static void fillPortComponent(WebServiceSEIDecl webServiceSEIDecl, PortDecl portDecl, PortComponentBean portComponentBean) {
        UserDataConstraint.Transport transport = webServiceSEIDecl.getWebServiceSecurityDecl().getTransport();
        if (transport == UserDataConstraint.Transport.INTEGRAL) {
            portComponentBean.setTransportGuarantee(TRANSPORT_GUARANTEE_INTEGRAL);
        } else if (transport == UserDataConstraint.Transport.CONFIDENTIAL) {
            portComponentBean.setTransportGuarantee(TRANSPORT_GUARANTEE_CONFIDENTIAL);
        }
        portComponentBean.setPortComponentName(portDecl.getPortName());
        WebserviceAddressBean webserviceAddressBean = portComponentBean.createServiceEndpointAddress();
        webserviceAddressBean.setWebserviceContextpath(portDecl.getContextPath());
        webserviceAddressBean.setWebserviceServiceuri(portDecl.getServiceUri());
        JAnnotation jAnnotation = webServiceSEIDecl.getJClass().getAnnotation(StreamAttachments.class);
        if (jAnnotation != null) {
            portComponentBean.setStreamAttachments(true);
        }
    }
}

