/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.wsdl;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.jws.Policy;
import weblogic.wsee.policy.deployment.PolicyDeployUtils;
import weblogic.wsee.policy.deployment.UsingPolicy;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyExpression;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.BuiltinPolicyFinder;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability.policy.RMAssertion;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.security.policy.SecurityPolicyCustomizer;
import weblogic.wsee.security.policy12.assertions.TransportBinding;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

public class PolicyAnnotator
extends JAXRPCProcessor {
    private WsdlPolicySubject policySubject;
    private JAXRPCWebServiceInfo webServiceInfo = null;

    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        this.webServiceInfo = jAXRPCWebServiceInfo;
        this.policySubject = new WsdlPolicySubject(jAXRPCWebServiceInfo.getDefinitions());
        Iterator iterator = this.listPorts(jAXRPCWebServiceInfo.getDefinitions());
        if (iterator == null) {
            this.moduleInfo.getJwsBuildContext().getLogger().log(EventLevel.DEBUG, "FIXME: Unable to find port. Policy annotator need to handle this case.");
            return;
        }
        assert (iterator != null);
        while (iterator.hasNext()) {
            this.processPort((WsdlPort)iterator.next());
        }
    }

    private void processPort(WsdlPort wsdlPort) throws WsBuildException {
        boolean bl = false;
        bl |= this.processClassScopedAnnotations(this.webServiceInfo.getWebService(), wsdlPort);
        Iterator<WebMethodDecl> iterator = this.webServiceInfo.getWebService().getWebMethods();
        while (iterator.hasNext()) {
            bl |= this.processMethodScopedAnnotations(iterator.next(), wsdlPort);
        }
        if (bl) {
            this.webServiceInfo.getDefinitions().putExtension(new UsingPolicy(true));
        }
    }

    private boolean processClassScopedAnnotations(WebServiceSEIDecl webServiceSEIDecl, WsdlPort wsdlPort) throws WsBuildException {
        boolean bl = false;
        WsdlBinding wsdlBinding = wsdlPort.getBinding();
        if (wsdlBinding != null) {
            Iterator<PolicyDecl> iterator = webServiceSEIDecl.getPoilices();
            while (iterator.hasNext()) {
                bl = true;
                PolicyDecl policyDecl = iterator.next();
                this.processPolicyAnnotation(policyDecl, wsdlBinding.getOperations().values().iterator(), true, wsdlPort);
            }
        }
        return bl;
    }

    private boolean processMethodScopedAnnotations(WebMethodDecl webMethodDecl, WsdlPort wsdlPort) throws WsBuildException {
        boolean bl = false;
        this.moduleInfo.getJwsBuildContext().getLogger().log(EventLevel.DEBUG, "processMethodScopedAnnotations(...," + webMethodDecl.getMethodName() + ",...)");
        Iterator<PolicyDecl> iterator = webMethodDecl.getPoilices();
        if (iterator.hasNext()) {
            WsdlBindingOperation wsdlBindingOperation = PolicyAnnotator.lookupWsdlBindingOperation(this.webServiceInfo.getDefinitions(), webMethodDecl, wsdlPort);
            ArrayList<WsdlBindingOperation> arrayList = new ArrayList<WsdlBindingOperation>();
            arrayList.add(wsdlBindingOperation);
            while (iterator.hasNext()) {
                bl = true;
                this.processPolicyAnnotation(iterator.next(), arrayList.iterator(), false, wsdlPort);
            }
        }
        return bl;
    }

    private void processPolicyAnnotation(PolicyDecl policyDecl, Iterator iterator, boolean bl, WsdlPort wsdlPort) throws WsBuildException {
        Object object;
        URI uRI = policyDecl.getPolicyURI();
        assert (uRI != null);
        PolicyStatement policyStatement = null;
        try {
            if (policyDecl.isAttachToWsdl()) {
                policyStatement = this.getPolicyStatement(policyDecl);
                if (SecurityPolicyCustomizer.isSecurityPolicyAbstract(policyDecl.getUri(), policyStatement)) {
                    throw new WsBuildException("Abstract policy can not be attached to wsdl during build time.");
                }
                if (this.policySubject.policyExists(policyStatement)) {
                    uRI = new URI("#" + policyStatement.getId());
                } else {
                    object = PolicyDeployUtils.getXPointerId(policyDecl.getUri());
                    policyStatement.setId((String)object);
                    uRI = new URI("#" + (String)object);
                    this.policySubject.addPolicy(policyStatement);
                }
            } else if (policyDecl.isRelativeUri()) {
                uRI = new URI("policy:" + policyDecl.getUriWithoutExt());
            }
        }
        catch (Exception exception) {
            throw new WsBuildException(exception);
        }
        while (iterator.hasNext()) {
            object = (WsdlBindingOperation)iterator.next();
            if (policyDecl.getDirection() == Policy.Direction.inbound) {
                PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(object.getInput(), uRI);
                if (!this.checkRMPolicy(policyStatement, policyDecl)) continue;
                this.addOptionalRMPolicy(policyStatement, policyDecl, wsdlPort);
                continue;
            }
            if (policyDecl.getDirection() == Policy.Direction.outbound) {
                PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(object.getOutput(), uRI);
                if (!this.checkRMPolicy(policyStatement, policyDecl)) continue;
                this.addOptionalRMPolicy(policyStatement, policyDecl, wsdlPort);
                continue;
            }
            if (policyDecl.getDirection() == Policy.Direction.both && this.checkRMPolicy(policyStatement, policyDecl) && !bl) {
                PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(object.getInput(), uRI);
                PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(object.getOutput(), uRI);
                this.addOptionalRMPolicy(policyStatement, policyDecl, wsdlPort);
                continue;
            }
            if (bl) {
                if (this.checkRMPolicy(policyStatement, policyDecl) || PolicyDeployUtils.isCannedMtomPolicy(policyDecl)) {
                    PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlPort.getBinding(), uRI);
                    break;
                }
                PolicyDeployUtils.addPolicyURIToPortType(wsdlPort.getPortType(), uRI);
                break;
            }
            if (!bl && this.checkTransportBindingPolicy(policyStatement, policyDecl)) {
                throw new WsBuildException("TransportBinding assertion MUST apply to Endpoint Policy Subject");
            }
            PolicyDeployUtils.addPolicyReferenceToWsdlExtensible((WsdlExtensible)object, uRI);
        }
    }

    private PolicyStatement getPolicyStatement(PolicyDecl policyDecl) throws WsBuildException {
        PolicyStatement policyStatement;
        try {
            if (policyDecl.isBuiltInPolicy()) {
                String string = policyDecl.getBuiltInUriWithoutPrefix();
                policyStatement = BuiltinPolicyFinder.getInstance().findPolicy(string, null);
            } else {
                InputStream inputStream = policyDecl.getPolicyURI().toURL().openConnection().getInputStream();
                policyStatement = PolicyFinder.readPolicyFromStream(policyDecl.getUri(), inputStream, true);
            }
        }
        catch (Exception exception) {
            throw new WsBuildException(exception);
        }
        return policyStatement;
    }

    private boolean checkRMPolicy(PolicyStatement policyStatement, PolicyDecl policyDecl) throws WsBuildException {
        if (policyDecl.isBuiltInPolicy()) {
            String string = policyDecl.getPolicyURI().toString();
            return string.indexOf("policy:DefaultReliability") >= 0 || string.indexOf("policy:LongRunningReliability") >= 0;
        }
        if (policyStatement == null) {
            policyStatement = this.getPolicyStatement(policyDecl);
        }
        try {
            return ReliabilityPolicyAssertionsFactory.hasRMPolicy(policyStatement.normalize());
        }
        catch (Exception exception) {
            throw new WsBuildException(exception);
        }
    }

    private boolean checkTransportBindingPolicy(PolicyStatement policyStatement, PolicyDecl policyDecl) throws WsBuildException {
        if (policyDecl.isBuiltInPolicy()) {
            String string = policyDecl.getPolicyURI().toString();
            return string.indexOf("Https") >= 0 && string.indexOf("Saml") < 0;
        }
        if (policyStatement == null) {
            policyStatement = this.getPolicyStatement(policyDecl);
        }
        try {
            NormalizedExpression normalizedExpression = policyStatement.normalize();
            return normalizedExpression.containsPolicyAssertion(TransportBinding.class);
        }
        catch (Exception exception) {
            throw new WsBuildException(exception);
        }
    }

    private static WsdlBindingOperation lookupWsdlBindingOperation(WsdlDefinitions wsdlDefinitions, WebMethodDecl webMethodDecl, WsdlPort wsdlPort) throws WsBuildException {
        QName qName = new QName(wsdlDefinitions.getTargetNamespace(), webMethodDecl.getName());
        WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
        if (wsdlBindingOperation == null) {
            throw new WsBuildException("Could not locate WSDL operation corresponding to method '" + webMethodDecl.getMethodName());
        }
        return wsdlBindingOperation;
    }

    private Iterator listPorts(WsdlDefinitions wsdlDefinitions) {
        Iterator<? extends WsdlService> iterator = wsdlDefinitions.getServices().values().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        assert (iterator.hasNext());
        WsdlService wsdlService = iterator.next();
        return wsdlService.getPorts().values().iterator();
    }

    private void addOptionalRMPolicy(PolicyStatement policyStatement, PolicyDecl policyDecl, WsdlPort wsdlPort) throws WsBuildException {
        if (policyStatement == null) {
            policyStatement = this.getPolicyStatement(policyDecl);
        }
        try {
            Object object;
            Object object2;
            if (SecurityPolicyCustomizer.isSecurityPolicyAbstract(policyDecl.getUri(), policyStatement)) {
                throw new WsBuildException("Abstract policy can not be attached to wsdl during build time.");
            }
            NormalizedExpression normalizedExpression = WsdlPolicySubject.getEndpointPolicySubject(new PolicyServer(this.policySubject.getPolicies()), wsdlPort, this.policySubject.getPolicies());
            Set set = normalizedExpression.getPolicyAlternatives(RM11Assertion.class);
            if (set != null) {
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    for (Object object3 : ((PolicyAlternative)object).getAssertions(RM11Assertion.class)) {
                        if (((PolicyAssertion)object3).isOptional()) continue;
                        throw new WsBuildException("Web Services Reliable Messaging policy must be optional at class level when policy is attached at method level.");
                    }
                }
            }
            if ((set = normalizedExpression.getPolicyAlternatives(RMAssertion.class)) != null) {
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    for (Object object3 : ((PolicyAlternative)object).getAssertions(RMAssertion.class)) {
                        if (((PolicyAssertion)object3).isOptional()) continue;
                        throw new WsBuildException("Web Services Reliable Messaging policy must be optional at class level when policy is attached at method level.");
                    }
                }
            }
            if (!this.policySubject.policyExists((PolicyStatement)(object = PolicyStatement.createPolicyStatement((String)(object2 = PolicyDeployUtils.getXPointerId("Optional" + policyStatement.getId())))))) {
                PolicyAssertion policyAssertion;
                Object object3;
                Iterator iterator = policyStatement.normalize().getPolicyAlternatives(RM11Assertion.class).iterator();
                while (iterator.hasNext()) {
                    object3 = ((PolicyAlternative)iterator.next()).getAssertions(RM11Assertion.class).iterator();
                    while (object3.hasNext()) {
                        policyAssertion = ReliabilityPolicyAssertionsFactory.copyRM11Assertion((RM11Assertion)object3.next());
                        policyAssertion.setOptional(true);
                        ((PolicyExpression)object).addExpression(PolicyExpression.createTerminal(policyAssertion));
                    }
                }
                iterator = policyStatement.normalize().getPolicyAlternatives(RMAssertion.class).iterator();
                while (iterator.hasNext()) {
                    object3 = ((PolicyAlternative)iterator.next()).getAssertions(RMAssertion.class).iterator();
                    while (object3.hasNext()) {
                        policyAssertion = ReliabilityPolicyAssertionsFactory.copyRMAssertion((RMAssertion)object3.next());
                        policyAssertion.setOptional(true);
                        ((PolicyExpression)object).addExpression(PolicyExpression.createTerminal(policyAssertion));
                    }
                }
                this.policySubject.addPolicy((PolicyStatement)object);
            }
            PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlPort.getBinding(), new URI("#" + (String)object2));
        }
        catch (Exception exception) {
            throw new WsBuildException(exception);
        }
    }
}

