/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.wsdl;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import weblogic.wsee.tools.jws.decl.SOAPBindingDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlBindingMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlBindingOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBody;
import weblogic.wsee.wsdl.soap11.SoapFault;
import weblogic.wsee.wsdl.soap11.SoapHeader;
import weblogic.wsee.wsdl.soap11.SoapMessageBase;
import weblogic.wsee.wsdl.soap12.Soap12Binding;
import weblogic.wsee.wsdl.soap12.Soap12BindingOperation;
import weblogic.wsee.wsdl.soap12.Soap12Body;
import weblogic.wsee.wsdl.soap12.Soap12Fault;
import weblogic.wsee.wsdl.soap12.Soap12Header;

class SoapBindingBuilder {
    private WsdlDefinitionsBuilder definitions;
    private SOAPBindingDecl bindingDecl;
    boolean isSoap12 = false;
    private static final String ENCODING_STYLE = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String SOAP12_ENCODING_STYLE = "http://www.w3.org/2003/05/soap-encoding";

    SoapBindingBuilder(WsdlDefinitions wsdlDefinitions) {
        this.definitions = (WsdlDefinitionsBuilder)wsdlDefinitions;
    }

    WsdlBinding buildSoapBinding(WebServiceSEIDecl webServiceSEIDecl, WsdlPortTypeBuilder wsdlPortTypeBuilder, PortDecl portDecl, boolean bl, int n) throws WsdlException {
        this.isSoap12 = bl;
        this.bindingDecl = webServiceSEIDecl.getSoapBinding();
        String string = this.getBindingName(webServiceSEIDecl, portDecl.getProtocol(), n);
        WsdlBindingBuilder wsdlBindingBuilder = this.definitions.addBinding(new QName(this.definitions.getTargetNamespace(), string), wsdlPortTypeBuilder);
        this.fillWsdlBinding(wsdlBindingBuilder, webServiceSEIDecl, wsdlPortTypeBuilder, portDecl);
        return wsdlBindingBuilder;
    }

    private String getBindingName(WebServiceDecl webServiceDecl, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(webServiceDecl.getServiceQName().getLocalPart() + "SoapBinding");
        if (n > 1) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void fillWsdlBinding(WsdlBindingBuilder wsdlBindingBuilder, WebServiceSEIDecl webServiceSEIDecl, WsdlPortTypeBuilder wsdlPortTypeBuilder, PortDecl portDecl) throws WsdlException {
        SoapBinding soapBinding = this.createSoapBinding(wsdlBindingBuilder);
        soapBinding.setStyle(this.bindingDecl.getStyle().toString().toLowerCase(Locale.ENGLISH));
        soapBinding.setTransport(portDecl.getWsdlTransportNS());
        Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
        while (iterator.hasNext()) {
            this.populateSoapOperation(iterator.next(), wsdlPortTypeBuilder, wsdlBindingBuilder);
        }
    }

    private void populateSoapOperation(WebMethodDecl webMethodDecl, WsdlPortTypeBuilder wsdlPortTypeBuilder, WsdlBindingBuilder wsdlBindingBuilder) throws WsdlException {
        QName qName = new QName(this.definitions.getTargetNamespace(), webMethodDecl.getName());
        WsdlOperationBuilder wsdlOperationBuilder = wsdlPortTypeBuilder.getOperations().get(qName);
        assert (wsdlOperationBuilder != null);
        WsdlBindingOperationBuilder wsdlBindingOperationBuilder = wsdlBindingBuilder.addOperation(wsdlOperationBuilder);
        SoapBindingOperation soapBindingOperation = this.createSoapBindingOperation(wsdlBindingOperationBuilder);
        soapBindingOperation.setSoapAction(webMethodDecl.getAction().trim());
        soapBindingOperation.setStyle(webMethodDecl.getSoapBinding().getStyle().toString().toLowerCase(Locale.ENGLISH));
        this.buildSoapInputMessage(wsdlBindingOperationBuilder, webMethodDecl);
        if (!webMethodDecl.isOneway()) {
            this.buildSoapOutputMessage(wsdlBindingOperationBuilder, webMethodDecl);
        }
        this.buildSoapFaultMessage(wsdlOperationBuilder, wsdlBindingOperationBuilder, webMethodDecl);
    }

    private void buildSoapInputMessage(WsdlBindingOperationBuilder wsdlBindingOperationBuilder, WebMethodDecl webMethodDecl) throws WsdlException {
        WsdlBindingMessageBuilder wsdlBindingMessageBuilder = wsdlBindingOperationBuilder.createInput();
        this.buildSoapMessage(wsdlBindingMessageBuilder, webMethodDecl, WebParam.Mode.IN);
    }

    private void buildSoapOutputMessage(WsdlBindingOperationBuilder wsdlBindingOperationBuilder, WebMethodDecl webMethodDecl) throws WsdlException {
        WsdlBindingMessageBuilder wsdlBindingMessageBuilder = wsdlBindingOperationBuilder.createOutput();
        this.buildSoapMessage(wsdlBindingMessageBuilder, webMethodDecl, WebParam.Mode.OUT);
    }

    private void buildSoapMessage(WsdlBindingMessage wsdlBindingMessage, WebMethodDecl webMethodDecl, WebParam.Mode mode) throws WsdlException {
        SoapBody soapBody = this.createSoapBody(wsdlBindingMessage);
        this.setUse(webMethodDecl, soapBody);
        if (!webMethodDecl.getSoapBinding().isDocumentStyle()) {
            soapBody.setNamespace(this.definitions.getTargetNamespace());
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (mode == WebParam.Mode.OUT) {
            if (webMethodDecl.getWebResult().hasReturn()) {
                stringBuffer.append(webMethodDecl.getWebResult().getPartName());
            }
        } else if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
            stringBuffer.append("parameters");
        }
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            WebParamDecl webParamDecl = iterator.next();
            if (webParamDecl.getMode() != mode && webParamDecl.getMode() != WebParam.Mode.INOUT) continue;
            if (webParamDecl.isHeader()) {
                SoapHeader soapHeader = this.createSoapHeader(wsdlBindingMessage);
                this.setUse(webMethodDecl, soapHeader);
                soapHeader.setMessage(wsdlBindingMessage.getMessage().getName());
                soapHeader.setPart(webParamDecl.getPartName());
                if (stringBuffer.length() != 0) continue;
                stringBuffer.append(" ");
                continue;
            }
            if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(webParamDecl.getPartName());
        }
        if (stringBuffer.length() > 0) {
            soapBody.setParts(stringBuffer.toString());
        }
    }

    private void buildSoapFaultMessage(WsdlOperation wsdlOperation, WsdlBindingOperationBuilder wsdlBindingOperationBuilder, WebMethodDecl webMethodDecl) {
        Map<String, ? extends WsdlMessage> map = wsdlOperation.getFaults();
        for (Map.Entry<String, ? extends WsdlMessage> entry : map.entrySet()) {
            String string = entry.getKey();
            WsdlBindingMessageBuilder wsdlBindingMessageBuilder = wsdlBindingOperationBuilder.createFault(string);
            SoapFault soapFault = this.createSoapFault(wsdlBindingMessageBuilder);
            soapFault.setName(string);
            if (!webMethodDecl.getSoapBinding().isDocumentStyle() && !webMethodDecl.getSoapBinding().isLiteral()) {
                soapFault.setNamespace(this.definitions.getTargetNamespace());
            }
            soapFault.setUse(SOAPBinding.Use.LITERAL.toString().toLowerCase(Locale.ENGLISH));
        }
    }

    private void setUse(WebMethodDecl webMethodDecl, SoapMessageBase soapMessageBase) {
        soapMessageBase.setUse(webMethodDecl.getSoapBinding().getUse().toString().toLowerCase(Locale.ENGLISH));
        if (!webMethodDecl.getSoapBinding().isLiteral()) {
            if (this.isSoap12) {
                soapMessageBase.setEncodingStyle(SOAP12_ENCODING_STYLE);
            } else {
                soapMessageBase.setEncodingStyle(ENCODING_STYLE);
            }
        }
    }

    private SoapBinding createSoapBinding(WsdlBinding wsdlBinding) throws WsdlException {
        return this.isSoap12 ? Soap12Binding.attach(wsdlBinding) : SoapBinding.attach(wsdlBinding);
    }

    private SoapBindingOperation createSoapBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        return this.isSoap12 ? Soap12BindingOperation.attach(wsdlBindingOperation) : SoapBindingOperation.attach(wsdlBindingOperation);
    }

    private SoapBody createSoapBody(WsdlBindingMessage wsdlBindingMessage) {
        return this.isSoap12 ? Soap12Body.attach(wsdlBindingMessage) : SoapBody.attach(wsdlBindingMessage);
    }

    private SoapHeader createSoapHeader(WsdlBindingMessage wsdlBindingMessage) {
        return this.isSoap12 ? Soap12Header.attach(wsdlBindingMessage) : SoapHeader.attach(wsdlBindingMessage);
    }

    private SoapFault createSoapFault(WsdlBindingMessage wsdlBindingMessage) {
        return this.isSoap12 ? Soap12Fault.attach(wsdlBindingMessage) : SoapFault.attach(wsdlBindingMessage);
    }
}

