/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.wsdl;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import weblogic.jws.Binding;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.decl.CallbackServiceDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.tools.jws.wsdl.SoapBindingBuilder;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPartBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.builder.WsdlTypesBuilder;
import weblogic.wsee.wsdl.soap11.SoapAddress;
import weblogic.wsee.wsdl.soap12.Soap12Address;

public class WsdlBuilder
extends JAXRPCProcessor {
    private WsdlDefinitionsBuilder definitions;
    private BuildtimeBindings bindings;

    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (jAXRPCWebServiceInfo.getWebService().getCowReader() != null) {
            return;
        }
        this.bindings = jAXRPCWebServiceInfo.createBindings();
        try {
            WebServiceSEIDecl webServiceSEIDecl = jAXRPCWebServiceInfo.getWebService();
            jAXRPCWebServiceInfo.setDefinitions(this.createDefinitions(webServiceSEIDecl));
            this.buildWsdl(webServiceSEIDecl);
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException("Failed to generate WSDL", wsdlException);
        }
    }

    private WsdlDefinitions createDefinitions(WebServiceSEIDecl webServiceSEIDecl) {
        WsdlFactory wsdlFactory = WsdlFactory.getInstance();
        this.definitions = wsdlFactory.create();
        this.definitions.setName(webServiceSEIDecl.getServiceName() + "Definitions");
        this.definitions.setTargetNamespace(webServiceSEIDecl.getTargetNamespace());
        return this.definitions;
    }

    private void buildWsdl(WebServiceSEIDecl webServiceSEIDecl) throws WsdlException, WsBuildException {
        this.addTypes();
        WsdlServiceBuilder wsdlServiceBuilder = this.buildService(webServiceSEIDecl);
        WsdlPortTypeBuilder wsdlPortTypeBuilder = this.buildPortType(webServiceSEIDecl);
        this.buildBindings(webServiceSEIDecl, wsdlServiceBuilder, wsdlPortTypeBuilder, true);
        this.addCallBack(webServiceSEIDecl);
    }

    private boolean isSoap12(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(Binding.class);
        if (jAnnotation != null) {
            return Binding.Type.SOAP12.toString().equals(jAnnotation.getValue("value").asString());
        }
        return false;
    }

    private void buildBindings(WebServiceSEIDecl webServiceSEIDecl, WsdlServiceBuilder wsdlServiceBuilder, WsdlPortTypeBuilder wsdlPortTypeBuilder, boolean bl) throws WsdlException {
        ArrayList<PortDecl> arrayList = new ArrayList<PortDecl>();
        Iterator<PortDecl> iterator = webServiceSEIDecl.getPorts();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        for (PortDecl portDecl : arrayList) {
            SoapAddress soapAddress;
            SoapBindingBuilder soapBindingBuilder = new SoapBindingBuilder(this.definitions);
            boolean bl2 = this.isSoap12(webServiceSEIDecl.getEIClass());
            WsdlBinding wsdlBinding = soapBindingBuilder.buildSoapBinding(webServiceSEIDecl, wsdlPortTypeBuilder, portDecl, bl2, arrayList.size());
            WsdlPort wsdlPort = this.buildSoapPort(portDecl, wsdlServiceBuilder, wsdlBinding);
            if (!bl) continue;
            if (bl2) {
                soapAddress = Soap12Address.attach(wsdlPort);
                soapAddress.setLocation(portDecl.getURI());
                continue;
            }
            soapAddress = SoapAddress.attach(wsdlPort);
            soapAddress.setLocation(portDecl.getURI());
        }
    }

    private WsdlPort buildSoapPort(PortDecl portDecl, WsdlServiceBuilder wsdlServiceBuilder, WsdlBinding wsdlBinding) {
        QName qName = new QName(this.definitions.getTargetNamespace(), portDecl.getPortName());
        return wsdlServiceBuilder.addPort(qName, wsdlBinding);
    }

    private void addCallBack(WebServiceSEIDecl webServiceSEIDecl) throws WsdlException, WsBuildException {
        CallbackServiceDecl callbackServiceDecl = webServiceSEIDecl.getCallbackService();
        if (callbackServiceDecl != null) {
            WsdlServiceBuilder wsdlServiceBuilder = this.buildService(callbackServiceDecl);
            WsdlPortTypeBuilder wsdlPortTypeBuilder = this.buildPortType(callbackServiceDecl);
            this.buildBindings(callbackServiceDecl, wsdlServiceBuilder, wsdlPortTypeBuilder, false);
        }
    }

    private WsdlServiceBuilder buildService(WebServiceSEIDecl webServiceSEIDecl) {
        return this.definitions.addService(webServiceSEIDecl.getServiceQName());
    }

    private void addTypes() throws WsdlException {
        WsdlTypesBuilder wsdlTypesBuilder = this.definitions.addTypes();
        SchemaDocument[] schemaDocumentArray = this.bindings.getSchemas();
        wsdlTypesBuilder.addSchemas(schemaDocumentArray);
    }

    private WsdlPortTypeBuilder buildPortType(WebServiceSEIDecl webServiceSEIDecl) throws WsBuildException {
        WsdlPortTypeBuilder wsdlPortTypeBuilder = this.definitions.addPortType(new QName(this.definitions.getTargetNamespace(), webServiceSEIDecl.getPortType()));
        Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
        while (iterator.hasNext()) {
            this.populateOperation(wsdlPortTypeBuilder, iterator.next());
        }
        return wsdlPortTypeBuilder;
    }

    private void populateOperation(WsdlPortTypeBuilder wsdlPortTypeBuilder, WebMethodDecl webMethodDecl) throws WsBuildException {
        QName qName = new QName(this.definitions.getTargetNamespace(), webMethodDecl.getName());
        WsdlOperationBuilder wsdlOperationBuilder = wsdlPortTypeBuilder.addOperation(qName);
        WsdlMessageBuilder wsdlMessageBuilder = this.buildInputMessage(qName, webMethodDecl);
        this.setParameterOrder(wsdlOperationBuilder, webMethodDecl);
        wsdlOperationBuilder.setInput(wsdlMessageBuilder);
        if (!webMethodDecl.isOneway()) {
            WsdlMessageBuilder wsdlMessageBuilder2 = this.buildOutputMessage(qName, webMethodDecl);
            wsdlOperationBuilder.setOutput(wsdlMessageBuilder2);
        }
        this.buildFaultMessage(wsdlOperationBuilder, webMethodDecl.getJMethod());
    }

    private void setParameterOrder(WsdlOperationBuilder wsdlOperationBuilder, WebMethodDecl webMethodDecl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
            stringBuffer.append("parameters");
            object = webMethodDecl.getHeaderParams();
            while (object.hasNext()) {
                WebParamDecl webParamDecl = (WebParamDecl)object.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(webParamDecl.getPartName());
            }
        } else {
            object = webMethodDecl.getWebParams();
            while (object.hasNext()) {
                WebParamDecl webParamDecl = object.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(webParamDecl.getPartName());
            }
        }
        if (!StringUtil.isEmpty((String)(object = stringBuffer.toString()))) {
            wsdlOperationBuilder.setParameterOrder(stringBuffer.toString());
        }
    }

    private void buildFaultMessage(WsdlOperationBuilder wsdlOperationBuilder, JMethod jMethod) {
        JClass[] jClassArray = jMethod.getExceptionTypes();
        JClass jClass = (JClass)jMethod.getParent();
        for (int i = 0; i < jClassArray.length; ++i) {
            JClass jClass2 = jClassArray[i];
            if (!ExceptionUtil.isUserException(jClass2)) continue;
            QName qName = new QName(this.definitions.getTargetNamespace(), jClass2.getSimpleName());
            WsdlMessageBuilder wsdlMessageBuilder = this.definitions.getMessages().get(qName);
            if (wsdlMessageBuilder == null) {
                wsdlMessageBuilder = this.definitions.addMessage(qName);
                WsdlPartBuilder wsdlPartBuilder = wsdlMessageBuilder.addPart(jClass2.getSimpleName());
                if (ExceptionUtil.isMarshalPropertyException(jClass2)) {
                    wsdlPartBuilder.setElement(ExceptionUtil.exceptionMarshalPropertyElementName(jClass, jClass2));
                } else {
                    wsdlPartBuilder.setElement(this.bindings.getSchemaType(jClass2.getQualifiedName()));
                }
            }
            wsdlOperationBuilder.addFault(wsdlMessageBuilder, jClass2.getSimpleName());
        }
    }

    private WsdlMessageBuilder buildOutputMessage(QName qName, WebMethodDecl webMethodDecl) throws WsBuildException {
        WsdlMessageBuilder wsdlMessageBuilder;
        block11: {
            Object object;
            block10: {
                QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart() + "Response");
                wsdlMessageBuilder = this.definitions.addMessage(qName2);
                if (!webMethodDecl.getSoapBinding().isDocLiteralWrapped()) break block10;
                WsdlPartBuilder wsdlPartBuilder = wsdlMessageBuilder.addPart(webMethodDecl.getWebResult().getPartName());
                wsdlPartBuilder.setElement(qName2);
                Iterator<WebParamDecl> iterator = webMethodDecl.getHeaderParams();
                while (iterator.hasNext()) {
                    WebParamDecl webParamDecl = iterator.next();
                    if (webParamDecl.getMode() == WebParam.Mode.IN) continue;
                    wsdlPartBuilder = wsdlMessageBuilder.addPart(webParamDecl.getPartName());
                    if (webParamDecl.isXmlElement()) {
                        wsdlPartBuilder.setElement(webParamDecl.getElementQName());
                        continue;
                    }
                    wsdlPartBuilder.setElement(webParamDecl.getElementQName());
                }
                break block11;
            }
            JClass jClass = webMethodDecl.getJMethod().getReturnType();
            if (webMethodDecl.isOneway()) break block11;
            if (!jClass.isVoidType()) {
                object = wsdlMessageBuilder.addPart(webMethodDecl.getWebResult().getPartName());
                if (webMethodDecl.getSoapBinding().isDocumentStyle()) {
                    if (webMethodDecl.getWebResult().isXmlElement()) {
                        object.setElement(webMethodDecl.getWebResult().getElementQName());
                    } else {
                        object.setElement(webMethodDecl.getWebResult().getElementQName());
                    }
                } else {
                    this.setWsdlType((WsdlPartBuilder)object, jClass);
                }
            }
            object = webMethodDecl.getWebParams();
            while (object.hasNext()) {
                WebParamDecl webParamDecl = (WebParamDecl)object.next();
                if (webParamDecl.getMode() == WebParam.Mode.IN) continue;
                WsdlPartBuilder wsdlPartBuilder = wsdlMessageBuilder.addPart(webParamDecl.getPartName());
                if (webMethodDecl.getSoapBinding().isDocumentStyle() || webParamDecl.isHeader()) {
                    if (webParamDecl.isXmlElement()) {
                        wsdlPartBuilder.setElement(webParamDecl.getElementQName());
                        continue;
                    }
                    wsdlPartBuilder.setElement(webParamDecl.getElementQName());
                    continue;
                }
                this.setWsdlType(wsdlPartBuilder, webParamDecl.getRealType());
            }
        }
        return wsdlMessageBuilder;
    }

    private WsdlMessageBuilder buildInputMessage(QName qName, WebMethodDecl webMethodDecl) throws WsBuildException {
        WsdlMessageBuilder wsdlMessageBuilder = this.definitions.addMessage(qName);
        if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
            WsdlPartBuilder wsdlPartBuilder = wsdlMessageBuilder.addPart("parameters");
            wsdlPartBuilder.setElement(qName);
            Iterator<WebParamDecl> iterator = webMethodDecl.getHeaderParams();
            while (iterator.hasNext()) {
                WebParamDecl webParamDecl = iterator.next();
                if (webParamDecl.getMode() == WebParam.Mode.OUT) continue;
                wsdlPartBuilder = wsdlMessageBuilder.addPart(webParamDecl.getPartName());
                if (webParamDecl.isXmlElement()) {
                    wsdlPartBuilder.setElement(webParamDecl.getElementQName());
                    continue;
                }
                wsdlPartBuilder.setElement(webParamDecl.getElementQName());
            }
        } else {
            Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
            while (iterator.hasNext()) {
                WebParamDecl webParamDecl = iterator.next();
                if (webParamDecl.getMode() == WebParam.Mode.OUT) continue;
                WsdlPartBuilder wsdlPartBuilder = wsdlMessageBuilder.addPart(webParamDecl.getPartName());
                if (webMethodDecl.getSoapBinding().isDocumentStyle() || webParamDecl.isHeader() && webMethodDecl.getSoapBinding().isLiteral()) {
                    if (webParamDecl.isXmlElement()) {
                        wsdlPartBuilder.setElement(webParamDecl.getElementQName());
                        continue;
                    }
                    wsdlPartBuilder.setElement(webParamDecl.getElementQName());
                    continue;
                }
                this.setWsdlType(wsdlPartBuilder, webParamDecl.getRealType());
            }
        }
        return wsdlMessageBuilder;
    }

    public QName getXmlTypeFromParam() {
        return null;
    }

    private void setWsdlType(WsdlPartBuilder wsdlPartBuilder, JClass jClass) throws WsBuildException {
        QName qName = this.getXmlTypeFromParam();
        if (qName != null) {
            wsdlPartBuilder.setType(qName);
        } else {
            QName qName2 = this.bindings.getSchemaType(jClass.getQualifiedName());
            if (qName2 == null) {
                throw new WsBuildException("Unable to find XML type for java class:" + jClass);
            }
            wsdlPartBuilder.setType(qName2);
        }
    }
}

