/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.logging;

import java.io.File;
import org.apache.tools.ant.Task;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.LogEvent;
import weblogic.wsee.tools.logging.Logger;

public class AntLogger
implements Logger {
    protected Task task;

    public AntLogger(Task task) {
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    public void log(EventLevel eventLevel, LogEvent logEvent) {
        assert (eventLevel != null);
        assert (logEvent != null);
        this.log(eventLevel, this.getMessage(eventLevel, logEvent));
    }

    public void log(EventLevel eventLevel, String string) {
        int n = 0;
        switch (eventLevel) {
            case DEBUG: {
                n = 4;
                break;
            }
            case INFO: {
                n = 2;
                break;
            }
            case WARNING: {
                n = 1;
                break;
            }
            case ERROR: {
                n = 0;
                break;
            }
            case VERBOSE: {
                n = 3;
            }
        }
        this.task.log(string, n);
    }

    private String getMessage(EventLevel eventLevel, LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        if (logEvent.getSourceURI() != null) {
            File file = new File(logEvent.getSourceURI());
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append(' ');
            stringBuffer.append(logEvent.getLine());
            stringBuffer.append(':');
            stringBuffer.append(logEvent.getColumn());
        }
        stringBuffer.append('\n');
        stringBuffer.append('[');
        stringBuffer.append((Object)eventLevel);
        stringBuffer.append("] - ");
        return stringBuffer.toString() + logEvent.getText();
    }
}

