/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.logging;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.util.SourcePosition;
import java.io.File;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.LogEvent;
import weblogic.wsee.tools.logging.Logger;

public class AptLogger
implements Logger {
    private Messager messager = null;

    public AptLogger(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this.messager = annotationProcessorEnvironment.getMessager();
    }

    public void log(EventLevel eventLevel, LogEvent logEvent) {
        SourcePos sourcePos = null;
        String string = logEvent.getText();
        if (logEvent.getSourceURI() != null) {
            sourcePos = new SourcePos(logEvent);
        }
        this.log(eventLevel, sourcePos, string);
    }

    public void log(EventLevel eventLevel, String string) {
        this.log(eventLevel, null, string);
    }

    private void log(EventLevel eventLevel, SourcePosition sourcePosition, String string) {
        switch (eventLevel) {
            case WARNING: {
                this.printWarning(sourcePosition, string);
                break;
            }
            case ERROR: {
                this.printError(sourcePosition, string);
                break;
            }
            default: {
                this.printNotice(sourcePosition, string);
            }
        }
    }

    private void printNotice(SourcePosition sourcePosition, String string) {
        if (sourcePosition == null) {
            this.messager.printNotice(string);
        } else {
            this.messager.printNotice(sourcePosition, string);
        }
    }

    private void printError(SourcePosition sourcePosition, String string) {
        if (sourcePosition == null) {
            this.messager.printError(string);
        } else {
            this.messager.printError(sourcePosition, string);
        }
    }

    private void printWarning(SourcePosition sourcePosition, String string) {
        if (sourcePosition == null) {
            this.messager.printWarning(string);
        } else {
            this.messager.printWarning(sourcePosition, string);
        }
    }

    private static class SourcePos
    implements SourcePosition {
        private LogEvent logEvent = null;

        public SourcePos(LogEvent logEvent) {
            this.logEvent = logEvent;
        }

        public File file() {
            return new File(this.logEvent.getSourceURI());
        }

        public int line() {
            return this.logEvent.getLine();
        }

        public int column() {
            return this.logEvent.getColumn();
        }
    }
}

