/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;

public class BuildListenerLogger
implements BuildListener {
    private static final Map<Integer, EventLevel> PRIORITIES = new HashMap<Integer, EventLevel>();
    private final Logger logger;

    public BuildListenerLogger(Logger logger) {
        this.logger = logger;
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
        this.logger.log(this.getEventLevel(buildEvent.getPriority()), buildEvent.getMessage());
    }

    private EventLevel getEventLevel(int n) {
        EventLevel eventLevel = PRIORITIES.get(n);
        if (eventLevel == null) {
            eventLevel = EventLevel.VERBOSE;
        }
        return eventLevel;
    }

    static {
        PRIORITIES.put(0, EventLevel.ERROR);
        PRIORITIES.put(1, EventLevel.WARNING);
        PRIORITIES.put(2, EventLevel.INFO);
        PRIORITIES.put(3, EventLevel.VERBOSE);
        PRIORITIES.put(4, EventLevel.DEBUG);
    }
}

