/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.logging;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.LogEvent;
import weblogic.wsee.tools.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountLogger
implements Logger {
    private int debugCount = 0;
    private int infoCount = 0;
    private int warningCount = 0;
    private int errorCount = 0;
    private int verboseCount = 0;
    private List<String> errorMsgs = new ArrayList<String>();

    @Override
    public void log(EventLevel eventLevel, LogEvent logEvent) {
        assert (eventLevel != null);
        assert (logEvent != null);
        String string = logEvent.toString();
        this.log(eventLevel, string);
    }

    @Override
    public void log(EventLevel eventLevel, String string) {
        switch (eventLevel) {
            case DEBUG: {
                ++this.debugCount;
                break;
            }
            case INFO: {
                ++this.infoCount;
                break;
            }
            case WARNING: {
                ++this.warningCount;
                break;
            }
            case ERROR: {
                ++this.errorCount;
                this.errorMsgs.add(string);
                break;
            }
            case VERBOSE: {
                ++this.verboseCount;
            }
        }
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    public int getInfoCount() {
        return this.infoCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public int getVerboseCount() {
        return this.verboseCount;
    }
}

