/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.source;

import com.bea.staxb.buildtime.FaultMessage;
import com.bea.staxb.buildtime.WrappedOperationInfo;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.XmlException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.ByteArrayHolder;
import weblogic.wsee.bind.TypeFamily;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.S2JBindingsBuilder;
import weblogic.wsee.jaxrpc.Mime2JavaMapping;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.tools.source.JsParameterType;
import weblogic.wsee.tools.source.JsReturnType;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.tools.source.JsTypeBase;
import weblogic.wsee.util.ExceptionInfo;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.HolderUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.UniqueNameSet;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlMethod;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlParameter;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.builder.WsdlTypesBuilder;
import weblogic.wsee.wsdl.mime.MimeContent;
import weblogic.wsee.wsdl.mime.MimeMultipartRelated;
import weblogic.wsee.wsdl.mime.MimePart;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBindingUtil;
import weblogic.wsee.wsdl.soap11.SoapHeader;
import weblogic.wsee.wsdl.soap12.Soap12Binding;
import weblogic.wsee.wsdl.soap12.Soap12BindingOperation;
import weblogic.xml.schema.binding.internal.NameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointBuilder {
    private static final boolean verbose = Verbose.isVerbose(EndpointBuilder.class);
    private WsdlDefinitionsBuilder definitions;
    private BuildtimeBindings bindingProvider;
    private String packageName;
    private boolean autoDetectWrapped = true;
    private boolean jaxRPCWrappedArrayStyle = true;
    private boolean generateAsyncMethods = true;
    private boolean alwaysUseDataHandlerForMimeTypes = false;
    private boolean allowWrappedArrayForDocLiteral = false;
    private boolean sortSchemaTypes = false;
    private boolean includeGlobalTypes = false;
    private boolean fillIncompleteParameterOrderList = false;
    private Map<QName, JsClass> endpoints;
    private boolean wlw81CallbackGen = false;

    public EndpointBuilder(WsdlDefinitions wsdlDefinitions, File file, String string) throws IOException, XmlException {
        this(wsdlDefinitions, file, string, true, true);
    }

    public EndpointBuilder(WsdlDefinitions wsdlDefinitions, File file, String string, boolean bl, boolean bl2) throws IOException, XmlException {
        this(wsdlDefinitions, file, string, bl, bl2, TypeFamily.TYLAR, null, null, false, false, false, false);
    }

    public EndpointBuilder(WsdlDefinitions wsdlDefinitions, File file, String string, boolean bl, boolean bl2, TypeFamily typeFamily, ClassLoader classLoader, boolean bl3) throws IOException, XmlException {
        this(wsdlDefinitions, file, string, bl, bl2, typeFamily, classLoader, null, bl3, false, false, false);
    }

    public EndpointBuilder(WsdlDefinitions wsdlDefinitions, File file, String string, boolean bl, boolean bl2, TypeFamily typeFamily, ClassLoader classLoader, File[] fileArray, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IOException, XmlException {
        this.definitions = (WsdlDefinitionsBuilder)wsdlDefinitions;
        this.packageName = string;
        this.setJaxRPCWrappedArrayStyle(bl);
        this.setAutoDetectWrapped(bl2);
        this.setAllowWrappedArrayForDocLiteral(bl3);
        this.setSortSchemaTypes(bl4);
        this.setFillIncompleteParameterOrderList(bl5);
        this.setIncludeGlobalTypes(bl6);
        S2JBindingsBuilder s2JBindingsBuilder = this.createBindingsBuilder(typeFamily, fileArray);
        if (classLoader != null) {
            s2JBindingsBuilder.addBaseTypeLibrary(classLoader);
        }
        this.bindingProvider = EndpointBuilder.setupBindingProvider(s2JBindingsBuilder, this.definitions, file, null, bl2, bl6, this.allowWrappedArrayForDocLiteral, bl4);
    }

    public void setWlw81CallbackGen(boolean bl) {
        this.wlw81CallbackGen = bl;
    }

    private S2JBindingsBuilder createBindingsBuilder(TypeFamily typeFamily, File[] fileArray) {
        S2JBindingsBuilder s2JBindingsBuilder = null;
        if (typeFamily.equals(TypeFamily.TYLAR)) {
            s2JBindingsBuilder = S2JBindingsBuilder.Factory.createTylarBindingsBuilder();
            s2JBindingsBuilder.setJaxRPCWrappedArrayStyle(this.jaxRPCWrappedArrayStyle);
        } else if (typeFamily.equals(TypeFamily.XMLBEANS)) {
            s2JBindingsBuilder = S2JBindingsBuilder.Factory.createXmlBeansBindingsBuilder();
        } else if (typeFamily.equals(TypeFamily.XMLBEANS_APACHE)) {
            s2JBindingsBuilder = S2JBindingsBuilder.Factory.createXmlBeansApacheBindingsBuilder();
        }
        s2JBindingsBuilder.setXsdConfig(fileArray);
        return s2JBindingsBuilder;
    }

    public EndpointBuilder(WsdlDefinitions wsdlDefinitions, BuildtimeBindings buildtimeBindings, String string) {
        this.definitions = (WsdlDefinitionsBuilder)wsdlDefinitions;
        this.packageName = string;
        this.bindingProvider = buildtimeBindings;
    }

    public BuildtimeBindings getBuildtimeBindings() {
        return this.bindingProvider;
    }

    public String getPackageName() {
        if (StringUtil.isEmpty(this.packageName)) {
            this.packageName = com.bea.xbean.common.NameUtil.getPackageFromNamespace((String)this.definitions.getTargetNamespace(), (boolean)true);
        }
        return this.packageName;
    }

    public void setAutoDetectWrapped(boolean bl) {
        this.autoDetectWrapped = bl;
    }

    public void setJaxRPCWrappedArrayStyle(boolean bl) {
        this.jaxRPCWrappedArrayStyle = bl;
    }

    public void setGenerateAsyncMethods(boolean bl) {
        this.generateAsyncMethods = bl;
    }

    public void setAlwaysUseDataHandlerForMimeTypes(boolean bl) {
        this.alwaysUseDataHandlerForMimeTypes = bl;
    }

    public Map<QName, JsClass> build() throws WsdlException {
        this.endpoints = new HashMap<QName, JsClass>();
        for (WsdlServiceBuilder wsdlServiceBuilder : this.definitions.getServices().values()) {
            for (WsdlPortBuilder wsdlPortBuilder : wsdlServiceBuilder.getPorts().values()) {
                WsdlBindingBuilder wsdlBindingBuilder = wsdlPortBuilder.getBinding();
                if (this.endpoints.get(wsdlBindingBuilder.getName()) != null || this.getAnySoapBinding(wsdlBindingBuilder) == null) continue;
                JsClass jsClass = this.buildEndpoint(wsdlBindingBuilder);
                this.markSoapHeaderPart(wsdlBindingBuilder, jsClass);
                if (verbose) {
                    Verbose.log("Endpoint class: " + jsClass);
                }
                this.endpoints.put(wsdlBindingBuilder.getName(), jsClass);
            }
        }
        return this.endpoints;
    }

    private SoapBinding getAnySoapBinding(WsdlBinding wsdlBinding) {
        SoapBinding soapBinding = SoapBinding.narrow(wsdlBinding);
        if (soapBinding == null) {
            soapBinding = Soap12Binding.narrow(wsdlBinding);
        }
        return soapBinding;
    }

    private SoapBindingOperation getAnySoapBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        SoapBindingOperation soapBindingOperation = SoapBindingOperation.narrow(wsdlBindingOperation);
        if (soapBindingOperation == null) {
            soapBindingOperation = Soap12BindingOperation.narrow(wsdlBindingOperation);
        }
        return soapBindingOperation;
    }

    public JsClass buildJsClass(QName qName) throws WsBuildException {
        for (WsdlServiceBuilder wsdlServiceBuilder : this.definitions.getServices().values()) {
            WsdlBinding wsdlBinding;
            JsClass jsClass;
            WsdlPort wsdlPort = wsdlServiceBuilder.getPorts().get(qName);
            if (wsdlPort == null || (jsClass = this.endpoints.get((wsdlBinding = wsdlPort.getBinding()).getName())) == null) continue;
            return jsClass;
        }
        throw new WsBuildException("Could not find Endpoint for port " + qName);
    }

    public JsService buildJsService(QName qName) throws WsdlException {
        WsdlServiceBuilder wsdlServiceBuilder = this.definitions.getServices().get(qName);
        if (wsdlServiceBuilder == null) {
            throw new IllegalArgumentException("Wsdl service " + qName + " is not found in wsdl definition");
        }
        JsService jsService = new JsService(wsdlServiceBuilder);
        HashMap<QName, JsClass> hashMap = new HashMap<QName, JsClass>();
        for (WsdlPortBuilder wsdlPortBuilder : wsdlServiceBuilder.getPorts().values()) {
            if (this.getAnySoapBinding(wsdlPortBuilder.getBinding()) == null) continue;
            JsClass jsClass = (JsClass)hashMap.get(wsdlPortBuilder.getBinding().getPortType().getName());
            if (jsClass == null) {
                jsClass = this.buildEndpoint(wsdlPortBuilder.getBinding());
                this.markSoapHeaderPart(wsdlPortBuilder.getBinding(), jsClass);
                hashMap.put(wsdlPortBuilder.getBinding().getPortType().getName(), jsClass);
            }
            jsService.addPort(wsdlPortBuilder.getName().getLocalPart(), wsdlPortBuilder, jsClass);
        }
        return jsService;
    }

    private void markSoapHeaderPart(WsdlBinding wsdlBinding, JsClass jsClass) throws WsdlException {
        WsdlPortType wsdlPortType = wsdlBinding.getPortType();
        SoapBinding soapBinding = this.getAnySoapBinding(wsdlBinding);
        if (soapBinding == null) {
            return;
        }
        for (WsdlBindingOperation wsdlBindingOperation : wsdlBinding.getOperations().values()) {
            JsMethod jsMethod;
            try {
                jsMethod = jsClass.getMethod(wsdlBindingOperation.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                jsMethod = null;
            }
            if (jsMethod == null) continue;
            QName qName = wsdlBindingOperation.getName();
            WsdlOperation wsdlOperation = wsdlPortType.getOperations().get(qName);
            if (wsdlOperation == null) {
                throw new WsdlException("There is a problem with the wsdl; the 'wsdl:binding' operation: \n" + qName + "\n" + "does not have a matching 'wsdl:portType' operation.\n");
            }
            if (wsdlBindingOperation.getInput() != null) {
                this.findSoapHeaderPart(jsMethod, qName, wsdlBindingOperation.getInput(), wsdlOperation.getInput());
                this.findMimeBinding(jsMethod, wsdlBindingOperation.getInput());
            }
            if (wsdlBindingOperation.getOutput() == null) continue;
            this.findSoapHeaderPart(jsMethod, qName, wsdlBindingOperation.getOutput(), wsdlOperation.getOutput());
            this.findMimeBinding(jsMethod, wsdlBindingOperation.getOutput());
            this.findMimeBindingForReturnType(jsMethod, wsdlBindingOperation.getOutput());
        }
    }

    private static String findMimeContent(String string, List<MimeContent> list) {
        for (MimeContent mimeContent : list) {
            if (!string.equals(mimeContent.getPart())) continue;
            return mimeContent.getType();
        }
        return null;
    }

    private void findMimeBinding(JsMethod jsMethod, WsdlBindingMessage wsdlBindingMessage) {
        MimeMultipartRelated mimeMultipartRelated = MimeMultipartRelated.narrow(wsdlBindingMessage);
        if (mimeMultipartRelated != null) {
            JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
            List<MimePart> list = mimeMultipartRelated.getParts();
            ArrayList<JsParameterType> arrayList = new ArrayList<JsParameterType>();
            jsMethod.resetArgument(arrayList);
            ArrayList<MimeContent> arrayList2 = new ArrayList<MimeContent>();
            for (MimePart object : list) {
                arrayList2.addAll(MimeContent.narrow(object));
            }
            for (int i = 0; i < jsParameterTypeArray.length; ++i) {
                JsParameterType jsParameterType = jsParameterTypeArray[i];
                String string = null;
                string = EndpointBuilder.findMimeContent(jsParameterType.getPartName(), arrayList2);
                if (string != null) {
                    jsMethod.addJsParameterType(this.updateParam(jsParameterType, string));
                    continue;
                }
                jsMethod.addJsParameterType(jsParameterType);
            }
            this.resolveUniqueParamName(jsMethod);
        }
    }

    private void findMimeBindingForReturnType(JsMethod jsMethod, WsdlBindingMessage wsdlBindingMessage) {
        MimeMultipartRelated mimeMultipartRelated;
        if (!"void".equals(jsMethod.getReturnType().getType()) && (mimeMultipartRelated = MimeMultipartRelated.narrow(wsdlBindingMessage)) != null) {
            JsReturnType jsReturnType = jsMethod.getReturnType();
            List<MimePart> list = mimeMultipartRelated.getParts();
            ArrayList<MimeContent> arrayList = new ArrayList<MimeContent>();
            for (MimePart mimePart : list) {
                arrayList.addAll(MimeContent.narrow(mimePart));
            }
            Object object = null;
            object = EndpointBuilder.findMimeContent(jsReturnType.getPartName(), arrayList);
            if (object != null) {
                jsReturnType.setType(this.getJavaType((String)object));
            }
        }
    }

    private JsParameterType updateParam(JsParameterType jsParameterType, String string) {
        if (jsParameterType.getMode() > 0) {
            String string2 = this.getJavaType(string);
            jsParameterType.setNonHolderType(string2);
            jsParameterType.setType(HolderUtil.getMimeBindingJavaHolderTypeFromMimeBindingJavaType(string2));
        } else {
            jsParameterType.setType(this.getJavaType(string));
        }
        return jsParameterType;
    }

    private String getJavaType(String string) {
        String string2 = this.alwaysUseDataHandlerForMimeTypes ? "javax.activation.DataHandler" : Mime2JavaMapping.getJavaTypeFromMime(string);
        if (string2 == null) {
            string2 = "javax.activation.DataHandler";
        }
        return string2;
    }

    private void findSoapHeaderPart(JsMethod jsMethod, QName qName, WsdlBindingMessage wsdlBindingMessage, WsdlMessage wsdlMessage) {
        QName qName2 = wsdlMessage.getName();
        for (List<WsdlExtension> list : wsdlBindingMessage.getExtensions().values()) {
            for (WsdlExtension wsdlExtension : list) {
                if (!(wsdlExtension instanceof SoapHeader)) continue;
                SoapHeader soapHeader = (SoapHeader)wsdlExtension;
                if (qName2.equals(soapHeader.getMessage())) {
                    String string = soapHeader.getPart();
                    JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
                    for (int i = 0; i < jsParameterTypeArray.length; ++i) {
                        JsParameterType jsParameterType = jsParameterTypeArray[i];
                        if (!string.equals(jsParameterType.getPartName())) continue;
                        jsParameterType.setSoapHeader(true);
                    }
                    continue;
                }
                System.out.println("[WARNING] The binding soap:header element for binding operation: \n" + qName + "\n" + "is being IGNORED because its message: \n" + soapHeader.getMessage() + "\n" + "does not match the corresponding input/output portType message: \n" + qName2 + "\n" + "To handle this soap header, you need to add a handler to your client.\n");
            }
        }
    }

    private JsClass buildEndpoint(WsdlBindingBuilder wsdlBindingBuilder) {
        WsdlPortTypeBuilder wsdlPortTypeBuilder = wsdlBindingBuilder.getPortType();
        if (verbose) {
            Verbose.log("building port type:" + wsdlPortTypeBuilder.getName());
        }
        JsClass jsClass = new JsClass();
        jsClass.setName(wsdlPortTypeBuilder.getName().getLocalPart());
        jsClass.setNamespaceURI(wsdlPortTypeBuilder.getName().getNamespaceURI());
        jsClass.setBindingName(wsdlBindingBuilder.getName());
        jsClass.setPackageName(this.getPackageName());
        SoapBinding soapBinding = this.getAnySoapBinding(wsdlBindingBuilder);
        if (soapBinding == null) {
            throw new IllegalArgumentException("Wsdl binding " + wsdlBindingBuilder.getName() + " is not a soap doesn't have a soap binding.");
        }
        for (WsdlOperationBuilder wsdlOperationBuilder : wsdlPortTypeBuilder.getOperations().values()) {
            WsdlBindingOperation wsdlBindingOperation = wsdlBindingBuilder.getOperations().get(wsdlOperationBuilder.getName());
            String string = null;
            String string2 = null;
            String string3 = "";
            if (wsdlBindingOperation != null) {
                SoapBindingOperation soapBindingOperation = this.getAnySoapBindingOperation(wsdlBindingOperation);
                string = SoapBindingUtil.getStyle(soapBindingOperation, soapBinding);
                string2 = SoapBindingUtil.getUse(wsdlBindingOperation.getInput(), wsdlBindingOperation.getOutput());
                if (string.equals("document") && string2 != null && string2.equals("encoded")) {
                    throw new IllegalArgumentException("Document Encoded style webservice is not supported");
                }
                if (soapBindingOperation != null) {
                    string3 = soapBindingOperation.getSoapAction();
                }
            }
            this.addMethod(jsClass, wsdlOperationBuilder, string, string3, string2);
        }
        EndpointBuilder.resolveMethodNames(jsClass);
        return jsClass;
    }

    private static void resolveMethodNames(JsClass jsClass) {
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        JsMethod[] jsMethodArray = jsClass.getMethods();
        for (int i = 0; i < jsMethodArray.length; ++i) {
            JsMethod jsMethod = jsMethodArray[i];
            String string = NameUtil.getJAXRPCMethodName((String)jsMethod.getOperationName().getLocalPart());
            jsMethod.setMethodName(uniqueNameSet.add(string));
        }
    }

    protected void addMethod(JsClass jsClass, WsdlOperationBuilder wsdlOperationBuilder, String string, String string2, String string3) {
        if (verbose) {
            Verbose.log("Building operation: " + wsdlOperationBuilder.getName());
        }
        boolean bl = wsdlOperationBuilder.isWLW81CallbackOperation();
        if (this.wlw81CallbackGen && !bl || !this.wlw81CallbackGen && bl) {
            return;
        }
        boolean bl2 = this.detectWrappedVirtual(this.autoDetectWrapped, wsdlOperationBuilder);
        JsMethod jsMethod = jsClass.addMethod(wsdlOperationBuilder.getName());
        jsMethod.setStyle(string);
        jsMethod.setUse(string3);
        if (wsdlOperationBuilder.getType() == 1) {
            jsMethod.setOneWay(true);
        }
        jsMethod.setGenerateAsync(this.generateAsyncMethods);
        jsMethod.setWrapped(bl2);
        jsMethod.setSoapAction(string2);
        if ("document".equals(string)) {
            this.createDocumentParams(wsdlOperationBuilder, jsMethod);
        } else {
            this.createParams(false, jsMethod, wsdlOperationBuilder);
        }
        if (this.bindingProvider.useCheckedExceptionFromWsdlFault()) {
            this.addExceptions(jsMethod, wsdlOperationBuilder);
        }
        this.resolveUniqueParamName(jsMethod);
    }

    private void createDocumentParams(WsdlOperationBuilder wsdlOperationBuilder, JsMethod jsMethod) {
        if (jsMethod.isWrapped()) {
            WsdlMessageBuilder wsdlMessageBuilder;
            WsdlMessageBuilder wsdlMessageBuilder2;
            if (wsdlOperationBuilder.isWrappedWLW81Callback()) {
                wsdlMessageBuilder2 = wsdlOperationBuilder.getOutput();
                wsdlMessageBuilder = wsdlOperationBuilder.getInput();
            } else {
                wsdlMessageBuilder2 = wsdlOperationBuilder.getInput();
                wsdlMessageBuilder = wsdlOperationBuilder.getOutput();
            }
            WsdlPart wsdlPart = wsdlMessageBuilder2.getParts().values().iterator().next();
            LinkedHashMap linkedHashMap = this.bindingProvider.getJavaTypesForWrapperElement(wsdlPart.getElement());
            LinkedHashMap linkedHashMap2 = this.getRtnTypesFromWrappedOutputMessage(wsdlMessageBuilder);
            if (linkedHashMap != null && linkedHashMap2 != null && linkedHashMap2.size() <= 1) {
                for (Map.Entry object : linkedHashMap.entrySet()) {
                    JsParameterType jsParameterType = jsMethod.addArgument((String)object.getKey(), (String)object.getValue());
                    jsParameterType.setMode(0);
                }
                if (wsdlMessageBuilder != null && linkedHashMap2.size() == 1) {
                    Map.Entry entry = linkedHashMap2.entrySet().iterator().next();
                    JsReturnType jsReturnType = jsMethod.setReturnType((String)entry.getValue());
                    jsReturnType.setPartName((String)entry.getKey());
                }
                return;
            }
        }
        jsMethod.setWrapped(false);
        this.createParams(true, jsMethod, wsdlOperationBuilder);
    }

    private LinkedHashMap getRtnTypesFromWrappedOutputMessage(WsdlMessage wsdlMessage) {
        if (wsdlMessage != null) {
            WsdlPart wsdlPart = wsdlMessage.getParts().values().iterator().next();
            LinkedHashMap linkedHashMap = this.bindingProvider.getJavaTypesForWrapperElement(wsdlPart.getElement());
            return linkedHashMap;
        }
        return new LinkedHashMap();
    }

    private void createParams(boolean bl, JsMethod jsMethod, WsdlOperation wsdlOperation) {
        WsdlMethod wsdlMethod = wsdlOperation.getWsdlMethod(this.fillIncompleteParameterOrderList);
        for (WsdlParameter wsdlParameter : wsdlMethod.getParameters()) {
            this.addPart(jsMethod, wsdlParameter.getInPart(), wsdlParameter.getOutPart(), bl);
        }
        WsdlPart wsdlPart = wsdlMethod.getResultPart();
        if (wsdlPart != null) {
            this.setReturnType(jsMethod, wsdlPart, bl);
        }
    }

    private void addExceptions(JsMethod jsMethod, WsdlOperation wsdlOperation) {
        wsdlOperation.getFaults().values();
        for (WsdlMessage wsdlMessage : wsdlOperation.getFaults().values()) {
            Iterator<? extends WsdlPart> iterator = wsdlMessage.getParts().values().iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Fault WsdlMessage " + wsdlMessage.getName() + " doens't have a single part.");
            }
            WsdlPart wsdlPart = iterator.next();
            ExceptionInfo exceptionInfo = ExceptionUtil.getExceptionInfo(this.bindingProvider, wsdlMessage);
            if (verbose) {
                Verbose.log(exceptionInfo.toString());
            }
            String string = exceptionInfo.getOnWireClassName();
            String string2 = exceptionInfo.getSimpleExceptionWrapperClassName();
            List list = exceptionInfo.getConstructorElementNames();
            if (string == null) {
                throw new AssertionError((Object)("Java exception mapping for wsdl message " + wsdlMessage.getName() + " is not found."));
            }
            jsMethod.addFault(wsdlMessage.getName(), wsdlPart.getName(), string, string2, list);
            if (!iterator.hasNext()) continue;
            throw new IllegalStateException("Fault WsdlMessage " + wsdlMessage.getName() + " has more than one part.");
        }
    }

    private void resolveUniqueParamName(JsMethod jsMethod) {
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
        for (int i = 0; i < jsParameterTypeArray.length; ++i) {
            JsParameterType jsParameterType = jsParameterTypeArray[i];
            String string = uniqueNameSet.add(JsTypeBase.getJavaName(jsParameterType.getPartName()));
            jsParameterType.setParamName(string);
            jsParameterType.setPartName(jsParameterType.getPartName());
        }
    }

    private void setReturnType(JsMethod jsMethod, WsdlPart wsdlPart, boolean bl) {
        if (verbose) {
            Verbose.log("building return type: " + wsdlPart.getName());
        }
        String string = this.getJavaClassName(wsdlPart);
        JsReturnType jsReturnType = jsMethod.setReturnType(string);
        jsReturnType.setPartName(wsdlPart.getName());
        if (bl) {
            jsReturnType.setElement(wsdlPart.getElement());
        } else {
            jsReturnType.setDocStyle(false);
        }
    }

    private void addPart(JsMethod jsMethod, WsdlPart wsdlPart, WsdlPart wsdlPart2, boolean bl) {
        JsParameterType jsParameterType;
        QName qName;
        if (wsdlPart != null) {
            qName = wsdlPart.getElement();
            String string = this.getJavaClassName(wsdlPart);
            jsParameterType = jsMethod.addArgument(wsdlPart.getName(), string);
            if (wsdlPart2 == null || bl && qName == null) {
                jsParameterType.setMode(0);
            } else {
                jsParameterType.setMode(2);
                jsParameterType.setNonHolderType(string);
                if (qName != null) {
                    jsParameterType.setType(HolderUtil.NameCollisionsFilter.getInstance().filterFullName(this.getHolderClass(string, qName)));
                } else {
                    jsParameterType.setType(HolderUtil.NameCollisionsFilter.getInstance().filterFullName(this.getHolderClass(string, wsdlPart.getType())));
                }
            }
        } else {
            qName = wsdlPart2.getElement();
            String string = this.getJavaClassName(wsdlPart2);
            jsParameterType = jsMethod.addArgument(wsdlPart2.getName(), string);
            jsParameterType.setMode(1);
            jsParameterType.setNonHolderType(string);
            if (qName != null) {
                jsParameterType.setType(HolderUtil.NameCollisionsFilter.getInstance().filterFullName(this.getHolderClass(string, qName)));
            } else {
                jsParameterType.setType(HolderUtil.NameCollisionsFilter.getInstance().filterFullName(this.getHolderClass(string, wsdlPart2.getType())));
            }
        }
        if (bl) {
            jsParameterType.setElement(qName);
        } else {
            jsParameterType.setDocStyle(false);
        }
    }

    private String getHolderClass(String string, QName qName) {
        String string2 = HolderUtil.getStandardHolder(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = qName.getNamespaceURI();
        if (("http://www.w3.org/2001/XMLSchema".equals(string3) || "http://schemas.xmlsoap.org/soap/encoding/".equals(string3) || "http://www.w3.org/2003/05/soap-encoding".equals(string3)) && (string2 = this.getStandardSchemaHolder(qName)) != null) {
            return string2;
        }
        if (string.startsWith("java.") || string.startsWith("javax.") || HolderUtil.isPrimitiveType(string) || string.startsWith("[") || string.endsWith("[]")) {
            String string4 = com.bea.xbean.common.NameUtil.getPackageFromNamespace((String)qName.getNamespaceURI(), (boolean)true);
            string4 = StringUtil.isEmpty(string4) ? "holders" : string4 + ".holders";
            String string5 = NameUtil.getJAXRPCClassName((String)qName.getLocalPart());
            string2 = string4 + "." + string5 + "Holder";
        } else {
            string2 = HolderUtil.getHolderClass(string);
        }
        return string2;
    }

    private String getStandardSchemaHolder(QName qName) {
        if ("base64Binary".equals(qName.getLocalPart()) || "hexBinary".equals(qName.getLocalPart()) || "base64".equals(qName.getLocalPart())) {
            return ByteArrayHolder.class.getName();
        }
        return null;
    }

    private String getJavaClassName(WsdlPart wsdlPart) {
        String string = null;
        string = wsdlPart.getElement() != null ? this.bindingProvider.getClassFromSchemaElement(wsdlPart.getElement()) : this.bindingProvider.getClassFromSchemaType(wsdlPart.getType());
        return string;
    }

    public static BuildtimeBindings setupBindingProvider(S2JBindingsBuilder s2JBindingsBuilder, WsdlDefinitionsBuilder wsdlDefinitionsBuilder, File file, WsdlServiceBuilder wsdlServiceBuilder, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws XmlException, IOException {
        WsdlServiceBuilder[] wsdlServiceBuilderArray = null;
        if (wsdlServiceBuilder != null) {
            wsdlServiceBuilderArray = new WsdlServiceBuilder[]{wsdlServiceBuilder};
        }
        return EndpointBuilder.setupBindingProviderWithServices(s2JBindingsBuilder, wsdlDefinitionsBuilder, file, wsdlServiceBuilderArray, bl, bl2, bl3, bl4);
    }

    public static BuildtimeBindings setupBindingProvider(S2JBindingsBuilder s2JBindingsBuilder, WsdlDefinitionsBuilder wsdlDefinitionsBuilder, File file, WsdlServiceBuilder wsdlServiceBuilder, boolean bl, boolean bl2, boolean bl3) throws XmlException, IOException {
        return EndpointBuilder.setupBindingProvider(s2JBindingsBuilder, wsdlDefinitionsBuilder, file, wsdlServiceBuilder, bl, false, bl2, bl3);
    }

    public static BuildtimeBindings setupBindingProviderWithServices(S2JBindingsBuilder s2JBindingsBuilder, WsdlDefinitionsBuilder wsdlDefinitionsBuilder, File file, WsdlServiceBuilder[] wsdlServiceBuilderArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws XmlException, IOException {
        if (verbose) {
            Verbose.log("Setting up binding provider");
        }
        s2JBindingsBuilder.setCodegenDir(file);
        WsdlTypesBuilder wsdlTypesBuilder = wsdlDefinitionsBuilder.getTypes();
        if (wsdlTypesBuilder != null) {
            SchemaDocument[] schemaDocumentArray = wsdlTypesBuilder.getSchemaArrayWithoutImport();
            for (int i = 0; i < schemaDocumentArray.length; ++i) {
                s2JBindingsBuilder.addSchemaDocument(schemaDocumentArray[i]);
            }
        }
        s2JBindingsBuilder.includeGlobalTypes(bl2);
        s2JBindingsBuilder.sortSchemaTypes(bl4);
        if (wsdlServiceBuilderArray != null && wsdlServiceBuilderArray.length > 0) {
            for (WsdlServiceBuilder wsdlServiceBuilder : wsdlServiceBuilderArray) {
                EndpointBuilder.addTypesByWsdlService(wsdlServiceBuilder, s2JBindingsBuilder, bl, bl3);
            }
        } else {
            for (WsdlServiceBuilder wsdlServiceBuilder : wsdlDefinitionsBuilder.getServices().values()) {
                EndpointBuilder.addTypesByWsdlService(wsdlServiceBuilder, s2JBindingsBuilder, bl, bl3);
            }
        }
        return s2JBindingsBuilder.createBuildtimeBindings(file, wsdlDefinitionsBuilder);
    }

    private static void addTypesByWsdlService(WsdlServiceBuilder wsdlServiceBuilder, S2JBindingsBuilder s2JBindingsBuilder, boolean bl, boolean bl2) {
        if (wsdlServiceBuilder == null) {
            throw new RuntimeException("Service passed is null!");
        }
        if (verbose) {
            Verbose.log("Setting up binding provider");
        }
        for (WsdlPortTypeBuilder wsdlPortTypeBuilder : wsdlServiceBuilder.getPortTypes()) {
            for (WsdlOperationBuilder wsdlOperationBuilder : wsdlPortTypeBuilder.getOperations().values()) {
                Object object;
                if (EndpointBuilder.detectWrapped(bl, wsdlOperationBuilder)) {
                    WsdlMessageBuilder wsdlMessageBuilder;
                    if (wsdlOperationBuilder.isWrappedWLW81Callback()) {
                        object = wsdlOperationBuilder.getOutput();
                        wsdlMessageBuilder = wsdlOperationBuilder.getInput();
                    } else {
                        object = wsdlOperationBuilder.getInput();
                        wsdlMessageBuilder = wsdlOperationBuilder.getOutput();
                    }
                    WsdlPart wsdlPart = object.getParts().values().iterator().next();
                    QName qName = null;
                    if (wsdlMessageBuilder != null) {
                        WsdlPart wsdlPart2 = wsdlMessageBuilder.getParts().values().iterator().next();
                        qName = wsdlPart2.getElement();
                    }
                    s2JBindingsBuilder.addWrapperOperation(new WrappedOperationInfo(wsdlPart.getElement(), qName, bl2));
                } else {
                    if (wsdlOperationBuilder.getInput() != null) {
                        EndpointBuilder.addParamsToBinding(wsdlOperationBuilder.getInput(), s2JBindingsBuilder);
                    }
                    if (wsdlOperationBuilder.getOutput() != null) {
                        EndpointBuilder.addParamsToBinding(wsdlOperationBuilder.getOutput(), s2JBindingsBuilder);
                    }
                    if (wsdlOperationBuilder.getInput() != null && wsdlOperationBuilder.getOutput() != null) {
                        EndpointBuilder.addInoutTypes(wsdlOperationBuilder, s2JBindingsBuilder);
                    }
                }
                object = wsdlOperationBuilder.getFaults().values().iterator();
                while (object.hasNext()) {
                    EndpointBuilder.addFaultsToBinding((WsdlMessage)object.next(), s2JBindingsBuilder);
                }
            }
        }
    }

    private static void addInoutTypes(WsdlOperation wsdlOperation, S2JBindingsBuilder s2JBindingsBuilder) {
        WsdlMessage wsdlMessage = wsdlOperation.getOutput();
        String string = WsdlUtils.findReturnPart(wsdlOperation);
        for (WsdlPart wsdlPart : wsdlMessage.getParts().values()) {
            if (wsdlPart.getName().equals(string)) continue;
            if (wsdlPart.getType() != null) {
                s2JBindingsBuilder.addHolderType(wsdlPart.getType());
                continue;
            }
            s2JBindingsBuilder.addHolderElement(wsdlPart.getElement());
        }
    }

    private static void addParamsToBinding(WsdlMessage wsdlMessage, S2JBindingsBuilder s2JBindingsBuilder) {
        for (WsdlPart wsdlPart : wsdlMessage.getParts().values()) {
            if (wsdlPart.getType() != null) {
                s2JBindingsBuilder.addParamType(wsdlPart.getType());
                continue;
            }
            s2JBindingsBuilder.addParamElement(wsdlPart.getElement());
        }
    }

    private static void addFaultsToBinding(WsdlMessage wsdlMessage, S2JBindingsBuilder s2JBindingsBuilder) {
        Iterator<? extends WsdlPart> iterator = wsdlMessage.getParts().values().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("Fault WsdlMessage " + wsdlMessage.getName() + " doens't have a single part.");
        }
        WsdlPart wsdlPart = iterator.next();
        if (wsdlPart.getType() != null) {
            s2JBindingsBuilder.addFaultType(new FaultMessage(wsdlPart.getType(), wsdlMessage.getName(), wsdlPart.getName()));
        } else {
            s2JBindingsBuilder.addFaultElement(new FaultMessage(wsdlPart.getElement(), wsdlMessage.getName(), wsdlPart.getName()));
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("Fault WsdlMessage " + wsdlMessage.getName() + " has more than one part.");
        }
    }

    protected boolean detectWrappedVirtual(boolean bl, WsdlOperation wsdlOperation) {
        return EndpointBuilder.detectWrapped(bl, wsdlOperation);
    }

    private static boolean detectWrapped(boolean bl, WsdlOperation wsdlOperation) {
        return bl && wsdlOperation.isWrapped();
    }

    public void setAllowWrappedArrayForDocLiteral(boolean bl) {
        this.allowWrappedArrayForDocLiteral = bl;
    }

    public void setSortSchemaTypes(boolean bl) {
        this.sortSchemaTypes = bl;
    }

    public void setFillIncompleteParameterOrderList(boolean bl) {
        this.fillIncompleteParameterOrderList = bl;
    }

    public void setIncludeGlobalTypes(boolean bl) {
        this.includeGlobalTypes = bl;
    }
}

