/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.source;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.util.HashCodeBuilder;
import weblogic.wsee.util.ObjectUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public class JsBinding {
    private String name;
    private String namespaceURI;
    private String packageName;
    private ArrayList<JsMethod> methods = new ArrayList();
    private static final boolean verbose = Verbose.isVerbose(JsBinding.class);

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtil.isEmpty(this.packageName)) {
            stringBuilder.append(this.packageName);
            stringBuilder.append(".");
        }
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public JsMethod[] getMethods() {
        return this.methods.toArray(new JsMethod[this.methods.size()]);
    }

    public JsMethod addMethod(QName qName) {
        JsMethod jsMethod = new JsMethod();
        jsMethod.setOperationName(qName);
        this.methods.add(jsMethod);
        return jsMethod;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeArray("methods", this.methods.iterator());
        toStringWriter.end();
    }

    public JsMethod getMethod(QName qName) {
        for (JsMethod jsMethod : this.methods) {
            if (!jsMethod.getOperationName().equals(qName)) continue;
            return jsMethod;
        }
        throw new IllegalArgumentException("Method not found: " + qName);
    }

    public JsMethod getMethod(String string) {
        for (JsMethod jsMethod : this.methods) {
            if (!jsMethod.getMethodName().equals(string)) continue;
            return jsMethod;
        }
        throw new IllegalArgumentException("Method not found: " + string);
    }

    public boolean isStyleMixed() {
        if (this.methods.isEmpty()) {
            return false;
        }
        boolean bl = this.methods.get(0).isWrapped();
        for (int i = 1; i < this.methods.size(); ++i) {
            if (this.methods.get(i).isWrapped() == bl) continue;
            return true;
        }
        return false;
    }

    public boolean isBindingEqual(JsBinding jsBinding) {
        boolean bl = ObjectUtil.equals(this.name, jsBinding.name);
        bl = bl && ObjectUtil.equals(this.namespaceURI, jsBinding.namespaceURI);
        bl = bl && ObjectUtil.equals(this.packageName, jsBinding.packageName);
        bl = bl && this.methods.equals(this.methods);
        return bl;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.add(this.name);
        hashCodeBuilder.add(this.namespaceURI);
        hashCodeBuilder.add(this.packageName);
        hashCodeBuilder.add(this.methods);
        return hashCodeBuilder.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JsBinding)) {
            return false;
        }
        JsBinding jsBinding = (JsBinding)object;
        return this.isBindingEqual(jsBinding);
    }
}

