/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.wsee.tools.source.JsFault;
import weblogic.wsee.tools.source.JsParameterType;
import weblogic.wsee.tools.source.JsReturnType;
import weblogic.wsee.util.HashCodeBuilder;
import weblogic.wsee.util.ObjectUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsMethod {
    private static final boolean verbose = Verbose.isVerbose(JsMethod.class);
    private QName operationName;
    private String methodName;
    private JsReturnType returnType = new JsReturnType("void");
    private ArrayList<JsParameterType> arguments = new ArrayList();
    private ArrayList<JsFault> faults = new ArrayList();
    private boolean isWrapped = false;
    private boolean isOneWay = false;
    private boolean isGenerateAsync = true;
    private String soapAction;
    private boolean isMimeBinding = false;
    private String style;
    private String use;

    JsMethod() {
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String string) {
        this.use = string;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName qName) {
        this.operationName = qName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public JsReturnType getReturnType() {
        return this.returnType;
    }

    public JsReturnType setReturnType(String string) {
        this.returnType = new JsReturnType(string);
        return this.returnType;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public void setWrapped(boolean bl) {
        this.isWrapped = bl;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }

    public void setOneWay(boolean bl) {
        this.isOneWay = bl;
    }

    public boolean isGenerateAsync() {
        return this.isGenerateAsync;
    }

    public void setGenerateAsync(boolean bl) {
        this.isGenerateAsync = bl;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public JsParameterType[] getArguments() {
        return this.arguments.toArray(new JsParameterType[this.arguments.size()]);
    }

    public void resetArgument(ArrayList<JsParameterType> arrayList) {
        this.isMimeBinding = true;
        this.arguments = arrayList;
    }

    public JsFault[] getFaults() {
        return this.faults.toArray(new JsFault[this.faults.size()]);
    }

    public JsParameterType addArgument(String string, String string2) {
        JsParameterType jsParameterType = new JsParameterType(string2);
        jsParameterType.setPartName(string);
        this.arguments.add(jsParameterType);
        return jsParameterType;
    }

    public void addJsParameterType(JsParameterType jsParameterType) {
        this.arguments.add(jsParameterType);
    }

    public JsFault addFault(QName qName, String string, String string2) {
        JsFault jsFault = new JsFault(qName, string, string2);
        this.faults.add(jsFault);
        return jsFault;
    }

    public JsFault addFault(QName qName, String string, String string2, String string3, List list) {
        JsFault jsFault = new JsFault(qName, string, string2, string3, list);
        this.faults.add(jsFault);
        return jsFault;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.methodName);
        toStringWriter.writeArray("arguments", this.arguments.iterator());
        toStringWriter.writeArray("faults", this.faults.iterator());
        toStringWriter.writeField("returnType", this.returnType);
        toStringWriter.end();
    }

    public String getArgumentString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<JsParameterType> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            JsParameterType jsParameterType = iterator.next();
            stringBuffer.append(jsParameterType.getType());
            stringBuffer.append(" ");
            stringBuffer.append(jsParameterType.getParamName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String getAnnotatedArgumentString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<JsParameterType> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            JsParameterType jsParameterType = iterator.next();
            stringBuffer.append("@WebParam(name=\"");
            if (jsParameterType.isDocStyle() && !this.isWrapped()) {
                QName qName = jsParameterType.getElement();
                if (qName != null) {
                    stringBuffer.append(qName.getLocalPart());
                    stringBuffer.append("\", targetNamespace=\"");
                    stringBuffer.append(qName.getNamespaceURI());
                    stringBuffer.append("\", partName=\"");
                    stringBuffer.append(jsParameterType.getPartName());
                } else {
                    stringBuffer.append(jsParameterType.getPartName());
                }
            } else {
                stringBuffer.append(jsParameterType.getPartName());
            }
            stringBuffer.append('\"');
            if (jsParameterType.getMode() != 0) {
                stringBuffer.append(", mode=WebParam.Mode.");
                stringBuffer.append(jsParameterType.getModeAsString());
            }
            if (jsParameterType.isSoapHeader()) {
                stringBuffer.append(", header=true");
            }
            stringBuffer.append(") ");
            stringBuffer.append(jsParameterType.getType());
            stringBuffer.append(" ");
            stringBuffer.append(jsParameterType.getParamName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getAnnotatedReturnTypeString() {
        if (this.returnType.getType().equals("void")) {
            return "";
        }
        String string = this.returnType.getPartName();
        if (this.returnType.isDocStyle() && !this.isWrapped()) {
            QName qName = this.returnType.getElement();
            if (qName != null) {
                return "@WebResult(name=\"" + qName.getLocalPart() + "\", targetNamespace=\"" + qName.getNamespaceURI() + "\")";
            }
            return "@WebResult(name=\"" + string + "\")";
        }
        if (!string.equals("return")) {
            return "@WebResult(name=\"" + string + "\")";
        }
        return "";
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.add(this.getOperationName());
        hashCodeBuilder.add(this.getMethodName());
        hashCodeBuilder.add(this.getReturnType());
        hashCodeBuilder.add(this.getArguments());
        hashCodeBuilder.add(this.getFaults());
        hashCodeBuilder.add(this.isWrapped());
        hashCodeBuilder.add(this.isOneWay());
        hashCodeBuilder.add(this.isGenerateAsync());
        hashCodeBuilder.add(this.getSoapAction());
        hashCodeBuilder.add(this.isMimeBinding);
        hashCodeBuilder.add(this.getStyle());
        hashCodeBuilder.add(this.getUse());
        return hashCodeBuilder.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JsMethod)) {
            return false;
        }
        JsMethod jsMethod = (JsMethod)object;
        boolean bl = ObjectUtil.equals(this.getOperationName(), jsMethod.getOperationName());
        bl &= ObjectUtil.equals(this.getMethodName(), jsMethod.getMethodName());
        bl &= ObjectUtil.equals(this.getReturnType(), jsMethod.getReturnType());
        bl &= ObjectUtil.equals(this.getArguments(), jsMethod.getArguments());
        bl &= ObjectUtil.equals(this.getFaults(), jsMethod.getFaults());
        bl &= ObjectUtil.equals(this.isWrapped(), jsMethod.isWrapped());
        bl &= ObjectUtil.equals(this.isOneWay(), jsMethod.isOneWay());
        bl &= ObjectUtil.equals(this.isGenerateAsync(), jsMethod.isGenerateAsync());
        bl &= ObjectUtil.equals(this.getSoapAction(), jsMethod.getSoapAction());
        bl &= ObjectUtil.equals(this.isMimeBinding, jsMethod.isMimeBinding);
        bl &= ObjectUtil.equals(this.getStyle(), jsMethod.getStyle());
        return bl &= ObjectUtil.equals(this.getUse(), jsMethod.getUse());
    }
}

