/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.source;

import javax.xml.namespace.QName;
import weblogic.wsee.tools.source.JsTypeBase;
import weblogic.wsee.util.HashCodeBuilder;
import weblogic.wsee.util.ObjectUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public class JsParameterType
extends JsTypeBase {
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int INOUT = 2;
    private static final boolean verbose = Verbose.isVerbose(JsParameterType.class);
    private String nonHolderType;
    private String paramName;
    private int mode = 0;
    private boolean isSoapHeader = false;
    private QName element = null;
    private boolean docStyle = true;

    JsParameterType(String string) {
        this.setType(string);
    }

    public void setParamName(String string) {
        this.paramName = string;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getModeAsString() {
        switch (this.mode) {
            case 0: {
                return "IN";
            }
            case 1: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
        }
        throw new AssertionError((Object)("unknown parameter mode " + this.mode));
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalide parameter mode value " + n);
            }
        }
    }

    public boolean isSoapHeader() {
        return this.isSoapHeader;
    }

    public void setSoapHeader(boolean bl) {
        this.isSoapHeader = bl;
    }

    public String getNonHolderType() {
        return this.nonHolderType;
    }

    public void setNonHolderType(String string) {
        this.nonHolderType = string;
    }

    public void setElement(QName qName) {
        this.element = qName;
    }

    public QName getElement() {
        return this.element;
    }

    public boolean isDocStyle() {
        return this.docStyle;
    }

    public void setDocStyle(boolean bl) {
        this.docStyle = bl;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("part name", this.getPartName());
        toStringWriter.writeField("type", this.getType());
        toStringWriter.end();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.add(super.hashCode());
        hashCodeBuilder.add(this.nonHolderType);
        hashCodeBuilder.add(this.paramName);
        hashCodeBuilder.add(this.mode);
        hashCodeBuilder.add(this.isSoapHeader);
        hashCodeBuilder.add(this.element);
        hashCodeBuilder.add(this.docStyle);
        return hashCodeBuilder.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JsParameterType)) {
            return false;
        }
        JsParameterType jsParameterType = (JsParameterType)object;
        boolean bl = super.equals(object);
        bl = bl && ObjectUtil.equals(this.nonHolderType, jsParameterType.nonHolderType);
        bl = bl && ObjectUtil.equals(this.paramName, jsParameterType.paramName);
        bl = bl && this.mode == jsParameterType.mode;
        bl = bl && this.isSoapHeader == jsParameterType.isSoapHeader;
        bl = bl && ObjectUtil.equals(this.element, jsParameterType.element);
        bl = bl && this.docStyle == jsParameterType.docStyle;
        return bl;
    }
}

