/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.source;

import com.bea.xbean.xb.xsdschema.SchemaDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsPort;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlTypes;

public class JsService {
    private WsdlService wsdlService;
    private Map portList = new HashMap();

    public JsService(WsdlService wsdlService) {
        this.wsdlService = wsdlService;
    }

    public WsdlService getWsdlService() {
        return this.wsdlService;
    }

    public Iterator getEndpoints() {
        HashSet<JsClass> hashSet = new HashSet<JsClass>();
        for (JsPort jsPort : this.portList.values()) {
            hashSet.add(jsPort.getEndpoint());
        }
        return hashSet.iterator();
    }

    public JsPort getPort(String string) {
        return (JsPort)this.portList.get(string);
    }

    public Iterator getPorts() {
        return this.portList.values().iterator();
    }

    JsPort addPort(String string, WsdlPort wsdlPort, JsClass jsClass) {
        assert (string != null);
        assert (wsdlPort != null);
        assert (jsClass != null);
        JsPort jsPort = new JsPort(wsdlPort, jsClass);
        this.portList.put(string, jsPort);
        return jsPort;
    }

    public boolean has81Conversation() {
        SchemaDocument[] schemaDocumentArray;
        WsdlTypes wsdlTypes = this.getWsdlService().getDefinitions().getTypes();
        if (wsdlTypes == null) {
            return false;
        }
        for (SchemaDocument schemaDocument : schemaDocumentArray = wsdlTypes.getSchemaArray()) {
            if (!"http://www.openuri.org/2002/04/soap/conversation/".equals(schemaDocument.getSchema().getTargetNamespace())) continue;
            return true;
        }
        return false;
    }
}

