/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.source;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import java.util.HashMap;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.internal.WLW81SchemaAndJavaBinder;
import weblogic.wsee.tools.source.EndpointBuilder;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;

public class Wlw81EndpointBuilder
extends EndpointBuilder {
    private JClass serviceInterfaceJClass = null;
    private HashMap<String, JMethod> methodMap = new HashMap();
    private HashMap<String, JMethod> callbackMethodMap = new HashMap();

    public Wlw81EndpointBuilder(WsdlDefinitions wsdlDefinitions, BuildtimeBindings buildtimeBindings, String string) {
        super(wsdlDefinitions, buildtimeBindings, string);
    }

    public void setServiceInterfaceJClass(JClass jClass) {
        this.serviceInterfaceJClass = jClass;
        if (jClass != null) {
            this.methodMap.clear();
            this.callbackMethodMap.clear();
            WLW81SchemaAndJavaBinder.populateMethodMap(jClass, this.methodMap, this.callbackMethodMap);
        }
    }

    protected void addMethod(JsClass jsClass, WsdlOperationBuilder wsdlOperationBuilder, String string, String string2, String string3) {
        JMethod jMethod = this.getJMethodThatMapsToOperation(wsdlOperationBuilder);
        if (null != jMethod) {
            super.addMethod(jsClass, wsdlOperationBuilder, string, string2, string3);
        }
    }

    protected boolean detectWrappedVirtual(boolean bl, WsdlOperation wsdlOperation) {
        JMethod jMethod;
        if (this.serviceInterfaceJClass != null && (jMethod = this.getJMethodThatMapsToOperation(wsdlOperation)) != null) {
            return WLW81SchemaAndJavaBinder.isWrapped(jMethod, this.serviceInterfaceJClass);
        }
        return super.detectWrappedVirtual(bl, wsdlOperation);
    }

    private JMethod getJMethodThatMapsToOperation(WsdlOperation wsdlOperation) {
        String string = wsdlOperation.getName().getLocalPart();
        JMethod jMethod = this.methodMap.get(string);
        if (null == jMethod) {
            jMethod = this.callbackMethodMap.get(string);
        }
        return jMethod;
    }
}

