/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc;

import java.io.File;
import javax.xml.namespace.QName;
import weblogic.utils.classloaders.ClasspathClassLoader;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.logging.DefaultLogger;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.tools.wsdlc.Wsdl2JwsBuilder;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWsdl2JwsBuilder<T>
implements Wsdl2JwsBuilder<T> {
    protected String wsdl;
    protected String wsdlLocation;
    protected String packageName;
    protected QName portName;
    protected File destDir;
    protected File destImplDir;
    protected Logger logger = new DefaultLogger();
    protected ClassLoader classLoader;
    protected String classpath;
    protected File[] bindingFiles;

    @Override
    public void setClasspath(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(File.pathSeparatorChar);
                }
                stringBuilder.append(string);
            }
        }
        this.classpath = stringBuilder.toString();
        this.classLoader = new ClasspathClassLoader(this.classpath, BaseWsdl2JwsBuilder.class.getClassLoader());
    }

    @Override
    public void setWsdl(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("No wsdl specified");
        }
        this.wsdl = string;
    }

    @Override
    public void setWsdlLocation(String string) {
        this.wsdlLocation = string;
    }

    @Override
    public void setPortName(QName qName) {
        this.portName = qName;
    }

    @Override
    public void setPackageName(String string) {
        this.packageName = string;
    }

    @Override
    public void setDestDir(File file) {
        if (file == null) {
            throw new NullPointerException("destDir");
        }
        this.destDir = file;
    }

    @Override
    public void setDestImplDir(File file) {
        this.destImplDir = file;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger == null ? new DefaultLogger() : logger;
    }

    @Override
    public void setBindingFiles(File[] fileArray) {
        this.bindingFiles = fileArray;
    }

    @Override
    public final void execute() throws WsBuildException {
        this.validate();
        this.executeImpl();
    }

    private void validate() throws WsBuildException {
        boolean bl = true;
        if (this.destDir == null) {
            this.logger.log(EventLevel.ERROR, "Dest dir must be specified");
            bl = false;
        }
        if (StringUtil.isEmpty(this.wsdl)) {
            this.logger.log(EventLevel.ERROR, "Wsdl must be specified");
            bl = false;
        }
        if (!bl) {
            throw new WsBuildException("Wsdl2JwsBuilder invalid - see log for details");
        }
    }

    protected abstract void executeImpl() throws WsBuildException;
}

