/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.tools.source.JsFault;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wsdl.WsdlSchemaImport;
import weblogic.wsee.wsdl.WsdlUtils;

public class WsdlcUtils {
    public static String throwException(JsMethod jsMethod) {
        String string = "";
        JsFault[] jsFaultArray = jsMethod.getFaults();
        for (int i = 0; i < jsFaultArray.length; ++i) {
            JsFault jsFault = jsFaultArray[i];
            string = i == 0 ? "throws " + jsFault.getJsr109MappingFileExceptionClass() : string + ", " + jsFault.getJsr109MappingFileExceptionClass();
        }
        return string;
    }

    public static String getReturnString(String string) {
        if (string.indexOf(46) > -1 || string.indexOf(91) > -1) {
            return "return null;";
        }
        if (string.equals("void")) {
            return "return;";
        }
        if (string.equals("boolean")) {
            return "return false;";
        }
        if (string.equals("int") || string.equals("byte") || string.equals("short") || string.equals("long") || string.equals("double") || string.equals("float")) {
            return "return 0;";
        }
        if (string.equals("char")) {
            return "return '0';";
        }
        return "return null;";
    }

    public static String getWsdlFileName(WsdlDefinitions wsdlDefinitions, String string) {
        String string2;
        File file = new File(string);
        if (file.exists()) {
            string2 = WsdlcUtils.getWsdlRelativePath(wsdlDefinitions, string);
            if (string2.equals(string)) {
                string2 = file.getName();
            }
        } else {
            URL uRL = null;
            try {
                uRL = new URL(string);
                string2 = WsdlcUtils.getWsdlRelativePath(wsdlDefinitions, string);
                if (string2.equals(string)) {
                    string2 = uRL.getPath();
                    string2 = string2.substring(string2.lastIndexOf(47) + 1, string2.length());
                }
            }
            catch (MalformedURLException malformedURLException) {
                return string;
            }
        }
        if (!string2.endsWith(".wsdl")) {
            if (string2.indexOf(46) != -1) {
                string2 = string2.substring(0, string2.indexOf(46));
            }
            string2 = string2 + ".wsdl";
        }
        return string2;
    }

    public static String getWsdlResolvedFile(String string) {
        String string2;
        File file = new File(string);
        if (file.exists()) {
            string2 = file.getName();
        } else {
            URL uRL = null;
            try {
                uRL = new URL(string);
                string2 = uRL.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                return string;
            }
        }
        return string2;
    }

    public static String getWsdlRelativePath(WsdlDefinitions wsdlDefinitions, String string) {
        List<? extends WsdlSchema> list = wsdlDefinitions.getTypes().getSchemaListWithoutImport();
        int n = 0;
        String string2 = null;
        WsdlSchema wsdlSchema = null;
        for (WsdlSchema wsdlSchema2 : list) {
            List<? extends WsdlSchemaImport> list2 = wsdlSchema2.getImports();
            for (WsdlSchemaImport wsdlSchemaImport : list2) {
                String[] stringArray;
                String string3 = wsdlSchemaImport.getSchemaLocation();
                if (!wsdlSchemaImport.isRelative() || string3.indexOf("..") == -1 || (stringArray = string3.split("..")).length <= n) continue;
                n = stringArray.length;
                string2 = string3;
                wsdlSchema = wsdlSchema2;
            }
        }
        if (string2 != null && wsdlSchema != null) {
            try {
                return WsdlcUtils.findPathRelativeToRoot(string, WsdlUtils.constructRelativeLocation(string2, wsdlSchema.getLocationUrl()));
            }
            catch (WsdlException wsdlException) {
                return string;
            }
        }
        return string;
    }

    private static String findPathRelativeToRoot(String string, String string2) {
        int n;
        for (n = 0; n < string.length() && n < string2.length() && string.charAt(n) == string2.charAt(n); ++n) {
        }
        return string.substring(n);
    }

    public static void logVerbose(Logger logger, String string, Object object) {
        if (logger != null && object != null) {
            logger.log(EventLevel.VERBOSE, string + " \"" + object + "\"");
        }
    }

    public static boolean equalsNSOptional(QName qName, QName qName2) {
        assert (qName != null);
        assert (qName2 != null);
        if (StringUtil.isEmpty(qName.getNamespaceURI())) {
            return qName.getLocalPart().equals(qName2.getLocalPart());
        }
        return qName.equals(qName2);
    }
}

