/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc.jaxrpc;

import java.util.Map;
import weblogic.wsee.util.JmsUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapAddress;

public class AddressInfo {
    private String protocol = "";
    private String contextPath = "";
    private String serviceUri = "";
    private String portName = "";
    private String queue = "";
    private String factory = "";

    AddressInfo(WsdlPort wsdlPort) {
        if (wsdlPort != null) {
            this.portName = wsdlPort.getName().getLocalPart();
            WsdlBinding wsdlBinding = wsdlPort.getBinding();
            this.protocol = wsdlBinding.getTransportProtocol();
            SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsdlPort);
            if (soapAddress != null) {
                String string = soapAddress.getLocation();
                int n = -1;
                n = string.indexOf("://");
                if (n > -1) {
                    string = string.substring(n + 3, string.length());
                    int n2 = (string = string.substring(string.indexOf(47) + 1, string.length())).lastIndexOf(63);
                    int n3 = n2 > -1 ? string.substring(0, n2).lastIndexOf("/") : string.lastIndexOf("/");
                    if (n3 > -1) {
                        this.contextPath = string.substring(0, n3);
                        this.serviceUri = n2 > -1 ? string.substring(n3 + 1, n2) : string.substring(n3 + 1, string.length());
                    } else {
                        this.contextPath = "/";
                        this.serviceUri = string;
                    }
                    if (this.protocol.equalsIgnoreCase("jms")) {
                        String string2 = string.substring(n2 + 1);
                        Map map = JmsUtil.asMap(string2);
                        this.queue = (String)map.get("URI");
                        if (this.queue == null) {
                            this.queue = "weblogic.wsee.DefaultQueue";
                        }
                        this.factory = (String)map.get("FACTORY");
                        if (this.factory == null) {
                            this.factory = "weblogic.jms.XAConnectionFactory";
                        }
                    }
                }
            }
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getConnectionFactory() {
        return this.factory;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getProtocol().equals("http")) {
            stringBuilder.append("@WLHttpTransport(");
        } else if (this.getProtocol().equals("https")) {
            stringBuilder.append("@WLHttpsTransport(");
        } else if (this.getProtocol().equals("jms")) {
            stringBuilder.append("@WLJmsTransport(");
        } else {
            return "";
        }
        if (!StringUtil.isEmpty(this.getContextPath())) {
            stringBuilder.append("contextPath=\"" + this.getContextPath() + "\",");
        }
        stringBuilder.append("serviceUri=\"" + this.getServiceUri() + "\",");
        if (!StringUtil.isEmpty(this.getPortName())) {
            stringBuilder.append("portName=\"" + this.getPortName() + "\"");
        }
        if (!StringUtil.isEmpty(this.getQueue())) {
            stringBuilder.append(",queue=\"" + this.getQueue() + "\"");
        }
        if (!StringUtil.isEmpty(this.getConnectionFactory())) {
            stringBuilder.append(",connectionFactory=\"" + this.getConnectionFactory() + "\"");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

