/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc.jaxrpc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.source.JsBinding;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.tools.wsdlc.jaxrpc.AddressInfo;
import weblogic.wsee.tools.wsdlc.jaxrpc.SOAPBindingInfo;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JwsGenInfo {
    private JsBinding binding;
    private List<WsdlPort> ports = new ArrayList<WsdlPort>();
    private WsdlService service;
    private SOAPBindingInfo soapBindingInfo;
    private String wsdlLocation;
    private List<AddressInfo> addressInfos;
    private String serviceClassName;
    private String implClassName;
    private boolean callback81;
    private boolean upgraded81Jws;

    JwsGenInfo() {
    }

    void setBinding(JsBinding jsBinding) {
        this.binding = jsBinding;
    }

    public JsBinding getBinding() {
        return this.binding;
    }

    void setPort(WsdlPort wsdlPort) {
        if (wsdlPort == null) {
            throw new IllegalArgumentException("No port specified");
        }
        this.ports.add(wsdlPort);
        this.service = wsdlPort.getService();
    }

    public boolean isCallback81() {
        return this.callback81;
    }

    public void setCallback81(boolean bl) {
        this.callback81 = bl;
    }

    void setService(WsdlService wsdlService) {
        if (wsdlService == null) {
            throw new IllegalArgumentException("No service specified");
        }
        this.service = wsdlService;
        this.ports.clear();
        Iterator<? extends WsdlPort> iterator = wsdlService.getPorts().values().iterator();
        while (iterator.hasNext()) {
            this.ports.add(iterator.next());
        }
    }

    public void setUpgraded81Jws(boolean bl) {
        this.upgraded81Jws = bl;
    }

    public boolean isUpgradedJWS() {
        return this.upgraded81Jws;
    }

    void setSOAPBindingInfo(SOAPBindingInfo sOAPBindingInfo) {
        this.soapBindingInfo = sOAPBindingInfo;
    }

    void setWsdlLocation(String string) {
        this.wsdlLocation = string;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public SOAPBindingInfo getSOAPBindingInfo() {
        return this.soapBindingInfo;
    }

    public WsdlService getService() {
        return this.service;
    }

    public List<AddressInfo> getAddressInfos() {
        if (this.addressInfos == null) {
            this.addressInfos = new ArrayList<AddressInfo>();
            for (WsdlPort wsdlPort : this.ports) {
                this.addressInfos.add(new AddressInfo(wsdlPort));
            }
        }
        return this.addressInfos;
    }

    public boolean isConversational() {
        assert (!this.ports.isEmpty());
        return ConversationUtils.isConversational(this.ports.get(0).getBinding());
    }

    void setServiceClassName(String string) {
        this.serviceClassName = string;
        this.implClassName = string + "Impl";
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public String getImplClassName() {
        return this.implClassName;
    }

    void validate() throws WsBuildException {
        this.checkSoap12StyleAndUse();
    }

    private void checkSoap12StyleAndUse() throws WsBuildException {
        if (this.soapBindingInfo.isSoap12()) {
            for (JsMethod jsMethod : this.binding.getMethods()) {
                if (!"rpc".equalsIgnoreCase(jsMethod.getStyle()) || !"encoded".equalsIgnoreCase(jsMethod.getUse())) continue;
                throw new WsBuildException("rpc/encoded style soap12 webservice is not supported");
            }
        }
    }
}

