/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc.jaxrpc;

import java.io.File;
import java.io.PrintStream;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.tools.wsdlc.WsdlcUtils;
import weblogic.wsee.tools.wsdlc.jaxrpc.JwsBase;
import weblogic.wsee.tools.wsdlc.jaxrpc.JwsGenInfo;
import weblogic.wsee.util.jspgen.GenFactory;
import weblogic.wsee.util.jspgen.ScriptException;

class JwsGenerator {
    private final JwsGenInfo jwsGenInfo;
    private final Logger logger;
    private final Object codeGenBaseData;

    JwsGenerator(JwsGenInfo jwsGenInfo, Logger logger, Object object) {
        this.jwsGenInfo = jwsGenInfo;
        this.logger = logger;
        this.codeGenBaseData = object;
    }

    private JwsBase getJwsBase(String string, ClassLoader classLoader) throws WsBuildException {
        JwsBase jwsBase = null;
        try {
            jwsBase = classLoader == null ? (JwsBase)GenFactory.create(string) : (JwsBase)GenFactory.create(string, classLoader);
        }
        catch (ScriptException scriptException) {
            throw new WsBuildException("Failed to create jws implementation", scriptException);
        }
        return jwsBase;
    }

    void generate(File file, String string, String string2, ClassLoader classLoader, String string3) throws WsBuildException {
        JwsBase jwsBase = this.getJwsBase(string2, classLoader);
        String string4 = this.jwsGenInfo.getBinding().getPackageName();
        WsdlcUtils.logVerbose(this.logger, "Generating jws " + string3 + " using package name as ", string4);
        WsdlcUtils.logVerbose(this.logger, "Generating jws " + string3 + " using class name as", string);
        jwsBase.setJwsGenInfo(this.jwsGenInfo);
        PrintStream printStream = ToolsUtil.createJavaSourceStream(file, string4, string);
        jwsBase.setOutput(printStream);
        jwsBase.setup(this.codeGenBaseData);
        try {
            jwsBase.generate();
        }
        catch (ScriptException scriptException) {
            throw new WsBuildException("Failed to generate jws " + string3, scriptException);
        }
        finally {
            printStream.close();
        }
    }
}

