/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc.jaxrpc;

import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBindingUtil;
import weblogic.wsee.wsdl.soap11.SoapBody;
import weblogic.wsee.wsdl.soap12.Soap12Binding;
import weblogic.wsee.wsdl.soap12.Soap12BindingOperation;
import weblogic.wsee.wsdl.soap12.Soap12Body;

public class SOAPBindingInfo {
    private static String DOC_STYLE = "SOAPBinding.Style.DOCUMENT";
    private static String RPC_STYLE = "SOAPBinding.Style.RPC";
    private static String USE_LITERAL = "SOAPBinding.Use.LITERAL";
    private static String USE_ENCODED = "SOAPBinding.Use.ENCODED";
    private static String BARE = "SOAPBinding.ParameterStyle.BARE";
    private static String WRAP = "SOAPBinding.ParameterStyle.WRAPPED";
    private String style = DOC_STYLE;
    private String use = USE_LITERAL;
    private String parameterStyle = WRAP;
    private boolean isDocStyle = true;
    private boolean methodLevel = false;
    private boolean soap12 = false;

    SOAPBindingInfo(JsMethod jsMethod) {
        this.setStyle(jsMethod.getStyle());
        this.setUse(jsMethod.getUse());
        this.setWrapped(jsMethod.isWrapped());
        this.setMethodLevel(true);
    }

    SOAPBindingInfo(JsClass jsClass, WsdlBinding wsdlBinding) {
        SoapBinding soapBinding;
        JsMethod[] jsMethodArray = jsClass.getMethods();
        if (jsMethodArray.length > 0) {
            this.setWrapped(jsMethodArray[0].isWrapped());
        }
        if ((soapBinding = SoapBinding.narrow(wsdlBinding)) == null) {
            soapBinding = Soap12Binding.narrow(wsdlBinding);
            this.setSoap12(true);
        }
        for (WsdlOperation wsdlOperation : wsdlBinding.getPortType().getOperations().values()) {
            WsdlBindingOperation wsdlBindingOperation = wsdlBinding.getOperations().get(wsdlOperation.getName());
            if (wsdlBindingOperation == null) continue;
            SoapBindingOperation soapBindingOperation = this.getAnySoapBindingOperation(wsdlBindingOperation);
            this.setStyle(SoapBindingUtil.getStyle(soapBindingOperation, soapBinding));
            WsdlBindingMessage wsdlBindingMessage = wsdlBindingOperation.getInput();
            if (wsdlBindingMessage == null) {
                wsdlBindingMessage = wsdlBindingOperation.getOutput();
            }
            if (wsdlBindingMessage == null) break;
            this.setUse(this.getAnySoapBody(wsdlBindingMessage).getUse());
            break;
        }
    }

    private SoapBody getAnySoapBody(WsdlBindingMessage wsdlBindingMessage) {
        SoapBody soapBody = SoapBody.narrow(wsdlBindingMessage);
        if (soapBody == null) {
            soapBody = Soap12Body.narrow(wsdlBindingMessage);
        }
        return soapBody;
    }

    private SoapBindingOperation getAnySoapBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        SoapBindingOperation soapBindingOperation = SoapBindingOperation.narrow(wsdlBindingOperation);
        if (soapBindingOperation == null) {
            soapBindingOperation = Soap12BindingOperation.narrow(wsdlBindingOperation);
        }
        return soapBindingOperation;
    }

    void setMethodLevel(boolean bl) {
        this.methodLevel = bl;
    }

    void setStyle(String string) {
        if (string != null) {
            if (string.equals("document")) {
                this.style = DOC_STYLE;
            } else {
                this.style = RPC_STYLE;
                this.isDocStyle = false;
            }
        }
    }

    public String getStyle() {
        return this.style;
    }

    void setUse(String string) {
        if (string != null) {
            this.use = string.equals("literal") ? USE_LITERAL : USE_ENCODED;
        }
    }

    public String getUse() {
        return this.use;
    }

    void setWrapped(boolean bl) {
        this.parameterStyle = bl ? WRAP : BARE;
    }

    public String getParameterStyle() {
        return this.parameterStyle;
    }

    public boolean isDocumentStyle() {
        return this.isDocStyle;
    }

    public boolean isSoap12() {
        return this.soap12;
    }

    void setSoap12(boolean bl) {
        this.soap12 = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof SOAPBindingInfo) {
            SOAPBindingInfo sOAPBindingInfo = (SOAPBindingInfo)object;
            if (this.getStyle().equals(sOAPBindingInfo.getStyle()) && this.getUse().equals(sOAPBindingInfo.getUse()) && this.getParameterStyle().equals(sOAPBindingInfo.getParameterStyle())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.methodLevel) {
            stringBuilder.append("@weblogic.jws.soap.SOAPBinding(");
        } else {
            stringBuilder.append("@SOAPBinding(");
        }
        stringBuilder.append("style=" + this.getStyle() + ", ");
        stringBuilder.append("use=" + this.getUse());
        if (this.isDocumentStyle()) {
            stringBuilder.append(",parameterStyle=" + this.getParameterStyle());
        }
        stringBuilder.append(")");
        if (this.isSoap12()) {
            stringBuilder.append("\n@weblogic.jws.Binding(weblogic.jws.Binding.Type.SOAP12)");
        }
        return stringBuilder.toString();
    }
}

