/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc.jaxrpc;

import com.bea.xml.XmlException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.source.EndpointBuilder;
import weblogic.wsee.tools.source.JsBinding;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.wsdlc.BaseWsdl2JwsBuilder;
import weblogic.wsee.tools.wsdlc.WsdlcUtils;
import weblogic.wsee.tools.wsdlc.jaxrpc.JwsGenInfo;
import weblogic.wsee.tools.wsdlc.jaxrpc.JwsGenerator;
import weblogic.wsee.tools.wsdlc.jaxrpc.Options;
import weblogic.wsee.tools.wsdlc.jaxrpc.SOAPBindingInfo;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.xml.schema.binding.internal.NameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wsdl2JwsBuilderImpl
extends BaseWsdl2JwsBuilder<Options> {
    private static final String USAGE = "One of 'bindingName', 'portName' or 'serviceName' must be specified.";
    private Options options = new Options();

    @Override
    public void setOptions(Options options) {
        this.options = options == null ? new Options() : options;
    }

    protected void validate() throws WsBuildException {
        int n = 0;
        if (this.options.getBindingName() != null) {
            ++n;
        }
        if (this.options.getServiceName() != null) {
            ++n;
        }
        if (this.portName != null) {
            ++n;
        }
        if (n > 1) {
            ToolsUtil.throwException("Only one of 'bindingName', 'portName' and 'serviceName' can be specified. Please specify only one of them", this.logger);
        }
        if (this.options.getImplTemplate() != null && this.destImplDir == null) {
            ToolsUtil.throwException("destImplDir must be specified when implTemplate is provided.", this.logger);
        }
    }

    protected WsdlService getService(WsdlPort wsdlPort) throws WsBuildException {
        WsdlService wsdlService = null;
        if (wsdlPort != null) {
            wsdlService = wsdlPort.getService();
        } else {
            if (this.options.getServiceName() != null) {
                wsdlService = this.findService();
            } else {
                Iterator<? extends WsdlService> iterator = this.options.getDefinitions().getServices().values().iterator();
                if (!iterator.hasNext()) {
                    throw new WsBuildException("Wsdl has no services");
                }
                wsdlService = iterator.next();
                if (iterator.hasNext()) {
                    throw new WsBuildException("Wsdl has more than one service.  One of 'bindingName', 'portName' or 'serviceName' must be specified.");
                }
            }
            this.checkPortTypesSame(wsdlService);
        }
        if (!wsdlService.getPorts().values().iterator().hasNext()) {
            throw new WsBuildException("Service " + wsdlService.getName() + " has no ports");
        }
        return wsdlService;
    }

    protected WsdlPort getRequestedPort() throws WsBuildException {
        if (this.portName != null || this.options.getBindingName() != null) {
            return this.findPort();
        }
        return null;
    }

    @Override
    protected void executeImpl() throws WsBuildException {
        this.validate();
        JwsGenInfo jwsGenInfo = this.buildJwsGenInfo();
        JwsGenerator jwsGenerator = new JwsGenerator(jwsGenInfo, this.logger, this.options.getCodeGenBaseData());
        jwsGenerator.generate(this.destDir, jwsGenInfo.getServiceClassName(), this.options.getInterfaceTemplate(), null, "interface");
        if (this.destImplDir != null) {
            jwsGenerator.generate(this.destImplDir, jwsGenInfo.getImplClassName(), this.options.getImplTemplate(), this.classLoader, "implementation");
        }
    }

    private void checkPortTypesSame(WsdlService wsdlService) throws WsBuildException {
        QName qName = null;
        for (WsdlPortType wsdlPortType : wsdlService.getPortTypes()) {
            if (qName == null) {
                qName = wsdlPortType.getName();
                continue;
            }
            if (qName.equals(wsdlPortType.getName())) continue;
            throw new WsBuildException("Service " + wsdlService.getName() + " uses more than 1 port type.  " + USAGE);
        }
    }

    private WsdlService findService() throws WsBuildException {
        for (WsdlService wsdlService : this.options.getDefinitions().getServices().values()) {
            if (!WsdlcUtils.equalsNSOptional(this.options.getServiceName(), wsdlService.getName())) continue;
            return wsdlService;
        }
        throw new WsBuildException("Service " + this.options.getServiceName() + " not found in wsdl");
    }

    private WsdlPort findPort() throws WsBuildException {
        for (WsdlService wsdlService : this.options.getDefinitions().getServices().values()) {
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                if (!(this.portName != null ? WsdlcUtils.equalsNSOptional(this.portName, wsdlPort.getName()) : this.options.getBindingName() != null && WsdlcUtils.equalsNSOptional(this.options.getBindingName(), wsdlPort.getBinding().getName()))) continue;
                return wsdlPort;
            }
        }
        if (this.options.getBindingName() != null) {
            throw new WsBuildException("No port using binding " + this.options.getBindingName() + " found in wsdl");
        }
        throw new WsBuildException("No port " + this.portName + " found in wsdl");
    }

    private JsClass buildJsClass(boolean bl, WsdlService wsdlService, WsdlPort wsdlPort) throws WsBuildException {
        Object object;
        Map<QName, JsClass> map = null;
        try {
            object = new EndpointBuilder(this.options.getDefinitions(), this.destDir, this.packageName, this.options.isJaxRPCWrappedArrayStyle(), bl, this.options.getTypeFamily(), null, this.bindingFiles, this.options.isAllowWrappedArrayForDocLiteral(), this.options.isSortSchemaTypes(), this.options.isFillIncompleteParameterOrderList(), this.options.isIncludeGlobalTypes());
            ((EndpointBuilder)object).setWlw81CallbackGen(this.options.isWlw81CallbackGen() && !this.options.isUpgraded81Jws());
            map = ((EndpointBuilder)object).build();
            assert (map.size() > 0) : "No endpoints build for " + this.wsdl;
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
        catch (XmlException xmlException) {
            throw new WsBuildException(xmlException);
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException);
        }
        object = null;
        object = wsdlPort != null ? map.get(wsdlPort.getBinding().getName()) : this.getEndpointForService(wsdlService, map);
        if (object == null) {
            throw new WsBuildException("No valid SOAP endpoint defined found. Please check if there is SOAP binding defined.");
        }
        if (bl && ((JsBinding)object).isStyleMixed()) {
            return this.buildJsClass(false, wsdlService, wsdlPort);
        }
        return object;
    }

    private JsClass getEndpointForService(WsdlService wsdlService, Map<QName, JsClass> map) throws WsBuildException {
        JsClass jsClass = null;
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            JsClass jsClass2 = map.get(wsdlPort.getBinding().getName());
            if (jsClass == null) {
                jsClass = jsClass2;
                continue;
            }
            if (jsClass.isBindingEqual(jsClass2)) continue;
            throw new WsBuildException("Port " + wsdlPort.getName() + " uses different binding that other ports in the service.  " + USAGE);
        }
        return jsClass;
    }

    private JwsGenInfo buildJwsGenInfo() throws WsBuildException {
        WsdlPort wsdlPort = this.getRequestedPort();
        WsdlService wsdlService = this.getService(wsdlPort);
        JsClass jsClass = this.buildJsClass(this.options.isAutoDetectWrapped(), wsdlService, wsdlPort);
        JwsGenInfo jwsGenInfo = new JwsGenInfo();
        jwsGenInfo.setUpgraded81Jws(this.options.isUpgraded81Jws());
        jwsGenInfo.setCallback81(this.options.isWlw81CallbackGen());
        jwsGenInfo.setServiceClassName(this.getServiceClassName(jsClass) + (this.options.isWlw81CallbackGen() ? "Callback" : ""));
        if (wsdlPort == null) {
            jwsGenInfo.setService(wsdlService);
        } else {
            jwsGenInfo.setPort(wsdlPort);
        }
        jwsGenInfo.setBinding(jsClass);
        jwsGenInfo.setSOAPBindingInfo(new SOAPBindingInfo(jsClass, this.options.getDefinitions().getBindings().get(jsClass.getBindingName())));
        jwsGenInfo.setWsdlLocation(this.wsdlLocation);
        jwsGenInfo.validate();
        return jwsGenInfo;
    }

    private String getServiceClassName(JsClass jsClass) {
        String string = null;
        string = this.portName != null ? this.portName.getLocalPart() : jsClass.getName();
        return NameUtil.getJAXRPCClassName((String)string);
    }
}

