/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.wsdlc.jaxws;

import com.sun.tools.ws.ant.WsImport2;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.logging.BuildListenerLogger;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.wsdlc.BaseWsdl2JwsBuilder;
import weblogic.wsee.tools.wsdlc.jaxws.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wsdl2JwsBuilderImpl
extends BaseWsdl2JwsBuilder<Options> {
    private Options options = new Options();

    @Override
    public void setOptions(Options options) {
        this.options = options == null ? new Options() : options;
    }

    protected void validate() throws WsBuildException {
    }

    @Override
    protected void executeImpl() throws WsBuildException {
        this.validate();
        this.generateInterfaceAndImpl();
    }

    private void generateInterfaceAndImpl() throws WsBuildException {
        this.destDir.mkdirs();
        Project project = new Project();
        project.setBaseDir(this.destDir.getAbsoluteFile());
        project.addBuildListener((BuildListener)new BuildListenerLogger(this.logger));
        WsImport2 wsImport2 = new WsImport2();
        wsImport2.setProject(project);
        wsImport2.setDestdir(this.destDir);
        wsImport2.setSourcedestdir(this.destDir);
        wsImport2.setPackage(this.packageName);
        wsImport2.setWsdl(this.wsdl);
        wsImport2.setWsdllocation(this.wsdlLocation);
        wsImport2.setDebug(this.options.isDebug());
        wsImport2.setVerbose(this.options.isVerbose());
        wsImport2.setExtension(true);
        wsImport2.setFailonerror(this.options.isFailonerror());
        wsImport2.setFork(this.options.isFork());
        wsImport2.setIncludeantruntime(this.options.isIncludeantruntime());
        wsImport2.setIncludejavaruntime(this.options.isIncludejavaruntime());
        wsImport2.setOptimize(this.options.isOptimize());
        if (this.destImplDir != null) {
            try {
                if (this.destImplDir.getCanonicalPath().equals(this.destDir.getCanonicalPath())) {
                    this.logger.log(EventLevel.WARNING, "destImplDir equals cowDir, your expected impl files might be generated into the Compiled WSDL jar.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.destImplDir.mkdirs();
            wsImport2.setImplDestDir(this.destImplDir);
            if (this.options.getServiceName() != null) {
                wsImport2.setImplServiceName(this.options.getServiceName().toString());
            }
            if (this.portName != null) {
                wsImport2.setImplPortName(this.portName.toString());
            }
        }
        for (FileSet fileSet : AntUtil.getFileSets(this.bindingFiles, project)) {
            wsImport2.addConfiguredBinding(fileSet);
        }
        for (FileSet fileSet : this.options.getConfiguredDepends()) {
            wsImport2.addConfiguredDepends(fileSet);
        }
        for (FileSet fileSet : this.options.getConfiguredProduces()) {
            wsImport2.addConfiguredProduces(fileSet);
        }
        try {
            wsImport2.execute();
        }
        catch (BuildException buildException) {
            throw new WsBuildException("Error running JAX-WS wsdlc", buildException);
        }
    }

    static {
        System.setProperty(XMLStreamWriterFactory.class.getName() + ".woodstox", "true");
        System.setProperty(XMLStreamReaderFactory.class.getName() + ".woodstox", "true");
    }
}

