/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.xcatalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.anttasks.ClientGenFacadeTask;
import weblogic.wsee.tools.anttasks.DelegatingJavacTask;
import weblogic.wsee.tools.clientgen.jaxws.Options;
import weblogic.wsee.tools.xcatalog.CatalogInfo;
import weblogic.wsee.tools.xcatalog.CatalogOptions;
import weblogic.wsee.tools.xcatalog.DownloadXMLs;
import weblogic.wsee.tools.xcatalog.FileAnalysis;
import weblogic.wsee.tools.xcatalog.XCatalogException;
import weblogic.wsee.tools.xcatalog.XCatalogUtil;
import weblogic.wsee.util.Verbose;
import weblogic.xml.domimpl.Saver;
import weblogic.xml.domimpl.SaverOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientGenXMLs {
    private static final boolean verbose = Verbose.isVerbose(ClientGenXMLs.class);
    private static final String JAXWS_CATALOG_FILE = "jax-ws-catalog.xml";
    private static final String CATALOG_ROOT = "catalog";
    private static final String TAG_PUBLIC = "public";
    private static final String TAG_SYSTEM = "system";
    private static final String ATTR_SYSTEM_ID = "systemId";
    private static final String ATTR_PUBLIC_ID = "publicId";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_PREFER = "prefer";
    private static final String CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    private static final String META_INF_WSDLS = "META-INF/wsdls";

    private static void antLog(Task task, String string, int n) {
        if (task == null) {
            return;
        }
        task.log(string, n);
    }

    private static void validateURL(String string) throws BuildException {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("Catalog reference ID [ " + string + " ] is not a valid URL,\n\t suggest to define it as \"http://....\"", (Throwable)malformedURLException);
        }
    }

    public static void doAllCatalogFiles(Task task, File file, CatalogInfo catalogInfo) {
        ClientGenXMLs.copyRelatedFiles(task, file, catalogInfo);
        ClientGenXMLs.genJAXWSCatalogDotXML(task, catalogInfo, file, null);
    }

    public static CatalogInfo processClient(Task task, WebServiceType webServiceType, Options options, String string, CatalogInfo catalogInfo) throws BuildException {
        String string2;
        Object object;
        Serializable serializable;
        String string3;
        File file;
        Object object2;
        if (catalogInfo == null) {
            catalogInfo = new CatalogInfo();
        }
        if (webServiceType == WebServiceType.JAXRPC) {
            return catalogInfo;
        }
        if (!catalogInfo.isEmbeddedInJwsc && string.startsWith("file:/") && options.isGenRuntimeCatalog() && !options.isCopyWsdl()) {
            object2 = ((ClientGenFacadeTask)task).getDestDir();
            file = new File((File)object2, "META-INF");
            try {
                string3 = options.getWsdllocationOverride() != null ? options.getWsdllocationOverride() : string.substring(string.lastIndexOf(47) + 1);
                serializable = new URL(string);
                object = new File(((URL)serializable).toURI());
                string2 = ClientGenXMLs.getRelativePath(file, (File)object);
                catalogInfo.localCatalogs.put(string3, string2);
                options.setWsdllocationOverride(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException((Throwable)malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new BuildException((Throwable)uRISyntaxException);
            }
        }
        if (options == null) {
            return catalogInfo;
        }
        if (!options.isCopyWsdl()) {
            if (options.getCatalog() == null && options.getXmlCatalog() == null) {
                return catalogInfo;
            }
            if (!options.isGenRuntimeCatalog()) {
                ClientGenXMLs.antLog(task, "Does not generate XML Catalog files for runtime", 2);
                return catalogInfo;
            }
        }
        object2 = new DownloadXMLs();
        file = null;
        string3 = null;
        serializable = ClientGenXMLs.getDestDir(task);
        if (options.isCopyWsdl() && serializable != null) {
            object = META_INF_WSDLS;
            if (options.getWsdllocationOverride() != null) {
                string2 = options.getWsdllocationOverride();
                int n = string2.replace('\\', '/').lastIndexOf(47);
                if (n > 0) {
                    object = string2.substring(0, n);
                    string3 = string2.substring(n + 1);
                } else if (n == 0) {
                    string3 = string2.substring(1);
                    object = null;
                } else {
                    string3 = string2;
                }
            }
            file = object != null ? new File((File)serializable, (String)object) : serializable;
        }
        object = ((DownloadXMLs)object2).parseXMLs(options, file, string, string3, options.isCopyWsdl());
        if (options.isCopyWsdl() && options.getWsdllocationOverride() == null) {
            int n = ((String)object).replace('\\', '/').lastIndexOf(47);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(META_INF_WSDLS);
            stringBuffer.append("/");
            if (n > 0) {
                stringBuffer.append(((String)object).substring(n + 1));
            } else if (n == 0) {
                stringBuffer.append(((String)object).substring(1));
            } else {
                stringBuffer.append((String)object);
            }
            options.setWsdllocationOverride(stringBuffer.toString());
        }
        List<FileAnalysis> list = ((DownloadXMLs)object2).getFileAnalysisList();
        HashMap<String, String> hashMap = ClientGenXMLs.getLocalCatalogs(list);
        Iterator<String> iterator = hashMap.keySet().iterator();
        String string4 = null;
        while (iterator.hasNext()) {
            string4 = iterator.next();
            if (catalogInfo.localCatalogs.containsKey(string4)) {
                if (catalogInfo.localCatalogs.get(string4).equals(hashMap.get(string4))) continue;
                throw new BuildException("One XML Catalog Reference ID [" + string4 + "] is referencing multiple URIs!");
            }
            ClientGenXMLs.validateURL(string4);
            catalogInfo.localCatalogs.put(string4, hashMap.get(string4));
        }
        File file2 = options.getCatalog();
        if (file2 == null) {
            catalogInfo.fileAnalysisList.addAll(list);
            return catalogInfo;
        }
        String string5 = file2.getParent();
        for (FileAnalysis fileAnalysis : list) {
            fileAnalysis.cBaseDir = string5;
        }
        catalogInfo.fileAnalysisList.addAll(list);
        HashMap<String, String> hashMap2 = ClientGenXMLs.getRemoteCatalogs(catalogInfo.fileAnalysisList, options);
        iterator = hashMap2.keySet().iterator();
        string4 = null;
        while (iterator.hasNext()) {
            string4 = iterator.next();
            if (catalogInfo.remoteCatalogs.containsKey(string4)) {
                if (catalogInfo.remoteCatalogs.get(string4).equals(hashMap2.get(string4))) continue;
                throw new BuildException("One XML Catalog Reference ID [" + string4 + "] is referencing multiple URIs!");
            }
            ClientGenXMLs.validateURL(string4);
            catalogInfo.remoteCatalogs.put(string4, (String)hashMap2.get(string4));
            ClientGenXMLs.add2CopyFiles(task, catalogInfo, (String)hashMap2.get(string4), string5);
        }
        return catalogInfo;
    }

    private static File getDestDir(Task task) {
        File file = null;
        if (task instanceof ClientGenFacadeTask) {
            file = ((ClientGenFacadeTask)task).getDestDir();
        } else if (task instanceof DelegatingJavacTask) {
            file = ((DelegatingJavacTask)task).getDestdir();
        }
        return file;
    }

    private static boolean isAbsPath(String string) {
        return string == null || string.indexOf(":") > 0 || string.startsWith("/");
    }

    private static void checkUpperRelativePath(Task task, CatalogInfo catalogInfo, String string) {
        if (string.startsWith("..")) {
            ClientGenXMLs.antLog(task, "[FATAL Warning] The uri [" + string + "] " + "is started with upper(..) relative path, " + "so the Ant (copy) task can not copy it to runtime env!", 1);
            catalogInfo.copyUpperRelativePathFlag = true;
        }
    }

    private static void add2CopyFiles(Task task, CatalogInfo catalogInfo, String string, String string2) {
        if (ClientGenXMLs.isAbsPath(string)) {
            return;
        }
        ClientGenXMLs.checkUpperRelativePath(task, catalogInfo, string);
        FileSet fileSet = new FileSet();
        File file = new File(string2);
        fileSet.setDir(file);
        fileSet.setIncludes(string);
        catalogInfo.copyFiles.add(fileSet);
    }

    private static void copyRelatedFiles(Task task, File file, CatalogInfo catalogInfo) throws BuildException {
        if (catalogInfo == null || catalogInfo.copyFiles.size() == 0) {
            return;
        }
        for (FileAnalysis fileAnalysis : catalogInfo.fileAnalysisList) {
            if (fileAnalysis.Type != 2) continue;
            if (verbose) {
                Verbose.say("originalURI=" + fileAnalysis.originalURI + ":" + fileAnalysis.idOrURI + ":" + fileAnalysis.cBaseDir);
            }
            if (fileAnalysis.cBaseDir == null || ClientGenXMLs.isAbsPath(fileAnalysis.originalURI)) continue;
            FileSet fileSet = new FileSet();
            File file2 = new File(fileAnalysis.cBaseDir);
            fileSet.setDir(file2);
            File file3 = new File(fileAnalysis.idOrURI);
            try {
                String string = XCatalogUtil.getRelativeFile(file3, file2);
                if (verbose) {
                    Verbose.say("includeFile=" + string);
                }
                ClientGenXMLs.checkUpperRelativePath(task, catalogInfo, string);
                fileSet.setIncludes(string);
            }
            catch (IOException iOException) {
                if (verbose) {
                    iOException.printStackTrace();
                }
                throw new BuildException("Bad file path!!!", (Throwable)iOException);
            }
            catalogInfo.copyFiles.add(fileSet);
        }
        ClientGenXMLs.antLog(task, "Copy related XML catalog files to runtime env...", 2);
        if (catalogInfo.copyUpperRelativePathFlag) {
            throw new BuildException("Some uri(s) are started with upper(..) relative path, jax-ws-catalog.xml and related files can not be copied into runtime env.");
        }
        AntUtil.copyFiles(task.getProject(), catalogInfo.copyFiles, file);
    }

    private static void addReference(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement(TAG_SYSTEM);
        element2.setAttribute(ATTR_SYSTEM_ID, string);
        element2.setAttribute(ATTR_URI, string2);
        element.appendChild(element2);
    }

    private static void genJAXWSCatalogDotXML(Task task, CatalogInfo catalogInfo, File file, String string) throws BuildException {
        if (catalogInfo == null || catalogInfo.catalogSize() == 0) {
            return;
        }
        if (catalogInfo.copyUpperRelativePathFlag) {
            return;
        }
        ClientGenXMLs.antLog(task, "Generate the jax-ws-catalog.xml file to runtime env...", 2);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(CATALOG_ROOT);
            element.setAttribute("xmlns", CATALOG_NS);
            element.setAttribute(ATTR_PREFER, TAG_SYSTEM);
            for (String string2 : catalogInfo.localCatalogs.keySet()) {
                ClientGenXMLs.addReference(document, element, string2, catalogInfo.localCatalogs.get(string2));
            }
            for (String string2 : catalogInfo.remoteCatalogs.keySet()) {
                ClientGenXMLs.addReference(document, element, string2, catalogInfo.remoteCatalogs.get(string2));
            }
            document.appendChild(element);
            SaverOptions saverOptions = SaverOptions.getDefaults();
            saverOptions.setPrettyPrint(true);
            saverOptions.setWriteXmlDeclaration(true);
            if (string != null) {
                saverOptions.setEncoding(string);
            } else {
                saverOptions.setEncoding("UTF-8");
            }
            file.mkdir();
            File file2 = new File(file, JAXWS_CATALOG_FILE);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            Saver.save((OutputStream)fileOutputStream, (Document)document, (SaverOptions)saverOptions);
            fileOutputStream.close();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException(parserConfigurationException.getMessage(), (Throwable)parserConfigurationException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException(fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private static HashMap<String, String> getLocalCatalogs(List<FileAnalysis> list) throws BuildException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (FileAnalysis fileAnalysis : list) {
            if (fileAnalysis.Type != 0) continue;
            hashMap.put(fileAnalysis.idOrURI, fileAnalysis.systemId);
        }
        return hashMap;
    }

    private static HashMap<String, String> getRemoteCatalogs(List<FileAnalysis> list, CatalogOptions catalogOptions) {
        Element element;
        int n;
        Document document;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file = catalogOptions.getCatalog();
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (bl) {
            if (verbose) {
                Verbose.log("WARNING: Not found catalog file[" + file + "]");
            }
            return null;
        }
        try {
            document = XCatalogUtil.getDocument(new InputSource(fileInputStream));
        }
        catch (XCatalogException xCatalogException) {
            throw new BuildException((Throwable)xCatalogException);
        }
        String string = null;
        NodeList nodeList = document.getElementsByTagName(TAG_PUBLIC);
        for (n = 0; n < nodeList.getLength(); ++n) {
            element = (Element)nodeList.item(n);
            String string2 = element.getAttribute(ATTR_PUBLIC_ID);
            string = element.getAttribute(ATTR_URI);
            if (string2 == null || string == null) continue;
            hashMap.put(string2, string);
        }
        nodeList = document.getElementsByTagName(TAG_SYSTEM);
        for (n = 0; n < nodeList.getLength(); ++n) {
            element = (Element)nodeList.item(n);
            String string3 = element.getAttribute(ATTR_SYSTEM_ID);
            string = element.getAttribute(ATTR_URI);
            if (string3 == null || string == null || !ClientGenXMLs.inAFList(list, string3)) continue;
            hashMap.put(string3, string);
        }
        return hashMap;
    }

    private static boolean inAFList(List<FileAnalysis> list, String string) {
        for (FileAnalysis fileAnalysis : list) {
            if (!fileAnalysis.idOrURI.equals(string) || fileAnalysis.Type != 1) continue;
            return true;
        }
        return false;
    }

    public static String getRelativePath(File file, File file2) {
        List<String> list = ClientGenXMLs.getPathList(file);
        List<String> list2 = ClientGenXMLs.getPathList(file2);
        String string = ClientGenXMLs.matchPathLists(list, list2);
        return string;
    }

    private static List<String> getPathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (File file2 = file.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                arrayList.add(file2.getName());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            arrayList = null;
        }
        return arrayList;
    }

    private static String matchPathLists(List<String> list, List<String> list2) {
        int n;
        String string = "";
        int n2 = list.size() - 1;
        for (n = list2.size() - 1; n2 >= 0 && n >= 0 && list.get(n2).equals(list2.get(n)); --n2, --n) {
        }
        while (n2 >= 0) {
            string = string + "../";
            --n2;
        }
        while (n >= 1) {
            string = string + list2.get(n) + "/";
            --n;
        }
        string = string + list2.get(n);
        return string;
    }
}

