/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.xcatalog;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.wsee.tools.xcatalog.CatalogOptions;
import weblogic.wsee.tools.xcatalog.FileAnalysis;
import weblogic.wsee.tools.xcatalog.LREntityResolver;
import weblogic.wsee.tools.xcatalog.XCatalogException;
import weblogic.wsee.tools.xcatalog.XCatalogUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.xml.domimpl.DocumentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadXMLs {
    private static final boolean verbose = Verbose.isVerbose(DownloadXMLs.class);
    private static final String ENC_UTF8 = "UTF-8";
    private static final String NS_WSDL = WsdlConstants.wsdlNS;
    private static final String NS_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private HashMap<String, SavedURIInfo> savedUris = new HashMap();
    private List<String> savedFiles = new ArrayList<String>();
    private HashMap<String, String> localUris = new HashMap();
    private List<FileAnalysis> faList = new ArrayList<FileAnalysis>();
    private File xCatalogDir = null;
    private boolean copyFlag = false;
    private String encoding = "UTF-8";
    private LREntityResolver entityResolver = null;
    private HashMap<URL, String> xmlMaps = new HashMap();
    private PrintStream out;

    public DownloadXMLs() {
        this(System.out);
    }

    public DownloadXMLs(PrintStream printStream) {
        this.out = printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLegalFileName(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("%") >= 0 || string.indexOf("&") >= 0) {
            return false;
        }
        File file = new File(this.xCatalogDir, string);
        if (!file.exists()) {
            try {
                file.createNewFile();
                boolean bl = file.exists();
                return bl;
            }
            catch (IOException iOException) {
            }
            finally {
                file.deleteOnExit();
            }
            return false;
        }
        return true;
    }

    private String chg2SavedUri(String string, String string2, boolean bl) {
        String string3;
        String string4;
        int n;
        if (string.indexOf("///") > 0) {
            string = string.replaceAll("///", "/");
        }
        if (this.savedUris.containsKey(string)) {
            return this.savedUris.get((Object)string).fileName;
        }
        String string5 = string;
        int n2 = string5.lastIndexOf("/");
        if (n2 >= 0) {
            string5 = string5.substring(n2 + 1);
        }
        String string6 = string5;
        int n3 = string5.lastIndexOf(".");
        if (n3 > 0) {
            string5 = string5.substring(0, n3);
        }
        if ((n = string5.indexOf("?")) >= 0) {
            string4 = string5.substring(n + 1);
            string3 = string4.toLowerCase(Locale.ENGLISH);
            string5 = string3.startsWith("wsdl=") ? string5.substring(0, n) + string4.substring(5) : (string3.startsWith("xsd=") ? string5.substring(0, n) + string4.substring(4) : (string3.equals("wsdl") ? string5.substring(0, n) : string4));
        }
        if (!this.isLegalFileName(string5)) {
            string5 = "SYS_DEF";
        }
        string4 = string5;
        string3 = bl ? ".xsd" : ".wsdl";
        if (this.localUris.containsKey(string4 + string3)) {
            int n4 = 1;
            while (this.localUris.containsKey((string4 = string5 + "_" + n4) + string3)) {
                ++n4;
            }
        }
        string5 = string4 + string3;
        this.localUris.put(string5, "");
        SavedURIInfo savedURIInfo = new SavedURIInfo();
        savedURIInfo.fileName = string5;
        savedURIInfo.isSchema = bl;
        savedURIInfo.originalContent = string2;
        this.savedUris.put(string, savedURIInfo);
        if (!string5.equals(string6) && this.out != null) {
            this.out.println("Rename file [ " + string6 + " ] to [ " + string5 + "]");
        }
        if (verbose) {
            Verbose.say("uri=" + string);
            Verbose.say("fileName=" + string5);
        }
        return string5;
    }

    private void processNodeList(NodeList nodeList, boolean bl, String string) throws BuildException {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string2 = null;
                if (bl) {
                    if (element.hasAttribute("schemaLocation")) {
                        string2 = element.getAttribute("schemaLocation");
                    }
                } else if (element.hasAttribute("location")) {
                    string2 = element.getAttribute("location");
                }
                if (string2 == null) continue;
                String string3 = this.parseXML(string, string2, bl);
                if (string3 == null) {
                    throw new BuildException("Can not get the filename for just saved temporary file!");
                }
                if (bl) {
                    element.setAttribute("schemaLocation", string3);
                    continue;
                }
                element.setAttribute("location", string3);
            }
        }
    }

    private String getUniSystemId(InputSource inputSource) {
        if (inputSource == null) {
            return null;
        }
        String string = inputSource.getSystemId();
        return XCatalogUtil.uniqueFile(string);
    }

    private String parseXML(String string, String string2, boolean bl) throws BuildException {
        return this.parseXML(string, string2, null, bl);
    }

    private String parseXML(String string, String string2, String string3, boolean bl) {
        String[] stringArray = this.parseXML_inner(string, string2, string3, bl);
        URL uRL = XCatalogUtil.toURL(stringArray[0]);
        if (uRL != null) {
            this.xmlMaps.put(uRL, stringArray[1]);
        }
        return stringArray[1];
    }

    private String[] parseXML_inner(String string, String string2, String string3, boolean bl) throws BuildException {
        Document document;
        String[] stringArray = new String[2];
        InputSource inputSource = null;
        String string4 = string2;
        if (this.entityResolver != null) {
            try {
                inputSource = this.entityResolver.resolveEntity(string2, string2);
            }
            catch (SAXException sAXException) {
                throw new BuildException((Throwable)sAXException);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
        int n = 2;
        if (inputSource == null) {
            if (string != null && !string2.startsWith("/") && string2.indexOf(":") < 0) {
                string2 = string + "/" + string2;
            }
            inputSource = new InputSource(string2);
        } else {
            n = 1;
            if (this.entityResolver.isLocal()) {
                n = 0;
            }
        }
        if (inputSource == null) {
            throw new BuildException("Can not read the uri [ " + string2 + " ], please confirm if it exists");
        }
        stringArray[0] = string2;
        String string5 = inputSource.getSystemId();
        String string6 = this.getUniSystemId(inputSource);
        if (this.savedUris.containsKey(string6)) {
            stringArray[1] = string3 != null ? string3 : this.savedUris.get((Object)string6).fileName;
            return stringArray;
        }
        try {
            document = XCatalogUtil.getDocument(inputSource);
        }
        catch (XCatalogException xCatalogException) {
            throw new BuildException(xCatalogException.getMessage(), xCatalogException.getCause());
        }
        if (document == null) {
            throw new BuildException("Can not parse the uri [ " + string2 + " ] or it referenced uri, please confirm if it exists");
        }
        String string7 = XCatalogUtil.doc2String(document);
        String string8 = this.getSavedURI(string7, bl);
        if (string8 != null) {
            stringArray[1] = string3 != null ? string3 : string8;
            return stringArray;
        }
        FileAnalysis fileAnalysis = new FileAnalysis(n, string, string2, string5, string4);
        this.faList.add(fileAnalysis);
        String string9 = XCatalogUtil.getBaseDir(string5);
        string8 = string3 != null ? string3 : this.chg2SavedUri(string6, string7, bl);
        NodeList nodeList = document.getElementsByTagNameNS(NS_WSDL, "import");
        this.processNodeList(nodeList, false, string9);
        nodeList = document.getElementsByTagNameNS(NS_SCHEMA, "import");
        this.processNodeList(nodeList, true, string9);
        nodeList = document.getElementsByTagNameNS(NS_SCHEMA, "include");
        this.processNodeList(nodeList, true, string9);
        nodeList = document.getElementsByTagNameNS(NS_SCHEMA, "redefine");
        this.processNodeList(nodeList, true, string9);
        if (this.copyFlag && !this.savedFiles.contains(string8)) {
            try {
                File file = new File(this.xCatalogDir, string8);
                this.encoding = inputSource.getEncoding();
                if (this.encoding == null) {
                    boolean bl2;
                    boolean bl3 = bl2 = document instanceof DocumentImpl || document.getImplementation().hasFeature("Core", "3.0");
                    if (bl2) {
                        this.encoding = document.getXmlEncoding();
                    }
                }
                if (this.encoding == null) {
                    this.encoding = ENC_UTF8;
                }
                XCatalogUtil.writeDoc2File(document, file, this.encoding);
                if (this.out != null) {
                    this.out.println("Download file [" + string8 + "] to " + this.xCatalogDir.getPath());
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            this.savedFiles.add(string8);
        }
        stringArray[1] = string8;
        return stringArray;
    }

    public String parseXMLs(CatalogOptions catalogOptions, File file, String string, boolean bl) throws BuildException {
        return this.parseXMLs(catalogOptions, file, string, null, bl);
    }

    public String parseXMLs(CatalogOptions catalogOptions, File file, String string, String string2, boolean bl) throws BuildException {
        try {
            this.entityResolver = XCatalogUtil.createEntityResolver(catalogOptions);
        }
        catch (XCatalogException xCatalogException) {
            throw new BuildException((Throwable)xCatalogException);
        }
        this.copyFlag = bl;
        if (bl) {
            this.xCatalogDir = file;
            if (this.out != null) {
                this.out.println("Catalog dir = " + file.getPath());
            }
            file.mkdirs();
        }
        String string3 = this.parseXML(null, string, string2, false);
        if (file != null) {
            string3 = file.getPath() + File.separator + string3;
        }
        if (catalogOptions != null) {
            catalogOptions.setXmlMaps(this.xmlMaps);
        }
        return string3;
    }

    public List<FileAnalysis> getFileAnalysisList() {
        return this.faList;
    }

    private String getSavedURI(String string, boolean bl) {
        Iterator<String> iterator = this.savedUris.keySet().iterator();
        while (iterator.hasNext()) {
            SavedURIInfo savedURIInfo = this.savedUris.get(iterator.next());
            if (savedURIInfo.isSchema != bl || !savedURIInfo.comparesContent(string)) continue;
            return savedURIInfo.fileName;
        }
        return null;
    }

    private class SavedURIInfo {
        public boolean isSchema;
        public String fileName;
        public String originalContent;

        private SavedURIInfo() {
        }

        public boolean comparesContent(String string) {
            if (string == null || this.originalContent == null) {
                return false;
            }
            return this.originalContent.equals(string);
        }
    }
}

