/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.xcatalog;

import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.wsee.tools.xcatalog.XCatalogException;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSEECatalogResolver
implements EntityResolver {
    private static final boolean verbose = Verbose.isVerbose(WSEECatalogResolver.class);
    private static final String WSEE_CATALOG_RESOLVER = "wsee.catalog.resolver";
    public static final boolean nonWseeCatalogResolver = Boolean.getBoolean("wsee.catalog.resolver");
    private Catalog catalog = null;
    private Catalog sysCatalog = null;

    public WSEECatalogResolver() {
        this.catalog = CatalogManager.getStaticManager().getCatalog();
    }

    public WSEECatalogResolver(Catalog catalog) {
        this.catalog = catalog;
        this.validate(catalog);
    }

    private void validate(Catalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("paramater catalog can not be null!");
        }
        if (catalog.getCatalogManager() == null) {
            throw new IllegalArgumentException("paramater catalog getCatalogManager() can not be null!");
        }
    }

    public WSEECatalogResolver(Catalog catalog, Catalog catalog2) {
        this(catalog);
        if (catalog2 != null) {
            this.validate(catalog2);
            this.sysCatalog = catalog2;
        }
    }

    public static Catalog getPureCatalog(Enumeration<URL> enumeration) throws XCatalogException {
        Catalog catalog = new Catalog();
        CatalogManager catalogManager = new CatalogManager();
        try {
            catalogManager.setIgnoreMissingProperties(true);
            catalog.setCatalogManager(catalogManager);
            catalog.setupReaders();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    catalog.parseCatalog(enumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            throw new XCatalogException("failed to init catalog", exception);
        }
        return catalog;
    }

    public static Catalog getCatalog() throws XCatalogException {
        Catalog catalog = new Catalog();
        CatalogManager catalogManager = new CatalogManager();
        try {
            catalogManager.setIgnoreMissingProperties(true);
            catalog.setCatalogManager(catalogManager);
            catalog.setupReaders();
            catalog.loadSystemCatalogs();
        }
        catch (Exception exception) {
            throw new XCatalogException("failed to init catalog", exception);
        }
        return catalog;
    }

    public String getResolvedEntity(String string, String string2) {
        String string3 = null;
        string3 = this.getResolvedEntity(this.catalog, string, string2);
        if (string3 == null && this.sysCatalog != null) {
            string3 = this.getResolvedEntity(this.sysCatalog, string, string2);
        }
        return string3;
    }

    private String getResolvedEntity(Catalog catalog, String string, String string2) {
        String string3 = null;
        if (catalog == null) {
            if (verbose) {
                Verbose.log("Catalog resolution attempted with null catalog; ignored");
            }
            return null;
        }
        if (string2 != null) {
            try {
                string3 = catalog.resolveSystem(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (verbose) {
                    Verbose.log("Malformed URL exception trying to resolve " + string);
                }
                string3 = null;
            }
            catch (IOException iOException) {
                if (verbose) {
                    Verbose.log("I/O exception trying to resolve " + string);
                }
                string3 = null;
            }
        }
        if (string3 == null) {
            block17: {
                if (string != null) {
                    try {
                        string3 = catalog.resolvePublic(string, string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (verbose) {
                            Verbose.log("Malformed URL exception trying to resolve" + string);
                        }
                    }
                    catch (IOException iOException) {
                        if (!verbose) break block17;
                        Verbose.log("I/O exception trying to resolve" + string);
                    }
                }
            }
            if (string3 != null && verbose) {
                Verbose.say("Resolved public " + string + " mapping " + string3);
            }
        } else if (verbose) {
            Verbose.say("Resolved system " + string2 + " mapping " + string3);
        }
        return string3;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        block3: {
            String string3 = this.getResolvedEntity(string, string2);
            if (string3 != null) {
                try {
                    InputSource inputSource = new InputSource(string3);
                    inputSource.setPublicId(string);
                    URL uRL = new URL(string3);
                    InputStream inputStream = uRL.openStream();
                    inputSource.setByteStream(inputStream);
                    return inputSource;
                }
                catch (Exception exception) {
                    if (!verbose) break block3;
                    Verbose.log("Failed to create InputSource: " + string3);
                }
            }
        }
        return null;
    }
}

