/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.xcatalog;

import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.xml.ws.api.server.ContainerResolver;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.WebServiceException;
import org.apache.tools.ant.types.XMLCatalog;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.wsee.tools.xcatalog.CatalogOptions;
import weblogic.wsee.tools.xcatalog.LREntityResolver;
import weblogic.wsee.tools.xcatalog.WSEECatalogResolver;
import weblogic.wsee.tools.xcatalog.XCatalogException;
import weblogic.wsee.util.IOUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.dom.DOMParser;
import weblogic.xml.domimpl.Saver;
import weblogic.xml.domimpl.SaverOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCatalogUtil {
    private static final boolean verbose;
    private static final String FILE_SEPRATOR = "/";
    public static final int TYPE_RUNTIME_WAR = 0;
    public static final int TYPE_RUNTIME_NO_WAR = 1;
    public static final int TYPE_RUNTIME_UNKNOWN = 2;
    private static final String SYS_XCATALOG_FILE = "META-INF/jax-ws-catalog.xml";
    private static volatile Catalog SYS_XCATALOG;
    private static volatile Vector<URL> SYS_XURLS_Vector;

    public static Document getDocument(InputSource inputSource) throws XCatalogException {
        Document document = null;
        try {
            document = inputSource.getSystemId() != null && !"".equals(inputSource.getSystemId()) ? DOMParser.getDefaultDocumentImpl(inputSource.getSystemId()) : DOMParser.getDefaultDocumentImpl(inputSource);
        }
        catch (IOException iOException) {
            String string = "";
            if (inputSource != null) {
                string = inputSource.getSystemId();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Failed to parse the URI ");
            stringBuffer.append("or refernce ID : [" + string + "]");
            stringBuffer.append(", please check if it is correctly defined.");
            if (verbose) {
                Verbose.say(stringBuffer.toString());
                iOException.printStackTrace();
            }
            throw new XCatalogException(stringBuffer.toString(), iOException);
        }
        return document;
    }

    private static EntityResolver getEntityResolver(String string) throws IOException {
        CatalogManager.getStaticManager().setIgnoreMissingProperties(true);
        CatalogManager.getStaticManager().setUseStaticCatalog(false);
        CatalogResolver catalogResolver = new CatalogResolver(true);
        try {
            catalogResolver.getCatalog().parseCatalog(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException);
        }
        return catalogResolver;
    }

    public static LREntityResolver createEntityResolver(CatalogOptions catalogOptions) throws XCatalogException {
        LREntityResolver lREntityResolver = null;
        if (catalogOptions == null) {
            return lREntityResolver;
        }
        XMLCatalog xMLCatalog = catalogOptions.getXmlCatalog();
        File file = catalogOptions.getCatalog();
        String string = null;
        if (file != null) {
            string = file.getPath();
        }
        try {
            XMLCatalog xMLCatalog2 = null;
            EntityResolver entityResolver = null;
            if (string != null && string.length() > 0) {
                entityResolver = XCatalogUtil.getEntityResolver(string);
            }
            if (xMLCatalog != null) {
                xMLCatalog2 = xMLCatalog;
            }
            lREntityResolver = new LREntityResolver((EntityResolver)xMLCatalog2, entityResolver);
        }
        catch (IOException iOException) {
            throw new XCatalogException("bad catalog or entity definition:" + iOException.toString());
        }
        return lREntityResolver;
    }

    public static String getBaseDir(String string) {
        int n = string.lastIndexOf(FILE_SEPRATOR);
        if (n < 1) {
            return ".";
        }
        return string.substring(0, n);
    }

    public static String uniqueFile(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.startsWith("file:")) {
                string = string.substring("file:".length());
                while (string.startsWith(FILE_SEPRATOR) || string.startsWith("\\")) {
                    string = string.substring(1);
                }
                if (string.indexOf(":") < 0) {
                    string = FILE_SEPRATOR + string;
                }
            }
            File file = new File(string);
            string = file.getCanonicalPath();
            string = string.replace("\\", FILE_SEPRATOR);
            return string;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static String getRelativeFile(File file, File file2) throws IOException {
        int n;
        if (file == null || file2 == null) {
            return null;
        }
        String string = file.getName();
        String string2 = file.getPath();
        if ((string2 = XCatalogUtil.uniqueFile(string2)).length() == string.length()) {
            return string;
        }
        string2 = string2.substring(0, string2.length() - string.length());
        String string3 = file2.getCanonicalPath();
        string3 = XCatalogUtil.uniqueFile(string3);
        if (string2.endsWith(FILE_SEPRATOR)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith(FILE_SEPRATOR)) {
            string3 = string3.substring(0, string2.length() - 1);
        }
        if (verbose) {
            Verbose.say("fromFilePath=" + string2);
            Verbose.say("toDir=" + string3);
        }
        if ((n = string2.indexOf(string3)) >= 0) {
            int n2 = string2.length() > string3.length() ? 1 : 0;
            String string4 = n2 == 0 ? "" : FILE_SEPRATOR;
            return string2.substring(string3.length() + n2) + string4 + string;
        }
        n = string3.indexOf(string2);
        if (n == 0) {
            string3 = string3.substring(string2.length());
            int n3 = 0;
            while (string3.indexOf(FILE_SEPRATOR) > 0) {
                string3 = string3.replace(FILE_SEPRATOR, "_+_");
                ++n3;
            }
            String string5 = "";
            for (int i = 0; i < n3; ++i) {
                string5 = string5 + "../";
            }
            string5 = string5 + string;
            return string5;
        }
        return string2 + FILE_SEPRATOR + string;
    }

    public static EntityResolver createRuntimeCatalogResolver(int n) {
        boolean bl;
        Catalog catalog;
        CatalogManager catalogManager;
        block21: {
            catalogManager = null;
            catalog = null;
            bl = true;
            if (!WSEECatalogResolver.nonWseeCatalogResolver) {
                try {
                    catalog = WSEECatalogResolver.getCatalog();
                    bl = false;
                }
                catch (XCatalogException xCatalogException) {
                    if (!verbose) break block21;
                    Verbose.log((Object)"Goto traditional XML Catalogs processing due to:", xCatalogException);
                }
            }
        }
        if (bl) {
            catalogManager = new CatalogManager();
            catalogManager.setIgnoreMissingProperties(true);
            catalog = catalogManager.getCatalog();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object object = null;
        try {
            Object object2;
            if (n == 0 || n == 2) {
                if (classLoader == null) {
                    object = ClassLoader.getSystemResources("WEB-INF/jax-ws-catalog.xml");
                } else if (n == 2) {
                    object2 = ContainerResolver.getInstance().getContainer();
                    try {
                        Class<?> clazz;
                        Object object3;
                        Class<?> clazz2 = Class.forName("javax.servlet.ServletContext");
                        Object object4 = object3 = object2 != null ? object2.getSPI(clazz2) : null;
                        if (object3 != null && (clazz = Class.forName("weblogic.servlet.internal.WebAppServletContext")).isAssignableFrom(object3.getClass())) {
                            Method method = clazz.getMethod("getResources", String.class);
                            object = new IteratorEnumerator(Arrays.asList((URL[])method.invoke(object3, "/WEB-INF/jax-ws-catalog.xml")).iterator());
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    if (object == null || !object.hasMoreElements()) {
                        object = XCatalogUtil.getWebRunTimeCatalogs(classLoader);
                    }
                } else {
                    object = XCatalogUtil.getWebRunTimeCatalogs(classLoader);
                }
            }
            object = XCatalogUtil.trimXURLs(object);
            if (n == 1 || n == 2 && (object == null || !object.hasMoreElements())) {
                object = classLoader == null ? ClassLoader.getSystemResources(SYS_XCATALOG_FILE) : classLoader.getResources(SYS_XCATALOG_FILE);
            }
            object = XCatalogUtil.trimXURLs(object);
            while (object != null && object.hasMoreElements()) {
                object2 = object.nextElement();
                if (verbose) {
                    Verbose.log("catalog file:" + ((URL)object2).toExternalForm());
                }
                catalog.parseCatalog((URL)object2);
            }
        }
        catch (IOException iOException) {
            throw new WebServiceException((Throwable)iOException);
        }
        return new WSEECatalogResolver(catalog, SYS_XCATALOG);
    }

    private static Enumeration<URL> trimXURLs(Enumeration<URL> enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return enumeration;
        }
        Vector<URL> vector = new Vector<URL>();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            if (SYS_XURLS_Vector.contains(uRL)) continue;
            vector.add(uRL);
        }
        return vector.elements();
    }

    private static Enumeration<URL> getWebRunTimeCatalogs(ClassLoader classLoader) {
        File file;
        Enumeration enumeration = null;
        URL uRL = classLoader.getResource(FILE_SEPRATOR);
        if (uRL == null) {
            return null;
        }
        String string = uRL.getPath();
        if (string.indexOf(":") >= 0 && string.startsWith(FILE_SEPRATOR)) {
            string = string.substring(1);
        }
        if ((file = new File(string, "../jax-ws-catalog.xml")).exists()) {
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            Vector<URL> vector = new Vector<URL>();
            vector.add(uRL);
            enumeration = vector.elements();
        }
        return enumeration;
    }

    public static String doc2String(Document document) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public static void writeDoc2File(Document document, File file, String string) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        OutputStream outputStream = IOUtil.createEncodedFileOutputStream(file, string);
        SaverOptions saverOptions = SaverOptions.getDefaults();
        saverOptions.setPrettyPrint(true);
        saverOptions.setWriteXmlDeclaration(true);
        if (string != null) {
            saverOptions.setEncoding(string);
        }
        Saver.save((OutputStream)outputStream, (Document)document, (SaverOptions)saverOptions);
        outputStream.close();
    }

    public static URL toURL(String string) {
        URL uRL = null;
        try {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRL == null) {
                File file = new File(string);
                file = file.getCanonicalFile();
                uRL = file.toURI().toURL();
            }
        }
        catch (Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    static {
        block7: {
            verbose = Verbose.isVerbose(XCatalogUtil.class);
            SYS_XURLS_Vector = new Vector();
            ClassLoader classLoader = XCatalogUtil.class.getClassLoader();
            try {
                Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(SYS_XCATALOG_FILE) : classLoader.getResources(SYS_XCATALOG_FILE);
                try {
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            SYS_XURLS_Vector.add(enumeration.nextElement());
                        }
                        SYS_XCATALOG = WSEECatalogResolver.getPureCatalog(SYS_XURLS_Vector.elements());
                    }
                }
                catch (XCatalogException xCatalogException) {
                    if (verbose) {
                        Verbose.log((Object)"Failed to parse system catalog:META-INF/jax-ws-catalog.xml", xCatalogException);
                    }
                }
            }
            catch (IOException iOException) {
                if (!verbose) break block7;
                Verbose.log((Object)"Failed to parse system catalog:META-INF/jax-ws-catalog.xml", iOException);
            }
        }
    }
}

