/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.IOException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Element;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.message.WlMessageContext;

public class AddressingUtil {
    public static boolean isAnonymous(EndpointReference endpointReference) {
        return AddressingHelper.isAnonymousReferenceURI(endpointReference.getAddress());
    }

    public static boolean isAnonymous(MessageContext messageContext, EndpointReference endpointReference) {
        return AddressingHelper.isAnonymousEndpointReference(messageContext, endpointReference);
    }

    public static void confirmOneway(WlMessageContext wlMessageContext) {
        try {
            wlMessageContext.getDispatcher().getConnection().getTransport().confirmOneway();
            wlMessageContext.setProperty("weblogic.wsee.oneway.confirmed", "true");
        }
        catch (IOException iOException) {
            throw new JAXRPCException((Throwable)iOException);
        }
    }

    public static String wrapSOAPAction(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.startsWith("\"")) {
            stringBuffer.append("\"");
        }
        stringBuffer.append(string);
        if (!string.endsWith("\"")) {
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static Element retrieveAddressElement(Element element) {
        if (null == element) {
            return null;
        }
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address").item(0);
        if (element2 == null) {
            element2 = (Element)element.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address").item(0);
        }
        return element2;
    }
}

