/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.util.CompositeClassLoader;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_PROTOCOL = "jar";
    private static final String ZIP_PROTOCOL = "zip";

    private ClassLoaderUtil() {
    }

    public static URLClassLoader getClassLoader(File file) throws WsBuildException {
        if (file == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new WsBuildException(malformedURLException);
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
        return uRLClassLoader;
    }

    public static ClassLoader concat(ClassLoader ... classLoaderArray) {
        if (classLoaderArray == null) {
            return null;
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(classLoaderArray.length);
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader == null) continue;
            arrayList.add(classLoader);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (ClassLoader)arrayList.get(0);
        }
        return new CompositeClassLoader(arrayList);
    }

    public static List<URI> getSourceURIs(ClassLoader classLoader, String string) throws IOException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        Enumeration<URL> enumeration = classLoader.getResources(string);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            URI uRI = null;
            if (FILE_PROTOCOL.equals(uRL.getProtocol())) {
                uRI = ClassLoaderUtil.getDirectoryURI(uRL.toString(), string);
            } else if (JAR_PROTOCOL.equals(uRL.getProtocol())) {
                uRI = ClassLoaderUtil.getJarURI(uRL);
            } else if (ZIP_PROTOCOL.equals(uRL.getProtocol())) {
                uRI = ClassLoaderUtil.getJarURI(uRL);
            } else {
                throw new IllegalArgumentException("Class loader " + classLoader + " returned an unhandled url " + uRL);
            }
            arrayList.add(uRI);
        }
        return arrayList;
    }

    private static String replaceBlankInDir(String string) {
        string = string.replaceAll("%20", " ");
        return string;
    }

    private static URI getDirectoryURI(String string, String string2) {
        int n = string.indexOf(string2);
        assert (n > 0) : string2 + " not in URL " + string;
        return new File(ClassLoaderUtil.replaceBlankInDir(string.substring(0, n - 1))).toURI();
    }

    private static URI getJarURI(URL uRL) {
        int n;
        String string = uRL.getFile();
        int n2 = 0;
        if (string.startsWith("file:")) {
            n2 = FILE_PROTOCOL.length() + 1;
        }
        if ((n = string.indexOf(33)) == -1) {
            n = string.length();
        }
        return new File(ClassLoaderUtil.replaceBlankInDir(string.substring(Math.max(0, n2), n))).toURI();
    }

    public static boolean setURL2SystemClassLoader(URL uRL, boolean bl) {
        if (uRL == null) {
            return false;
        }
        try {
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            URL[] uRLArray = uRLClassLoader.getURLs();
            if (uRLArray != null) {
                for (URL uRL2 : uRLArray) {
                    if (uRL2 == null || !uRL2.equals(uRL)) continue;
                    if (bl) {
                        Verbose.log("URL [" + uRL + "] has existed in system class loader");
                    }
                    return true;
                }
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, uRL);
            if (bl) {
                Verbose.log("URL [" + uRL + "] is added into system class loader");
            }
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                Verbose.log("URL [" + uRL + "] failed to add into system class loader");
                Verbose.logException(exception);
            }
            return false;
        }
    }

    public static Class loadClass(ClassLoader classLoader, ClassLoader classLoader2, String string) throws ClassNotFoundException {
        DelegatingLoader delegatingLoader = new DelegatingLoader(classLoader2, classLoader);
        return delegatingLoader.loadClass(string);
    }

    public static URL getResource(ClassLoader classLoader, ClassLoader classLoader2, String string) throws ClassNotFoundException {
        DelegatingLoader delegatingLoader = new DelegatingLoader(classLoader2, classLoader);
        return delegatingLoader.getResource(string);
    }

    public static final class DelegatingLoader
    extends ClassLoader {
        private final ClassLoader loader;

        public DelegatingLoader(ClassLoader classLoader, ClassLoader classLoader2) {
            super(classLoader2);
            this.loader = classLoader;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            return this.loader.loadClass(string);
        }

        protected URL findResource(String string) {
            return this.loader.getResource(string);
        }
    }
}

