/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.sun.xml.ws.model.RuntimeModeler;
import java.lang.reflect.Method;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import weblogic.jws.CallbackService;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;

public class ClassUtil {
    private ClassUtil() {
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        return clazz;
    }

    public static String getTargetNamespace(JClass jClass) {
        JClass jClass2;
        String string;
        String string2 = null;
        JAnnotation jAnnotation = ClassUtil.getWebServiceAnnotation(jClass);
        if (jAnnotation != null && (string2 = JamUtil.getAnnotationStringValue(jAnnotation, "targetNamespace")) == null && (string = JamUtil.getAnnotationStringValue(jAnnotation, "endpointInterface")) != null && (jClass2 = jClass.forName(string)) != null && (jAnnotation = ClassUtil.getWebServiceAnnotation(jClass2)) != null) {
            string2 = JamUtil.getAnnotationStringValue(jAnnotation, "targetNamespace");
        }
        return string2;
    }

    public static String getServiceName(JClass jClass, String string) {
        String string2 = ClassUtil.getServiceNameFromAnnotation(jClass);
        if (StringUtil.isEmpty(string2)) {
            string2 = ClassUtil.getDefaultName(jClass, string) + "Service";
        }
        return ClassUtil.normalizeClassName(string2);
    }

    private static String getServiceNameFromAnnotation(JClass jClass) {
        JAnnotation jAnnotation = ClassUtil.getWebServiceAnnotation(jClass);
        if (jAnnotation != null) {
            return JamUtil.getAnnotationStringValue(jAnnotation, "serviceName");
        }
        return null;
    }

    public static String getDefaultName(JClass jClass, String string) {
        String string2 = jClass.getSimpleName();
        if (string2.indexOf("$") != -1) {
            string2 = string2.substring(string2.indexOf("$") + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append("_");
        }
        stringBuilder.append(string2);
        return ClassUtil.normalizeClassName(stringBuilder.toString());
    }

    public static JAnnotation getWebServiceAnnotation(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(WebService.class);
        if (jAnnotation == null) {
            jAnnotation = jClass.getAnnotation(WebServiceProvider.class);
        }
        if (jAnnotation == null) {
            jAnnotation = jClass.getAnnotation(CallbackService.class);
        }
        return jAnnotation;
    }

    public static boolean isWebService(JClass jClass) {
        if (jClass.isInterface()) {
            return false;
        }
        return jClass.getAnnotation(WebService.class) != null || jClass.getAnnotation(WebServiceProvider.class) != null;
    }

    public static boolean isWebService(Class clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        return clazz.getAnnotation(WebService.class) != null || clazz.getAnnotation(WebServiceProvider.class) != null;
    }

    public static String getNamespaceFromClass(WebServiceType webServiceType, JClass jClass) {
        String string = jClass.getQualifiedName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (webServiceType == WebServiceType.JAXWS) {
            return RuntimeModeler.getNamespace((String)string);
        }
        string = string.replace('.', '/');
        return "http://" + string;
    }

    public static String normalizeClassName(String string) {
        return string.replace('$', '_');
    }

    public static final boolean equalMethods(Method method, Method method2) {
        if (method == null || method2 == null) {
            return method == method2;
        }
        if (method.getName() == method2.getName()) {
            Class<?>[] classArray;
            if (!method.getReturnType().equals(method2.getReturnType())) {
                return false;
            }
            Class<?>[] classArray2 = method.getParameterTypes();
            if (classArray2.length == (classArray = method2.getParameterTypes()).length) {
                for (int i = 0; i < classArray2.length; ++i) {
                    if (classArray2[i] == classArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

