/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeClassLoader
extends ClassLoader {
    List<ClassLoader> loaders = new ArrayList<ClassLoader>();

    public CompositeClassLoader(List<ClassLoader> list) {
        assert (list != null) : "No loaders specified";
        this.loaders = list;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.loaders) {
            Class<?> clazz = classLoader.loadClass(string);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    @Override
    protected URL findResource(String string) {
        for (ClassLoader classLoader : this.loaders) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (ClassLoader classLoader : this.loaders) {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return Collections.enumeration(arrayList);
    }
}

