/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataProxyFactory {
    private PrintWriter _logWriter;
    private boolean _isLogEnabled = false;

    public CompositeDataProxyFactory(PrintWriter printWriter) throws Exception {
        this._logWriter = printWriter;
        this._isLogEnabled = this.isLogEnabled();
    }

    public <T> T createProxy(ClassLoader classLoader, Class<T> clazz, CompositeData compositeData) throws IntrospectionException {
        MyInvocationHandler<Object> myInvocationHandler = new MyInvocationHandler<Object>(clazz, compositeData);
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, myInvocationHandler);
        myInvocationHandler.setProxy(object);
        return (T)object;
    }

    private void log(String string) {
        if (this._logWriter != null) {
            this._logWriter.println(string);
        }
    }

    private boolean isLogEnabled() {
        return this._logWriter != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyInvocationHandler<T>
    implements InvocationHandler {
        private Class _intfClass;
        private CompositeData _data;
        private Map<Method, Info> _methodToInfoMap;
        private T _proxy;

        public MyInvocationHandler(Class clazz, CompositeData compositeData) throws IntrospectionException {
            this._intfClass = clazz;
            this._data = compositeData;
            if (CompositeDataProxyFactory.this._isLogEnabled) {
                CompositeDataProxyFactory.this.log("Looking for " + this._intfClass.getName() + " to wrap: " + this._data);
            }
            CompositeType compositeType = this._data.getCompositeType();
            Maps maps = this.getMapsFromCompositeDataClass(this._intfClass);
            Map<String, PropertyDescriptor> map = maps.propDescMap;
            this._methodToInfoMap = new HashMap<Method, Info>();
            for (String string : compositeType.keySet()) {
                Info info;
                String string2 = Introspector.decapitalize(string);
                PropertyDescriptor propertyDescriptor = map.get(string2);
                if (propertyDescriptor == null) {
                    propertyDescriptor = map.get(string);
                }
                if (propertyDescriptor == null) {
                    throw new IllegalArgumentException("Didn't find a JavaBean property (" + string + " or " + string2 + ") for CompositeData item " + string + " on interface: " + this._intfClass.getName());
                }
                if (propertyDescriptor.getWriteMethod() != null) {
                    info = new Info();
                    info.javaType = propertyDescriptor.getPropertyType();
                    info.direction = Direction.SET;
                    info.itemName = string;
                    this._methodToInfoMap.put(propertyDescriptor.getWriteMethod(), info);
                }
                info = new Info();
                info.javaType = propertyDescriptor.getPropertyType();
                info.direction = Direction.GET;
                info.itemName = string;
                this._methodToInfoMap.put(propertyDescriptor.getReadMethod(), info);
            }
        }

        public void setProxy(T t) {
            this._proxy = t;
        }

        private Maps getMapsFromCompositeDataClass(Class clazz) throws IntrospectionException {
            Stack<Class> stack = this.findInterfaces(clazz);
            Maps maps = new Maps();
            while (!stack.isEmpty()) {
                Class clazz2 = stack.pop();
                this.updateMapsFromCompositeDataClass(clazz2, maps);
            }
            return maps;
        }

        private Stack<Class> findInterfaces(Class clazz) {
            HashSet<Class> hashSet = new HashSet<Class>();
            Stack<Class> stack = new Stack<Class>();
            this.findInterfaces(clazz, hashSet, stack);
            return stack;
        }

        private void findInterfaces(Class clazz, Set<Class> set, Stack<Class> stack) {
            Class<?>[] classArray;
            if (set.contains(clazz)) {
                return;
            }
            set.add(clazz);
            stack.push(clazz);
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                this.findInterfaces(clazz2, set, stack);
            }
        }

        private void updateMapsFromCompositeDataClass(Class clazz, Maps maps) throws IntrospectionException {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            FeatureDescriptor[] featureDescriptorArray = propertyDescriptorArray;
            int n = featureDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                PropertyDescriptor propertyDescriptor = featureDescriptorArray[i];
                maps.propDescMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            for (FeatureDescriptor featureDescriptor : featureDescriptorArray = beanInfo.getMethodDescriptors()) {
                maps.methodDescMap.put(featureDescriptor.getName(), (MethodDescriptor)featureDescriptor);
            }
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, objectArray);
            }
            Info info = this._methodToInfoMap.get(method);
            if (info == null) {
                throw new IllegalArgumentException("Don't know how to handle method " + method.getName() + " on interface: " + this._intfClass.getName());
            }
            if (info.direction == Direction.SET) {
                throw new IllegalArgumentException("CompositeData is read-only");
            }
            Object object2 = this._data.get(info.itemName);
            if (info.javaType.isArray()) {
                Class<?> clazz = info.javaType.getComponentType();
                if (this.isCompositeDataType(clazz) && object2 != null) {
                    CompositeData[] compositeDataArray = (CompositeData[])object2;
                    object2 = Array.newInstance(clazz, compositeDataArray.length);
                    int n = 0;
                    for (CompositeData compositeData : compositeDataArray) {
                        Object obj = CompositeDataProxyFactory.this.createProxy(this.getClass().getClassLoader(), clazz, compositeData);
                        Array.set(object2, n, obj);
                        ++n;
                    }
                }
            } else if (this.isCompositeDataType(info.javaType)) {
                object2 = CompositeDataProxyFactory.this.createProxy(this.getClass().getClassLoader(), info.javaType, (CompositeData)object2);
            }
            return object2;
        }

        private boolean isCompositeDataType(Class clazz) {
            boolean bl = !clazz.isArray() && (clazz.getName().startsWith("java.lang") || clazz.isPrimitive());
            return !bl;
        }

        public String toString() {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            this.indent(n, stringBuffer).append("Type Name: ").append(this._data.getCompositeType().getTypeName()).append("\n");
            this.indent(n, stringBuffer).append("Description: ").append(this._data.getCompositeType().getDescription()).append("\n");
            this.indent(n, stringBuffer).append("Items: ").append(this._data.getCompositeType().getDescription()).append("\n");
            n = 1;
            for (Method method : this._methodToInfoMap.keySet()) {
                Info info = this._methodToInfoMap.get(method);
                if (info.direction == Direction.SET) continue;
                try {
                    Object object = method.invoke(this._proxy, new Object[0]);
                    if (object != null && object.getClass().isArray()) {
                        this.indent(n, stringBuffer).append(info.itemName).append(": ").append(object.getClass()).append("\n");
                        ++n;
                        Object[] objectArray = (Object[])object;
                        int n2 = 0;
                        for (Object object2 : objectArray) {
                            this.indent(n, stringBuffer).append("[").append(n2).append("]:").append("\n");
                            String string = object2.toString();
                            string = this.indentString(++n, string);
                            stringBuffer.append(string).append("\n");
                            --n;
                            ++n2;
                        }
                        --n;
                        continue;
                    }
                    this.indent(n, stringBuffer).append(info.itemName).append(": ").append(object).append("\n");
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString(), exception);
                }
            }
            return stringBuffer.toString();
        }

        private String indentString(int n, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.indent(n, stringBuffer).append(string2).append("\n");
            }
            return stringBuffer.toString();
        }

        private StringBuffer indent(int n, StringBuffer stringBuffer) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("    ");
            }
            return stringBuffer;
        }

        class Maps {
            public Map<String, PropertyDescriptor> propDescMap = new HashMap<String, PropertyDescriptor>();
            public Map<String, MethodDescriptor> methodDescMap = new HashMap<String, MethodDescriptor>();

            Maps() {
            }
        }

        class Info {
            Class javaType;
            Direction direction;
            String itemName;

            Info() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Direction {
        SET,
        GET;

    }
}

