/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.wsee.component.pojo.JavaClassComponent;
import weblogic.wsee.jaxrpc.StubImpl;
import weblogic.wsee.jws.JwsContext;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.ws.WsSkel;

public class ControlAPIUtil {
    public static final String ENCLOSING_CONTAINER = "weblogic.wsee.enclosing.container";

    private static List convertOutputHeaders(Element[] elementArray) {
        if (elementArray == null) {
            return null;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < elementArray.length; ++i) {
            Element element = elementArray[i];
            if (element == null) continue;
            if (("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespaceURI())) && "Header".equals(element.getLocalName())) {
                NodeList nodeList = element.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    if (!(nodeList.item(j) instanceof Element)) continue;
                    arrayList.add((Element)nodeList.item(j));
                }
                continue;
            }
            arrayList.add(element);
        }
        return arrayList;
    }

    public static Element[] getOutputHeaders(MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        List list = (List)messageContext.getProperty("weblogic.wsee.OutputHeaders");
        if (list == null) {
            return null;
        }
        Element[] elementArray = list.toArray(new Element[list.size()]);
        return elementArray;
    }

    public static void setInputHeaders(MessageContext messageContext, Element[] elementArray) {
        if (elementArray != null) {
            messageContext.setProperty("weblogic.wsee.InputHeaders", (Object)elementArray);
        }
    }

    public static void setOutputHeaders(MessageContext messageContext, Element[] elementArray) {
        List list = ControlAPIUtil.convertOutputHeaders(elementArray);
        if (list != null) {
            messageContext.setProperty("weblogic.wsee.OutputHeaders", (Object)list);
        }
    }

    public static void unsetOutputHeaders(MessageContext messageContext) {
        messageContext.removeProperty("weblogic.wsee.OutputHeaders");
    }

    public static void setOutputHeaders(Stub stub, Element[] elementArray) {
        List list = ControlAPIUtil.convertOutputHeaders(elementArray);
        if (list != null) {
            stub._setProperty("weblogic.wsee.OutputHeaders", (Object)list);
        }
    }

    public static void unsetOutputHeaders(Stub stub) {
        if (stub instanceof StubImpl) {
            ((StubImpl)stub)._removeProperty("weblogic.wsee.OutputHeaders");
        }
    }

    public static void setURI(MessageContext messageContext, String string) {
        messageContext.setProperty("weblogic.wsee.service_uri", (Object)string);
    }

    public static String getURI(MessageContext messageContext) {
        return (String)messageContext.getProperty("weblogic.wsee.service_uri");
    }

    public static Element[] getInputHeadersFromMsgContextThenSoap(MessageContext messageContext) {
        Element[] elementArray = (Element[])messageContext.getProperty("weblogic.wsee.InputHeaders");
        if (elementArray != null) {
            return elementArray;
        }
        if (messageContext instanceof SoapMessageContext) {
            SoapMessageContext soapMessageContext = (SoapMessageContext)messageContext;
            try {
                Element[] elementArray2 = new Element[]{soapMessageContext.getMessage().getSOAPHeader()};
                if (elementArray2[0] == null) {
                    return null;
                }
                return elementArray2;
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException((Throwable)sOAPException);
            }
        }
        throw new JAXRPCException("Unsupported message context type");
    }

    public static Element[] getInputHeaders(MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        Element[] elementArray = ControlAPIUtil.getInputHeadersFromMsgContextThenSoap(messageContext);
        return elementArray;
    }

    public static Element[] getInputHeaders(Stub stub) {
        Map map;
        if (stub != null && (map = (Map)stub._getProperty("weblogic.wsee.invoke_properties")) != null) {
            return (Element[])map.get("weblogic.wsee.InputHeaders");
        }
        return null;
    }

    public static JwsContext getJwsContext(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        JavaClassComponent javaClassComponent = (JavaClassComponent)((WsSkel)wlMessageContext.getDispatcher().getWsPort().getEndpoint()).getComponent();
        return ContainerFactory.getContainer(wlMessageContext, javaClassComponent.getTargetClass());
    }

    public static void finishCallbackStubConversation(Stub stub) {
        Container container = (Container)stub._getProperty(ENCLOSING_CONTAINER);
        if (container != null) {
            container.finishConversation();
            if (stub instanceof StubImpl) {
                ((StubImpl)stub)._removeProperty(ENCLOSING_CONTAINER);
            }
        } else {
            throw new IllegalStateException("Attemp to finish a conversation when the service is not conversational or has been finished.");
        }
    }
}

