/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorException;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.servlet.internal.WebAppDescriptor;

public class DescriptorBeanUtil {
    private DescriptorBeanUtil() {
    }

    public static WeblogicApplicationBean loadWeblogicAppBean(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try {
            return (WeblogicApplicationBean)new ApplicationDescriptor.MyWlsApplicationDescriptor(file).loadDescriptorBean();
        }
        catch (Exception exception) {
            throw new IOException("The existing descriptor at " + file.getAbsolutePath() + " is corrupted.\n" + exception.getMessage());
        }
    }

    public static List validateBean(File file) throws IOException {
        try {
            DescriptorBeanUtil.loadWebDescriptor(file, true);
        }
        catch (DescriptorException descriptorException) {
            return descriptorException.getErrorList();
        }
        return Collections.EMPTY_LIST;
    }

    public static DescriptorBean loadWebDescriptor(File file) throws IOException {
        return DescriptorBeanUtil.loadWebDescriptor(file, false);
    }

    private static DescriptorBean loadWebDescriptor(File file, boolean bl) throws IOException {
        if (file.getName().endsWith("web.xml")) {
            return DescriptorBeanUtil.loadWebBean(file, bl);
        }
        if (file.getName().endsWith("weblogic.xml")) {
            return DescriptorBeanUtil.loadWebLogicBean(file, bl);
        }
        throw new AssertionError((Object)(" loadWebDescriptor called with a non web descriptor: " + file.getAbsolutePath()));
    }

    private static DescriptorBean loadWebBean(File file, boolean bl) throws IOException {
        WebAppDescriptor webAppDescriptor = new WebAppDescriptor(file, (File)null, null, null, null);
        webAppDescriptor.setValidateSchema(bl);
        try {
            return (DescriptorBean)webAppDescriptor.getWebAppBean();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException("Exception parsing web.xml: " + xMLStreamException);
        }
    }

    private static DescriptorBean loadWebLogicBean(File file, boolean bl) throws IOException {
        WebAppDescriptor webAppDescriptor = new WebAppDescriptor((File)null, file, null, null, null);
        webAppDescriptor.setValidateSchema(bl);
        try {
            return (DescriptorBean)webAppDescriptor.getWeblogicWebAppBean();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException("Exception parsing weblogic.xml: " + xMLStreamException);
        }
    }
}

