/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import com.bea.staxb.buildtime.ArrayNameHelper;
import com.bea.staxb.buildtime.FaultMessage;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JConstructor;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.ExceptionInfo;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlPart;

public final class ExceptionUtil {
    private static final String XSNS = "http://www.w3.org/2001/XMLSchema";

    public static boolean isMarshalPropertyException(List list, String string) {
        if (list != null && list.size() > 1) {
            return false;
        }
        if (string.contains("[")) {
            return true;
        }
        return ExceptionUtil.nonColonizedSimpleBuiltinForJavaClassName(string) != null;
    }

    public static ExceptionInfo getExceptionInfo(BuildtimeBindings buildtimeBindings, WsdlMessage wsdlMessage) {
        Iterator<? extends WsdlPart> iterator = wsdlMessage.getParts().values().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("ExceptionUtil.getExceptionInfo: Fault WsdlMessage " + wsdlMessage.getName() + " has no message part.");
        }
        WsdlPart wsdlPart = iterator.next();
        String string = null;
        String string2 = null;
        String string3 = null;
        List list = null;
        FaultMessage faultMessage = new FaultMessage();
        faultMessage.setMessageName(wsdlMessage.getName());
        faultMessage.setPartName(wsdlPart.getName());
        if (wsdlPart.getType() != null) {
            faultMessage.setComponentName(wsdlPart.getType());
            string2 = buildtimeBindings.getWrappedSimpleClassNameFromFaultMessageType(faultMessage);
            if (string2 == null) {
                string = buildtimeBindings.getExceptionClassFromFaultMessageType(faultMessage);
            } else {
                string3 = buildtimeBindings.getExceptionClassFromFaultMessageType(faultMessage);
                string = string2;
            }
            list = buildtimeBindings.getElementNamesCtorOrderFromFaultMessageType(faultMessage);
        } else {
            faultMessage.setComponentName(wsdlPart.getElement());
            string2 = buildtimeBindings.getWrappedSimpleClassNameFromFaultMessageElement(faultMessage);
            if (string2 == null) {
                string = buildtimeBindings.getExceptionClassFromFaultMessageElement(faultMessage);
            } else {
                string3 = buildtimeBindings.getExceptionClassFromFaultMessageElement(faultMessage);
                string = string2;
            }
            list = buildtimeBindings.getElementNamesCtorOrderFromFaultMessageElement(faultMessage);
        }
        if (string == null) {
            throw new AssertionError((Object)("Java exception mapping for wsdl message " + wsdlMessage.getName() + " is not found."));
        }
        ExceptionInfo exceptionInfo = new ExceptionInfo(string3, string, list);
        return exceptionInfo;
    }

    public static String getMessage(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        while (throwable != null) {
            stringBuffer.append("\n  + ");
            stringBuffer.append(throwable.getClass().getName());
            stringBuffer.append(": ");
            stringBuffer.append(throwable.getMessage());
            throwable = throwable.getCause();
        }
        return stringBuffer.toString();
    }

    public static Throwable unwrapException(Throwable throwable, StringBuilder stringBuilder) {
        if (throwable.getMessage() != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" -> ");
            }
            stringBuilder.append(throwable.getMessage());
            stringBuilder.append("\n");
        }
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            if (invocationTargetException.getTargetException() != null) {
                return ExceptionUtil.unwrapException(invocationTargetException.getTargetException(), stringBuilder);
            }
            return throwable;
        }
        if (throwable instanceof InvocationException) {
            InvocationException invocationException = (InvocationException)throwable;
            if (invocationException.getCause() != null) {
                return ExceptionUtil.unwrapException(invocationException.getCause(), stringBuilder);
            }
            return throwable;
        }
        if (throwable instanceof JAXRPCException) {
            JAXRPCException jAXRPCException = (JAXRPCException)throwable;
            if (jAXRPCException.getLinkedCause() != null) {
                return ExceptionUtil.unwrapException(jAXRPCException.getLinkedCause(), stringBuilder);
            }
            return throwable;
        }
        if (throwable instanceof SOAPException) {
            SOAPException sOAPException = (SOAPException)throwable;
            if (sOAPException.getCause() != null) {
                return ExceptionUtil.unwrapException(sOAPException.getCause(), stringBuilder);
            }
            return throwable;
        }
        if (throwable instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)throwable;
            return remoteException.detail == null ? remoteException : remoteException.detail;
        }
        if (throwable instanceof ComponentException) {
            ComponentException componentException = (ComponentException)throwable;
            return componentException.getCause() == null ? componentException : ExceptionUtil.unwrapException(componentException.getCause(), stringBuilder);
        }
        return throwable;
    }

    public static Object getPropertyValue(Object object, Class clazz) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("get") || !methodArray[i].getReturnType().equals(clazz) || methodArray[i].getParameterTypes().length != 0) continue;
            try {
                return methodArray[i].invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }
        return null;
    }

    public static boolean hasSingleArgConstructorOnly(Class clazz) {
        return ExceptionUtil.getConstructorForSingleArgClass(clazz) != null;
    }

    public static Constructor getConstructorForSingleArgClass(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        Constructor<?> constructor = null;
        int n = 0;
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length > 1) {
                return null;
            }
            if (classArray.length != 1) continue;
            if (++n > 1) {
                return null;
            }
            constructor = constructorArray[i];
        }
        return constructor;
    }

    public static boolean isMarshalPropertyJavaClass(Class clazz) {
        if (clazz.isArray()) {
            return true;
        }
        return ExceptionUtil.nonColonizedSimpleBuiltinForJavaClass(clazz) != null;
    }

    public static String nonColonizedSimpleBuiltinForJavaClass(Class clazz) {
        String string = null;
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "int";
            } else if (clazz == Long.TYPE) {
                string = "long";
            } else if (clazz == Short.TYPE) {
                string = "short";
            } else if (clazz == Float.TYPE) {
                string = "float";
            } else if (clazz == Double.TYPE) {
                string = "double";
            } else if (clazz == Boolean.TYPE) {
                string = "boolean";
            } else if (clazz == Byte.TYPE) {
                string = "byte";
            }
        } else {
            string = clazz.getName();
        }
        return ExceptionUtil.nonColonizedSimpleBuiltinForJavaClassName(string);
    }

    private static String nonColonizedSimpleBuiltinForJavaClassName(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("int")) {
            return "int";
        }
        if (string.equals("long")) {
            return "long";
        }
        if (string.equals("short")) {
            return "short";
        }
        if (string.equals("float")) {
            return "float";
        }
        if (string.equals("double")) {
            return "double";
        }
        if (string.equals("boolean")) {
            return "boolean";
        }
        if (string.equals("byte")) {
            return "byte";
        }
        if (string.equals("java.lang.String")) {
            return "string";
        }
        if (string.equals("java.lang.Integer")) {
            return "int";
        }
        if (string.equals("java.lang.Long")) {
            return "long";
        }
        if (string.equals("java.lang.Short")) {
            return "short";
        }
        if (string.equals("java.lang.Float")) {
            return "float";
        }
        if (string.equals("java.lang.Double")) {
            return "double";
        }
        if (string.equals("java.lang.Boolean")) {
            return "boolean";
        }
        if (string.equals("java.lang.Byte")) {
            return "byte";
        }
        if (string.equals("java.math.BigInteger")) {
            return "integer";
        }
        if (string.equals("java.math.BigDecimal")) {
            return "decimal";
        }
        if (string.equals("java.util.Calendar")) {
            return "datetime";
        }
        if (string.equals("java.util.GregorianCalendar")) {
            return "datetime";
        }
        if (string.equals("java.util.Date")) {
            return "datetime";
        }
        if (string.equals("javax.xml.namespace.QName")) {
            return "qname";
        }
        if (string.equals("java.net.URI")) {
            return "anyURI";
        }
        return null;
    }

    public static boolean classNameIsSchemaBuiltin(String string) {
        return ExceptionUtil.nonColonizedSimpleBuiltinForJavaClassName(string) != null;
    }

    public static boolean isMarshalPropertyException(JClass jClass) {
        if (!ExceptionUtil.isUserException(jClass)) {
            return false;
        }
        JClass jClass2 = ExceptionUtil.getMarshalPropertyJClass(jClass);
        return jClass2 != null;
    }

    public static JClass getMarshalPropertyJClass(JClass jClass) {
        JClass jClass2 = ExceptionUtil.getMarshalPropertyType(jClass);
        if (jClass2 == null) {
            return null;
        }
        if (ExceptionUtil.getPropertyName(jClass, jClass2) != null) {
            return jClass2;
        }
        return null;
    }

    private static String getPropertyName(JClass jClass, JClass jClass2) {
        JMethod[] jMethodArray = jClass.getMethods();
        for (int i = 0; i < jMethodArray.length; ++i) {
            String string = jMethodArray[i].getSimpleName();
            if (!string.startsWith("get") || string.length() <= 3 || !jMethodArray[i].getReturnType().getQualifiedName().equals(jClass2.getQualifiedName()) || jMethodArray[i].getParameters().length != 0) continue;
            return string.substring(3);
        }
        return null;
    }

    private static JClass getMarshalPropertyType(JClass jClass) {
        JClass jClass2 = jClass.getClassLoader().loadClass("java.lang.Exception");
        if (!jClass2.isAssignableFrom(jClass)) {
            throw new IllegalArgumentException(jClass.getQualifiedName() + " is not an exception.");
        }
        JConstructor[] jConstructorArray = jClass.getConstructors();
        HashSet<JParameter> hashSet = new HashSet<JParameter>();
        for (int i = 0; i < jConstructorArray.length; ++i) {
            JParameter jParameter = jConstructorArray[i].getParameters();
            if (((JParameter[])jParameter).length == 0) continue;
            if (((JParameter[])jParameter).length > 1) {
                return null;
            }
            hashSet.add(jParameter[0]);
        }
        for (JParameter jParameter : hashSet) {
            JClass jClass3 = jParameter.getType();
            if (ExceptionUtil.jClassIsBuiltinSchema(jClass3)) {
                return jClass3;
            }
            if (!jClass3.isArrayType()) continue;
            return jClass3;
        }
        return null;
    }

    public static boolean isUserException(JClass jClass) {
        JClass jClass2 = jClass.getClassLoader().loadClass("java.lang.RuntimeException");
        JClass jClass3 = jClass.getClassLoader().loadClass("java.rmi.RemoteException");
        if (jClass2.isAssignableFrom(jClass)) {
            return false;
        }
        if (jClass3.isAssignableFrom(jClass)) {
            return false;
        }
        if ("java.lang.Exception".equals(jClass.getQualifiedName())) {
            return false;
        }
        return !jClass.getQualifiedName().startsWith("java.sql");
    }

    public static boolean jClassIsBuiltinSchema(JClass jClass) {
        return ExceptionUtil.nonColonizedSimpleBuiltinForJClass(jClass) != null;
    }

    public static String nonColonizedSimpleBuiltinForJClass(JClass jClass) {
        String string = null;
        if (jClass.isPrimitiveType()) {
            Class clazz = jClass.getPrimitiveClass();
            return ExceptionUtil.nonColonizedSimpleBuiltinForJavaClass(clazz);
        }
        string = jClass.getQualifiedName();
        return ExceptionUtil.nonColonizedSimpleBuiltinForJavaClassName(string);
    }

    public static QName getDefaultExceptionElement(JClass jClass) {
        return ExceptionUtil.getDefaultExceptionElement(jClass, null);
    }

    public static QName getDefaultExceptionElement(JClass jClass, String string) {
        String string2 = jClass.getQualifiedName();
        String string3 = jClass.getSimpleName();
        String string4 = null;
        if (string != null) {
            string4 = string;
        } else {
            String string5 = string2.substring(0, string2.lastIndexOf("."));
            string4 = "java:" + string5;
        }
        return new QName(string4, string3);
    }

    public static QName exceptionMarshalPropertyElementName(JClass jClass, JClass jClass2) {
        JClass jClass3 = ExceptionUtil.getMarshalPropertyType(jClass2);
        if (jClass3.isArrayType()) {
            return ExceptionUtil.litArrayBindingTypeQName(jClass, jClass3);
        }
        String string = ExceptionUtil.nonColonizedSimpleBuiltinForJClass(jClass3);
        if (string == null) {
            return null;
        }
        String string2 = jClass2.getQualifiedName();
        String string3 = string2.substring(0, string2.lastIndexOf("."));
        return new QName(string3, string);
    }

    private static QName litArrayBindingTypeQName(JClass jClass, JClass jClass2) {
        if (jClass2.isArrayType()) {
            int n = jClass2.getArrayDimensions();
            JClass jClass3 = jClass2.getArrayComponentType();
            if (ExceptionUtil.jClassIsBuiltinSchema(jClass3)) {
                String string = ExceptionUtil.nonColonizedSimpleBuiltinForJClass(jClass3);
                return ArrayNameHelper.getLiteralArrayTypeName((String)ClassUtil.getTargetNamespace(jClass), (JClass)jClass, (JClass)jClass2, (String)string);
            }
            String string = jClass3.getSimpleName();
            return ArrayNameHelper.getLiteralArrayTypeName((String)ClassUtil.getTargetNamespace(jClass), (JClass)jClass, (JClass)jClass2, (String)string);
        }
        throw new IllegalArgumentException(" ExceptionUtil.litArrayBindingTypeQName called with non-array class argument '" + jClass2 + "'");
    }
}

