/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.kernel.KernelStatus;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.util.WLSOAPFactory;
import weblogic.xml.saaj.SOAPConstants;

@Deprecated
public final class FaultUtil {
    private static final String FAULT_URI = "http://www.bea.com/servers/wls70/webservice/fault/1.0.0";
    private static final String FAULT_PREFIX = "bea_fault";
    private static final SOAPFactory soapFactory = FaultUtil.getSoapFactory();
    private static final Name FAULT_NAME = FaultUtil.createFaultName();
    private static final List<String> SOAP12_FAULT_CODES = Arrays.asList("VersionMismatch", "MustUnderstand", "DataEncodingUnknown", "Sender", "Receiver");

    private static SOAPFactory getSoapFactory() {
        return WLSOAPFactory.createSOAPFactory();
    }

    private static Name createFaultName() {
        try {
            return soapFactory.createName("stacktrace", FAULT_PREFIX, FAULT_URI);
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    public static Detail newDetail() {
        try {
            return soapFactory.createDetail();
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    public static void throwSOAPFaultException(String string, String string2, Throwable throwable) throws SOAPFaultException {
        Detail detail = null;
        if (throwable != null) {
            detail = FaultUtil.newDetail(throwable);
        }
        throw new SOAPFaultException(new QName("env", string), string2, null, detail);
    }

    public static Detail newDetail(Throwable throwable) {
        if (throwable instanceof SOAPFaultException) {
            return ((SOAPFaultException)throwable).getDetail();
        }
        Detail detail = FaultUtil.newDetail();
        return FaultUtil.fillDetail(throwable, detail);
    }

    public static Detail fillDetail(Throwable throwable, Detail detail, boolean bl) {
        if (!bl) {
            FaultUtil.fillStackTrace(throwable, detail);
        } else {
            try {
                detail.addDetailEntry(new QName("java.io", "string", "java")).addTextNode(FaultUtil.getDettailString(throwable));
            }
            catch (SOAPException sOAPException) {
                throw new AssertionError((Object)sOAPException);
            }
        }
        return detail;
    }

    public static Detail fillDetail(Throwable throwable, Detail detail) {
        return FaultUtil.fillDetail(throwable, detail, FaultUtil.isProductionMode());
    }

    private static boolean isProductionMode() {
        if (!KernelStatus.isServer()) {
            return false;
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return ManagementService.getRuntimeAccess(authenticatedSubject).getDomain().isProductionModeEnabled();
    }

    private static String getDettailString(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(throwable.toString());
            stringBuffer.append("\n");
        } while ((throwable = throwable.getCause()) != null);
        return stringBuffer.toString();
    }

    private static Detail fillStackTrace(Throwable throwable, Detail detail) {
        try {
            DetailEntry detailEntry = detail.addDetailEntry(FAULT_NAME);
            detailEntry.addNamespaceDeclaration(FAULT_PREFIX, FAULT_URI);
            StringBuffer stringBuffer = new StringBuffer();
            Throwable throwable2 = throwable;
            String string = "";
            do {
                stringBuffer.append(string);
                stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable2));
                throwable2 = throwable2.getCause();
                string = "Caused by: ";
            } while (throwable2 != null);
            detailEntry.addTextNode(stringBuffer.toString());
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
        return detail;
    }

    public static void fillFault(SOAPFault sOAPFault, Throwable throwable, String string) throws SOAPException {
        boolean bl = true;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(sOAPFault.getNamespaceURI())) {
            bl = false;
        }
        if (throwable instanceof SOAPFaultException) {
            SOAPFaultException sOAPFaultException = (SOAPFaultException)throwable;
            FaultUtil.addFaultCode(sOAPFault, sOAPFaultException, bl);
            sOAPFault.setFaultString(sOAPFaultException.getFaultString());
            String string2 = sOAPFaultException.getFaultActor();
            if (string2 != null) {
                sOAPFault.setFaultActor(string2);
            }
            if (sOAPFaultException.getDetail() != null) {
                if (sOAPFault.getDetail() != null) {
                    sOAPFault.removeChild((Node)sOAPFault.getDetail());
                }
                if (FaultUtil.useStandardSoap12Fault(bl)) {
                    FaultUtil.fillSoap12Detail(sOAPFaultException.getDetail(), sOAPFault);
                } else {
                    sOAPFault.addChildElement((SOAPElement)sOAPFaultException.getDetail());
                }
            }
        } else if (FaultUtil.isAuthError(throwable)) {
            if (FaultUtil.useStandardSoap12Fault(bl)) {
                FaultUtil.setSoap12FaultCode(sOAPFault, "Sender.Authentication");
            } else {
                sOAPFault.setFaultCode("env:Client.Authentication");
            }
            sOAPFault.setFaultString(string);
            FaultUtil.fillDetail(throwable, sOAPFault.addDetail());
        } else {
            if (FaultUtil.useStandardSoap12Fault(bl)) {
                FaultUtil.setSoap12FaultCode(sOAPFault, "Receiver");
            } else {
                sOAPFault.setFaultCode("env:Server");
            }
            sOAPFault.setFaultString(string);
            FaultUtil.fillDetail(throwable, sOAPFault.addDetail());
        }
    }

    private static boolean isAuthError(Throwable throwable) {
        String string = throwable.getClass().getName();
        return string.endsWith("AccessException") || string.endsWith("AccessLocalException");
    }

    private static void addFaultCode(SOAPFault sOAPFault, SOAPFaultException sOAPFaultException, boolean bl) throws SOAPException {
        QName qName = sOAPFaultException.getFaultCode();
        if (qName == null) {
            if (FaultUtil.useStandardSoap12Fault(bl)) {
                sOAPFault.setFaultCode("env:Receiver");
            } else {
                sOAPFault.setFaultCode("env:Server");
            }
        } else {
            String string = qName.getLocalPart();
            String string2 = qName.getNamespaceURI();
            if (string == null || "".equals(string)) {
                string = "Server";
            }
            if (string2 == null) {
                if (FaultUtil.useStandardSoap12Fault(bl)) {
                    FaultUtil.setSoap12FaultCode(sOAPFault, string);
                } else {
                    sOAPFault.setFaultCode("env:" + string);
                }
            } else {
                String string3 = qName.getPrefix();
                if (string3 == null || "".equals(string3)) {
                    string3 = "fault";
                }
                sOAPFault.addNamespaceDeclaration(string3, string2);
                if (FaultUtil.useStandardSoap12Fault(bl)) {
                    FaultUtil.setSoap12FaultCode(sOAPFault, string, string2, string3);
                } else {
                    sOAPFault.setFaultCode(string3 + ":" + string);
                }
            }
        }
    }

    public static SOAPMessage exception2Fault(MessageFactory messageFactory, Throwable throwable) {
        try {
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            if (sOAPBody == null) {
                sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().addBody();
            }
            SOAPFault sOAPFault = sOAPBody.addFault();
            StringBuilder stringBuilder = new StringBuilder();
            throwable = ExceptionUtil.unwrapException(throwable, stringBuilder);
            FaultUtil.fillFault(sOAPFault, throwable, stringBuilder.toString());
            return sOAPMessage;
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    private static boolean useStandardSoap12Fault(boolean bl) {
        return bl;
    }

    private static void setSoap12FaultSubCode(SOAPFault sOAPFault, String string, String string2, String string3) throws SOAPException {
        QName qName = null;
        qName = string2 != null ? new QName(string2, string, string3) : new QName(sOAPFault.getNamespaceURI(), string, "env");
        sOAPFault.appendFaultSubcode(qName);
    }

    private static void setSoap12FaultCode(SOAPFault sOAPFault, String string) throws SOAPException {
        FaultUtil.setSoap12FaultCode(sOAPFault, string, null, null);
    }

    private static void setSoap12FaultCode(SOAPFault sOAPFault, String string, String string2, String string3) throws SOAPException {
        String[] stringArray = string.trim().split("\\.", 2);
        stringArray[0] = FaultUtil.soap12FaultCodeTransform(stringArray[0]);
        if (SOAP12_FAULT_CODES.contains(stringArray[0])) {
            sOAPFault.setFaultCode("env:" + stringArray[0]);
            if (stringArray.length > 1) {
                FaultUtil.setSoap12FaultSubCode(sOAPFault, stringArray[1], string2, string3);
            }
        } else {
            sOAPFault.setFaultCode("env:Receiver");
            FaultUtil.setSoap12FaultSubCode(sOAPFault, string, string2, string3);
        }
    }

    private static String soap12FaultCodeTransform(String string) {
        if ("Server".equals(string)) {
            return "Receiver";
        }
        if ("Client".equals(string)) {
            return "Sender";
        }
        return string;
    }

    private static Detail fillSoap12Detail(Detail detail, SOAPFault sOAPFault) throws SOAPException {
        NodeList nodeList = detail.getChildNodes();
        Detail detail2 = sOAPFault.addDetail();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = sOAPFault.getOwnerDocument().importNode(nodeList.item(i), true);
            detail2.appendChild(node);
        }
        return detail2;
    }

    private static void addSupportHeader(SOAPMessage sOAPMessage) throws SOAPException {
        SOAPHeaderElement sOAPHeaderElement = sOAPMessage.getSOAPHeader().addHeaderElement(SOAPConstants.HEADER12_UPGRADE);
        SOAPElement sOAPElement = sOAPHeaderElement.addChildElement(SOAPConstants.HEADER12_SUPPORTED_ENVELOPE);
        sOAPElement.setAttributeNS(null, "qname", "Envelope");
    }

    public static SOAPMessage createVersionMismatchMsg(boolean bl, Throwable throwable) {
        try {
            if (throwable instanceof SOAPFaultException) {
                SOAPBody sOAPBody;
                SOAPFaultException sOAPFaultException = (SOAPFaultException)throwable;
                MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(false);
                SOAPMessage sOAPMessage = messageFactory.createMessage();
                if (bl) {
                    FaultUtil.addSupportHeader(sOAPMessage);
                }
                if ((sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody()) == null) {
                    sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().addBody();
                }
                SOAPFault sOAPFault = sOAPBody.addFault();
                FaultUtil.fillFault(sOAPFault, sOAPFaultException, sOAPFaultException.getMessage());
                return sOAPMessage;
            }
            throw new SOAPException("Illegal SOAPFaultException", throwable);
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    public static boolean isVersionMismatch(Throwable throwable) {
        SOAPFaultException sOAPFaultException;
        return throwable instanceof SOAPFaultException && (sOAPFaultException = (SOAPFaultException)throwable).getFaultCode() != null && "VersionMismatch".equals(sOAPFaultException.getFaultCode().getLocalPart());
    }
}

