/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.util.Verbose;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class HeaderUtil {
    private static final boolean verbose = Verbose.isVerbose(HeaderUtil.class);

    public static void throwMustUnderstand(MessageContext messageContext) {
        if (messageContext instanceof SOAPMessageContext) {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            try {
                HeaderUtil.checkMustUnderstandHeader(sOAPMessageContext.getMessage().getSOAPHeader());
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException("Failed to get soap message from context", (Throwable)sOAPException);
            }
        }
    }

    public static void checkMustUnderstandHeader(SOAPHeader sOAPHeader) {
        if (sOAPHeader == null) {
            return;
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            if (!sOAPHeaderElement.getMustUnderstand()) continue;
            String string = "MustUnderstand header not processed '" + sOAPHeaderElement.getElementName() + "'";
            throw new SOAPFaultException(new QName(sOAPHeaderElement.getNamespaceURI(), "MustUnderstand"), string, null, null);
        }
    }

    public static void removeMustUnderstandFromHeader(MsgHeader msgHeader, SOAPMessage sOAPMessage) {
        try {
            if (msgHeader.isMustUnderstand()) {
                SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
                if (sOAPHeader == null) {
                    return;
                }
                Element element = DOMUtils.getElementByTagNameNS((Element)sOAPHeader, msgHeader.getName().getNamespaceURI(), msgHeader.getName().getLocalPart());
                if (element == null) {
                    return;
                }
                HeaderUtil.removeMustUnderstandFromHeader(element);
            }
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)sOAPException);
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new JAXRPCException((Throwable)((Object)dOMProcessingException));
        }
    }

    public static void removeMustUnderstandFromHeader(Element element) {
        String string = null;
        string = element.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        if (string != null && !string.equals("")) {
            if (verbose) {
                Verbose.log("Setting " + element.getLocalName() + "/" + "http://schemas.xmlsoap.org/soap/envelope/" + ": " + "mustUnderstand" + " to 0");
            }
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "0");
            return;
        }
        string = element.getAttributeNS("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand");
        if (string != null && !string.equals("")) {
            if (verbose) {
                Verbose.log("Setting " + element.getLocalName() + "/" + "http://www.w3.org/2003/05/soap-envelope" + ": " + "mustUnderstand" + " to 0");
            }
            element.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand", "0");
            return;
        }
    }
}

