/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.awt.Image;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import javax.xml.transform.Source;
import weblogic.wsee.holders.DataHandlerHolder;
import weblogic.wsee.holders.ImageHolder;
import weblogic.wsee.holders.MimeMultipartHolder;
import weblogic.wsee.holders.SourceHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolderUtil {
    private static HashMap stdHolderClass = HolderUtil.loadMap();
    private static Set<String> primitiveTypes = HolderUtil.primitiveTypes();
    private static Map<String, String> mimeBindingHolderMapping = HolderUtil.mimeBinding();

    private static Set<String> primitiveTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(Integer.TYPE.getName());
        hashSet.add(Float.TYPE.getName());
        hashSet.add(Short.TYPE.getName());
        hashSet.add(Double.TYPE.getName());
        hashSet.add(Long.TYPE.getName());
        hashSet.add(Byte.TYPE.getName());
        hashSet.add(Boolean.TYPE.getName());
        return hashSet;
    }

    private static Map<String, String> mimeBinding() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(Image.class.getName(), ImageHolder.class.getName());
        hashMap.put(MimeMultipart.class.getName(), MimeMultipartHolder.class.getName());
        hashMap.put(DataHandler.class.getName(), DataHandlerHolder.class.getName());
        hashMap.put(Source.class.getName(), SourceHolder.class.getName());
        return hashMap;
    }

    private static HashMap loadMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(String.class.getName(), StringHolder.class.getName());
        hashMap.put(Integer.TYPE.getName(), IntHolder.class.getName());
        hashMap.put(Float.TYPE.getName(), FloatHolder.class.getName());
        hashMap.put(Short.TYPE.getName(), ShortHolder.class.getName());
        hashMap.put(Double.TYPE.getName(), DoubleHolder.class.getName());
        hashMap.put(Long.TYPE.getName(), LongHolder.class.getName());
        hashMap.put(Byte.TYPE.getName(), ByteHolder.class.getName());
        hashMap.put(Boolean.TYPE.getName(), BooleanHolder.class.getName());
        hashMap.put(Integer.class.getName(), IntegerWrapperHolder.class.getName());
        hashMap.put(Float.class.getName(), FloatWrapperHolder.class.getName());
        hashMap.put(Short.class.getName(), ShortWrapperHolder.class.getName());
        hashMap.put(Double.class.getName(), DoubleWrapperHolder.class.getName());
        hashMap.put(Long.class.getName(), LongWrapperHolder.class.getName());
        hashMap.put(Byte.class.getName(), ByteWrapperHolder.class.getName());
        hashMap.put(Boolean.class.getName(), BooleanWrapperHolder.class.getName());
        hashMap.put(BigInteger.class.getName(), BigIntegerHolder.class.getName());
        hashMap.put(BigDecimal.class.getName(), BigDecimalHolder.class.getName());
        hashMap.put(QName.class.getName(), QNameHolder.class.getName());
        hashMap.put(Object.class.getName(), ObjectHolder.class.getName());
        hashMap.put(Calendar.class.getName(), CalendarHolder.class.getName());
        hashMap.put(MimeMultipart.class.getName(), MimeMultipartHolder.class.getName());
        hashMap.put(DataHandler.class.getName(), DataHandlerHolder.class.getName());
        hashMap.put(Image.class.getName(), ImageHolder.class.getName());
        hashMap.put(Source.class.getName(), SourceHolder.class.getName());
        return hashMap;
    }

    public static String getMimeBindingJavaHolderTypeFromMimeBindingJavaType(String string) {
        return (string = mimeBindingHolderMapping.get(string)) == null ? DataHandlerHolder.class.getName() : string;
    }

    public static String getStandardHolder(String string) {
        return (String)stdHolderClass.get(string);
    }

    public static boolean isStandardHolderClass(String string) {
        if (string != null) {
            return string.trim().startsWith(Holder.class.getPackage().getName());
        }
        return false;
    }

    public static String getHolderClass(String string) {
        String string2 = (String)stdHolderClass.get(string);
        if (string2 != null) {
            return string2;
        }
        int n = string.lastIndexOf(".");
        if (n != -1) {
            String string3 = string.substring(0, n);
            if (string3.endsWith(".holders") && string.endsWith("Holder")) {
                return string;
            }
            if (string3.equals("oracle.sql")) {
                return string;
            }
        }
        return HolderUtil.getHolderPackage(string) + "." + HolderUtil.getShortHolderName(string) + "Holder";
    }

    public static String getHolderPackage(String string) {
        String string2;
        int n = string.lastIndexOf(".");
        string2 = n == -1 ? (HolderUtil.isPrimitiveType(string) ? "language_builtins.holders" : "holders") : ((string2 = string.substring(0, n)).startsWith("java") ? "language_builtins.holders" : string2 + ".holders");
        return string2;
    }

    public static String getShortHolderName(String string) {
        int n = string.lastIndexOf(".");
        String string2 = n == -1 ? string : string.substring(n + 1, string.length());
        return HolderUtil.fixIfArrayName(string2);
    }

    public static boolean isPrimitiveType(String string) {
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
        }
        return primitiveTypes.contains(string);
    }

    public static String fixIfArrayName(String string) {
        String string2 = string.trim();
        int n = 0;
        while (string2.endsWith("[]")) {
            string2 = string2.substring(0, string2.length() - 2);
            ++n;
        }
        for (int i = n; i > 0; --i) {
            string2 = string2 + "Array";
        }
        return string2;
    }

    public static Class getRealType(Class clazz) {
        if (!Holder.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        try {
            Field field = clazz.getField("value");
            return field.getType();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)("Not a holder class:" + noSuchFieldException));
        }
    }

    public static void setHolderValue(Object object, Object object2) {
        if (object == null) {
            throw new JAXRPCException("holder can not be null");
        }
        try {
            Field field = object.getClass().getField("value");
            field.set(object, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JAXRPCException("unable to set value: " + object2 + " on the holder: " + object, (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCException("unable to set value: " + object2 + " on the holder: " + object, (Throwable)illegalAccessException);
        }
    }

    public static Object getHolderValue(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Holder)) {
            return object;
        }
        try {
            Field field = object.getClass().getField("value");
            return field.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JAXRPCException("unable to find field 'value' in the holder class " + object.getClass(), (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCException("unable to find field 'value' in the holder class " + object.getClass(), (Throwable)illegalAccessException);
        }
    }

    public static class NameCollisionsFilter {
        private Map<String, List<String>> duplicateNameGroup = new HashMap<String, List<String>>();
        private Set<String> sorted = new HashSet<String>();
        private static NameCollisionsFilter instance = null;

        private NameCollisionsFilter() {
        }

        public static NameCollisionsFilter getInstance() {
            if (instance == null) {
                instance = new NameCollisionsFilter();
            }
            return instance;
        }

        public void reset() {
            this.duplicateNameGroup.clear();
            this.sorted.clear();
        }

        public void use(String string) {
            List<Object> list = null;
            if (this.duplicateNameGroup.containsKey(string.toLowerCase(Locale.ENGLISH))) {
                list = this.duplicateNameGroup.get(string.toLowerCase(Locale.ENGLISH));
            } else {
                list = new ArrayList();
                this.duplicateNameGroup.put(string.toLowerCase(Locale.ENGLISH), list);
            }
            if (list != null && !list.contains(string)) {
                list.add(string);
            }
        }

        private int getSortedOrder(String string) {
            List<String> list;
            if (this.duplicateNameGroup.containsKey(string.toLowerCase(Locale.ENGLISH)) && (list = this.duplicateNameGroup.get(string.toLowerCase(Locale.ENGLISH))) != null) {
                if (list.size() <= 1) {
                    this.duplicateNameGroup.remove(string.toLowerCase(Locale.ENGLISH));
                } else {
                    if (!this.sorted.contains(string.toLowerCase(Locale.ENGLISH))) {
                        Collections.sort(list);
                        this.sorted.add(string.toLowerCase(Locale.ENGLISH));
                    }
                    return list.indexOf(string);
                }
            }
            return -1;
        }

        public String filterFullName(String string) {
            int n = this.getSortedOrder(string);
            if (n > 0) {
                string = string.endsWith("Holder") ? string.substring(0, string.length() - "Holder".length()) + "_" + n + "Holder" : string + "_" + n;
            }
            return string;
        }

        public String filterClassName(String string, String string2) {
            if (string == null || "".equals(string)) {
                return this.filterFullName(string2);
            }
            String string3 = string + "." + string2;
            string3 = this.filterFullName(string3);
            return string3.substring(string.length() + 1);
        }
    }
}

