/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public class IOUtil {
    private static final boolean verbose = Verbose.isVerbose(IOUtil.class);

    public static String toString(InputStream inputStream) throws IOException {
        int n;
        if (inputStream == null) {
            throw new IllegalArgumentException("null InputStream");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        byteArrayOutputStream.flush();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static String toString(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1) {
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    public static OutputStream createEncodedFileOutputStream(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            PrintStream printStream = string == null ? new PrintStream(fileOutputStream, true) : new PrintStream((OutputStream)fileOutputStream, true, string);
            return printStream;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw unsupportedEncodingException;
        }
    }

    public static Writer createEncodedFileWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, string);
            return outputStreamWriter;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw unsupportedEncodingException;
        }
    }
}

