/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.FilteringClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.WeakConcurrentHashMap;

public class JAXWSClassLoaderFactory {
    private static final JAXWSClassLoaderFactory theInstance = new JAXWSClassLoaderFactory();
    private static final boolean enabled;
    private static final List<String> theList;
    private Map<ClassLoader, WeakReference<GenericClassLoader>> clMap = new WeakConcurrentHashMap();

    public static JAXWSClassLoaderFactory getInstance() {
        return theInstance;
    }

    private JAXWSClassLoaderFactory() {
    }

    public void setContextLoader(ClassLoader classLoader) {
        if (enabled) {
            GenericClassLoader genericClassLoader = null;
            WeakReference<GenericClassLoader> weakReference = this.clMap.get(classLoader);
            if (weakReference != null) {
                genericClassLoader = (GenericClassLoader)weakReference.get();
            }
            if (genericClassLoader == null) {
                final ClassLoader classLoader2 = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
                FilteringClassLoader filteringClassLoader = new FilteringClassLoader(classLoader2){

                    protected Class findClass(String string) throws ClassNotFoundException {
                        if ("weblogic.webservice.core.soap.MessageFactoryImpl".equals(string)) {
                            return classLoader2.loadClass("weblogic.xml.saaj.MessageFactoryImpl");
                        }
                        return super.findClass(string);
                    }
                };
                filteringClassLoader.setFilterList(theList);
                genericClassLoader = new GenericClassLoader((ClassLoader)filteringClassLoader);
                if (classLoader instanceof GenericClassLoader) {
                    Annotation annotation = ((GenericClassLoader)classLoader).getAnnotation();
                    filteringClassLoader.setAnnotation(annotation);
                    genericClassLoader.setAnnotation(annotation);
                    this.clMap.put(classLoader, new WeakReference<GenericClassLoader>(genericClassLoader));
                }
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader);
        }
    }

    public void remove(ClassLoader classLoader) {
        this.clMap.remove(classLoader);
    }

    static {
        theList = Arrays.asList("weblogic.xml.saaj.*", "weblogic.webservice.core.soap.*");
        String string = System.getProperty("javax.xml.soap.MetaFactory");
        String string2 = System.getProperty("javax.xml.soap.MessageFactory");
        String string3 = System.getProperty("javax.xml.soap.SOAPFactory");
        String string4 = "weblogic.xml.saaj.";
        enabled = !(string != null && string.startsWith(string4) || string2 != null && string2.startsWith(string4) || string3 != null && string3.startsWith(string4));
    }
}

