/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import com.bea.util.jam.JamClassLoader;
import com.bea.util.jam.JamServiceFactory;
import com.bea.util.jam.JamServiceParams;
import com.sun.javadoc.ClassDoc;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import weblogic.utils.StringUtils;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.util.ObjectUtil;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamUtil {
    private JamUtil() {
    }

    public static boolean isObjectMethod(JMethod jMethod) {
        if (jMethod.getParent().getQualifiedName().equals(Object.class.getName())) {
            return true;
        }
        if ((jMethod.getSimpleName().equals("finalize") || jMethod.getSimpleName().equals("toString") || jMethod.getSimpleName().equals("hashCode") || jMethod.getSimpleName().equals("clone")) && (jMethod.getParameters() == null || jMethod.getParameters().length == 0)) {
            return true;
        }
        return jMethod.getSimpleName().equals("equals") && jMethod.getParameters() != null && jMethod.getParameters().length == 1 && jMethod.getParameters()[0].getType().getQualifiedName().equals(Object.class.getName());
    }

    public static String getAnnotationStringValue(JAnnotation jAnnotation, String string) {
        if (jAnnotation == null) {
            return null;
        }
        JAnnotationValue jAnnotationValue = jAnnotation.getValue(string);
        if (jAnnotationValue == null) {
            return null;
        }
        String string2 = jAnnotationValue.asString();
        return StringUtils.isEmptyString((String)string2) ? null : string2;
    }

    public static boolean getAnnotationBooleanValue(JAnnotation jAnnotation, String string, boolean bl) {
        JAnnotationValue jAnnotationValue = jAnnotation.getValue(string);
        if (jAnnotationValue == null) {
            return bl;
        }
        return jAnnotationValue.asBoolean();
    }

    public static <T extends Enum<T>> T getAnnotationEnumValue(JAnnotation jAnnotation, String string, Class<T> clazz, T t) {
        String string2 = JamUtil.getAnnotationStringValue(jAnnotation, string);
        if (StringUtil.isEmpty(string2)) {
            return t;
        }
        return Enum.valueOf(clazz, string2);
    }

    public static JClass parseSource(File file, String string, String string2) throws WsBuildException {
        return JamUtil.parseSource(file, string, string2, null);
    }

    public static JClass[] parseSource(File[] fileArray, String string, String string2) throws WsBuildException {
        return JamUtil.parseSource(fileArray, string, string2, null);
    }

    public static JClass parseSource(File file, String string, String string2, String string3) throws WsBuildException {
        JClass[] jClassArray = JamUtil.parseSource(new File[]{file}, string, string2, string3);
        if (jClassArray == null || jClassArray.length == 0) {
            throw new WsBuildException("Unable load source file using jam: " + file);
        }
        if (jClassArray.length > 1) {
            throw new WsBuildException("Too many source files." + jClassArray.length);
        }
        return jClassArray[0];
    }

    public static JClass[] parseSource(File[] fileArray, String string, String string2, String string3) throws WsBuildException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            JClass[] jClassArray;
            JamServiceFactory jamServiceFactory = JamServiceFactory.getInstance();
            JamServiceParams jamServiceParams = jamServiceFactory.createServiceParams();
            Object object = fileArray;
            int n = ((File[])object).length;
            for (int i = 0; i < n; ++i) {
                File file = object[i];
                jamServiceParams.includeSourceFile(file);
            }
            jamServiceParams.setProperty("javadoc.args", "-source 1.5");
            if (string3 != null) {
                jamServiceParams.setCharacterEncoding(string3);
            }
            if (string != null) {
                object = new StringTokenizer(string, File.pathSeparator);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    jamServiceParams.addSourcepath(new File(((StringTokenizer)object).nextToken()));
                }
            }
            if (string2 != null) {
                object = new StringTokenizer(string2, File.pathSeparator);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    jamServiceParams.addClasspath(new File(((StringTokenizer)object).nextToken()));
                }
            }
            if ((jClassArray = (object = jamServiceFactory.createService(jamServiceParams)).getAllClasses()).length != fileArray.length) {
                throw new WsBuildException("Wrong number of class files.  Expected " + fileArray.length + ", got " + jClassArray.length);
            }
            JClass[] jClassArray2 = jClassArray;
            return jClassArray2;
        }
        catch (IOException iOException) {
            throw new WsBuildException("Unable to load source files");
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static JMethod getOverrideMethod(JClass jClass, JMethod jMethod) {
        JMethod[] jMethodArray;
        if (jMethod.getContainingClass() == jClass) {
            return jMethod;
        }
        for (JMethod jMethod2 : jMethodArray = jClass.getMethods()) {
            JParameter[] jParameterArray;
            JParameter[] jParameterArray2;
            if (!jMethod2.getSimpleName().equals(jMethod.getSimpleName()) || (!jMethod.getReturnType().isVoidType() || !jMethod2.getReturnType().isVoidType()) && !jMethod.getReturnType().isAssignableFrom(jMethod2.getReturnType()) || (jParameterArray2 = jMethod2.getParameters()).length != (jParameterArray = jMethod.getParameters()).length) continue;
            boolean bl = true;
            for (int i = 0; bl && i < jParameterArray2.length; ++i) {
                bl = jParameterArray[i].getType().isAssignableFrom(jParameterArray2[i].getType());
            }
            if (!bl) continue;
            JClass[] jClassArray = jMethod2.getExceptionTypes();
            JClass[] jClassArray2 = jMethod.getExceptionTypes();
            for (int i = 0; bl && i < jClassArray.length; ++i) {
                boolean bl2 = false;
                for (int j = 0; !bl2 && j < jClassArray2.length; ++j) {
                    bl2 = jClassArray2[j].isAssignableFrom(jClassArray[i]);
                }
                bl = bl2;
            }
            if (!bl) continue;
            return jMethod2;
        }
        return null;
    }

    public static JClass loadJClass(String string, ClassLoader classLoader) {
        JamServiceFactory jamServiceFactory = JamServiceFactory.getInstance();
        JamClassLoader jamClassLoader = jamServiceFactory.createJamClassLoader(classLoader);
        return JamUtil.loadJClass(string, jamClassLoader, false);
    }

    public static JClass loadJClass(String string, JamClassLoader jamClassLoader, boolean bl) {
        JClass jClass = jamClassLoader.loadClass(string);
        if (bl && jClass.getContainingClass() == null) {
            jClass = JamUtil.loadInnerJClass(jamClassLoader, jClass);
        }
        return jClass;
    }

    private static JClass loadInnerJClass(JamClassLoader jamClassLoader, JClass jClass) {
        String string;
        int n;
        JClass jClass2 = jClass;
        if (JamUtil.isInnerClass(jClass) && (n = (string = jClass2.getQualifiedName()).lastIndexOf(46)) != -1) {
            string = string.substring(0, n) + "$" + string.substring(n + 1);
            jClass2 = jamClassLoader.loadClass(string);
        }
        return jClass2;
    }

    private static boolean isInnerClass(JClass jClass) {
        Object object = jClass.getArtifact();
        if (object instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)object;
            return classDoc.containingClass() != null;
        }
        return false;
    }

    public static boolean isSoapEncJavaPrimitiveWrapperClass(JClass jClass) {
        return JamUtil.soapEncodedTypeForJavaPrimitiveWrapper(jClass) != null;
    }

    public static String soapEncodedTypeForJavaPrimitiveWrapper(JClass jClass) {
        if (jClass == null) {
            return null;
        }
        String string = jClass.getQualifiedName();
        if (string.equals("java.lang.Integer")) {
            return "int";
        }
        if (string.equals("java.lang.Float")) {
            return "float";
        }
        if (string.equals("java.lang.Long")) {
            return "long";
        }
        if (string.equals("java.lang.Double")) {
            return "double";
        }
        if (string.equals("java.lang.Byte")) {
            return "byte";
        }
        if (string.equals("java.lang.Short")) {
            return "short";
        }
        if (string.equals("java.lang.Boolean")) {
            return "boolean";
        }
        return null;
    }

    public static boolean isFinalizeMethod(JMethod jMethod) {
        return "finalize".equals(jMethod.getSimpleName()) && (jMethod.getParameters() == null || jMethod.getParameters().length == 0);
    }

    public static boolean equals(JAnnotation jAnnotation, JAnnotation jAnnotation2) {
        Map<String, JAnnotationValue> map = JamUtil.buildMap(jAnnotation.getValues());
        Map<String, JAnnotationValue> map2 = JamUtil.buildMap(jAnnotation2.getValues());
        if (!((Object)map.keySet()).equals(map2.keySet())) {
            return false;
        }
        for (String string : map.keySet()) {
            JAnnotationValue jAnnotationValue = map.get(string);
            JAnnotationValue jAnnotationValue2 = map2.get(string);
            if (ObjectUtil.equals(jAnnotationValue.asString(), jAnnotationValue2.asString())) continue;
            return false;
        }
        return true;
    }

    private static Map<String, JAnnotationValue> buildMap(JAnnotationValue[] jAnnotationValueArray) {
        HashMap<String, JAnnotationValue> hashMap = new HashMap<String, JAnnotationValue>(jAnnotationValueArray.length);
        for (JAnnotationValue jAnnotationValue : jAnnotationValueArray) {
            hashMap.put(jAnnotationValue.getName(), jAnnotationValue);
        }
        return hashMap;
    }
}

