/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import weblogic.j2ee.descriptor.wl.DeliveryFailureParamsBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.util.StringUtil;

public final class JmsUtil {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String URI = "URI";
    public static final String WSEE_JMS_SUBJECT = "WSEE_JMS_SUBJECT";
    public static final String JMS_TEXTMESSAGE = "TextMessage";
    public static final String JMS_BYTESMESSAGE = "BytesMessage";
    public static final String ISWLW81MESSAGE = "IsWLW81Message";

    public static String getNonJmsTransportSelector(String string) {
        String string2 = new String(string);
        if (string.indexOf("/") == 0) {
            string2 = string.substring(1);
        }
        return "(URI = '" + string2 + "' OR " + URI + " = '/" + string2 + "')";
    }

    public static String getJmsTransportSelector(String string) {
        String string2 = new String(string);
        if (string.indexOf("/") == 0) {
            string2 = string.substring(1);
        }
        return "(URI = '" + string2 + "' OR " + URI + " = '/" + string2 + "')";
    }

    public static String getWLW81Selector(String string) {
        String string2 = new String(string);
        if (string.indexOf("/") == 0) {
            string2 = string.substring(1);
        }
        return "URI = '" + string2 + ".jws'" + " OR " + URI + " = '/" + string2 + ".jws'";
    }

    public static void setJmsTransportTextMessage(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        stub._setProperty("weblogic.wsee.transport.jms.messagetype", (Object)JMS_TEXTMESSAGE);
    }

    public static void setJmsTransportBytesMessage(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        stub._setProperty("weblogic.wsee.transport.jms.messagetype", (Object)JMS_BYTESMESSAGE);
    }

    public static String getErrorDestinationJNDI(String string) {
        Object object;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (domainMBean == null) {
            throw new InvocationException("Cannot find DomainMBean");
        }
        DestinationImpl destinationImpl = null;
        try {
            object = new InitialContext();
            destinationImpl = (DestinationImpl)object.lookup(string);
        }
        catch (NamingException namingException) {
            throw new InvocationException("Error looking up queue at " + string, namingException);
        }
        if (destinationImpl == null) {
            throw new InvocationException("Cannot find DestinationImpl for " + string);
        }
        object = destinationImpl.getQueueName();
        if (object == null) {
            throw new InvocationException("Queue name is not set for " + string);
        }
        int n = ((String)object).indexOf(33);
        String string2 = null;
        Object object2 = null;
        if (n == 0 || n == ((String)object).length() - 1) {
            throw new InvocationException("Incorrect format for the queue name " + (String)object);
        }
        if (n < 0) {
            string2 = "interop-jms";
            object2 = object;
        } else {
            string2 = ((String)object).substring(0, n);
            object2 = ((String)object).substring(n + 1, ((String)object).length());
        }
        JMSSystemResourceMBean jMSSystemResourceMBean = domainMBean.lookupJMSInteropModule(string2);
        if (jMSSystemResourceMBean == null && (jMSSystemResourceMBean = domainMBean.lookupJMSSystemResource(string2)) == null) {
            throw new InvocationException("Could not find JMSSystemResource " + string2 + " in the domain " + domainMBean.getName());
        }
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        if (jMSBean == null) {
            throw new InvocationException("Could not find JMSBean for " + string2 + " in the domain " + domainMBean.getName());
        }
        DestinationBean destinationBean = JMSModuleHelper.findDestinationBean((String)object2, jMSBean);
        if (destinationBean == null) {
            throw new InvocationException("Could not find DestinationBean " + (String)object2 + " in the domain " + domainMBean.getName());
        }
        DeliveryFailureParamsBean deliveryFailureParamsBean = destinationBean.getDeliveryFailureParams();
        if (deliveryFailureParamsBean == null) {
            throw new InvocationException("Could not find DeliveryFailureParamsBean for " + (String)object2 + " in the domain " + domainMBean.getName());
        }
        DestinationBean destinationBean2 = deliveryFailureParamsBean.getErrorDestination();
        if (destinationBean2 == null) {
            return null;
        }
        return destinationBean2.getJNDIName();
    }

    public static Map asMap(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            String string4 = null;
            int n = string2.indexOf("=");
            if (n != -1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            }
            if (string3 != null && string4 != null) {
                hashMap.put(string3, string4);
            }
            string3 = null;
            string4 = null;
        }
        return hashMap;
    }

    public static String wlw81UriToWls9(String string) {
        return null;
    }

    public static String wls9UriToWlw81(String string) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getHost();
            int n = uRI.getPort();
            String string3 = uRI.getPath();
            if (string3 == null) {
                throw new JAXRPCException("Wrong WLS9 JMS URI format: no path specified");
            }
            String string4 = uRI.getQuery();
            if (string4 == null) {
                throw new JAXRPCException("Wrong WLS9 JMS URI format: no query specified");
            }
            Map map = JmsUtil.asMap(string4);
            String string5 = (String)map.get(URI);
            if (StringUtil.isEmpty(string5)) {
                throw new JAXRPCException("Wrong WLS9 JMS URI format: no URI specified");
            }
            String string6 = (String)map.get("FACTORY");
            if (StringUtil.isEmpty(string6)) {
                string6 = "weblogic.jms.ConnectionFactory";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(uRI.getScheme());
            stringBuffer.append("://");
            stringBuffer.append(string2);
            if (n != -1) {
                stringBuffer.append(":" + n);
            }
            stringBuffer.append("/" + string6);
            stringBuffer.append("/" + string5);
            stringBuffer.append("?URI=" + string3);
            return stringBuffer.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new JAXRPCException((Throwable)uRISyntaxException);
        }
    }

    public static boolean isWlw81JmsUri(String string) {
        if (string == null) {
            return false;
        }
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getScheme();
            if (!"jms".equals(string2)) {
                return false;
            }
            String string3 = uRI.getQuery();
            if (string3 == null) {
                return false;
            }
            Map map = JmsUtil.asMap(string3);
            String string4 = (String)map.get(URI);
            if (StringUtil.isEmpty(string4)) {
                return false;
            }
            return JmsUtil.isWlw81JmsUriProperty(string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static boolean isWlw81JmsUriProperty(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("/");
    }
}

