/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import weblogic.management.WebLogicMBean;
import weblogic.management.jmx.modelmbean.WLSModelMBean;
import weblogic.management.provider.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanProxyFactory {
    private PrintWriter _logWriter;
    private JMXConnector _jmxConnector;
    private MBeanServerConnection _conn;
    private LoginInfo _loginInfo;
    private boolean _isLogEnabled = false;

    public MBeanProxyFactory(MBeanServerConnection mBeanServerConnection, PrintWriter printWriter) throws Exception {
        this._logWriter = printWriter;
        this._conn = mBeanServerConnection;
        this._isLogEnabled = this.isLogEnabled();
    }

    public MBeanProxyFactory(LoginInfo loginInfo, PrintWriter printWriter) throws Exception {
        this._loginInfo = loginInfo;
        this._logWriter = printWriter;
        this._conn = this.getMBeanServerConnection();
        this._isLogEnabled = this.isLogEnabled();
    }

    public <T> T createProxy(ClassLoader classLoader, Class<T> clazz, ObjectName objectName) throws ReflectionException, InstanceNotFoundException, IOException, IntrospectionException, javax.management.IntrospectionException {
        MyInvocationHandler<Object> myInvocationHandler = new MyInvocationHandler<Object>(clazz, objectName);
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, myInvocationHandler);
        myInvocationHandler.setProxy(object);
        return (T)object;
    }

    public MBeanServerConnection getMBeanServerConnection() throws Exception {
        try {
            this.dumpEffectiveConnectionProps();
            JMXConnector jMXConnector = this.getJMXConnector();
            this.dumpEffectiveConnectionProps();
            return jMXConnector.getMBeanServerConnection();
        }
        catch (Exception exception) {
            throw new Exception(exception.toString(), exception);
        }
    }

    private void dumpEffectiveConnectionProps() {
        if (this._isLogEnabled) {
            this.log("--- Effective prop values: ---");
            this.log(this._loginInfo.toString());
            this.log("--- End --");
        }
    }

    private JMXConnector getJMXConnector() throws Exception {
        if (this._jmxConnector != null) {
            return this._jmxConnector;
        }
        String string = "/jndi/" + this._loginInfo.jmxJndiName;
        JMXServiceURL jMXServiceURL = new JMXServiceURL("t3", this._loginInfo.adminHost, this._loginInfo.adminPort, string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this._loginInfo.userName != null && this._loginInfo.password != null) {
            hashMap.put("java.naming.security.principal", this._loginInfo.userName);
            hashMap.put("java.naming.security.credentials", this._loginInfo.password);
            String[] stringArray = new String[]{this._loginInfo.userName, this._loginInfo.password};
            hashMap.put("jmx.remote.credentials", stringArray);
        }
        hashMap.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        this._jmxConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
        return this._jmxConnector;
    }

    public void dispose() throws IOException {
        if (this._jmxConnector != null) {
            this._jmxConnector.close();
        }
    }

    private Object invokeOperation(MBeanServerConnection mBeanServerConnection, ObjectName objectName, MyInvocationHandler.Info info, Object[] objectArray) throws ReflectionException, IOException, InstanceNotFoundException, MBeanException {
        MBeanOperationInfo mBeanOperationInfo = info.opInfo;
        if (this._isLogEnabled) {
            this.log("Invoking " + mBeanOperationInfo.getName());
        }
        if (objectArray == null) {
            objectArray = new Class[]{};
        }
        if (info.argTypes.length != objectArray.length) {
            throw new IllegalArgumentException("Wrong number of args. Expected " + info.argTypes.length + " but got " + objectArray.length);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!MBeanProxyFactory.isMBeanType(info.argTypes[i])) continue;
            objectArray[i] = MBeanProxyFactory.getMBeanObjectName(objectArray[i]);
        }
        long l = System.currentTimeMillis();
        String[] stringArray = new String[mBeanOperationInfo.getSignature().length];
        for (int i = 0; i < mBeanOperationInfo.getSignature().length; ++i) {
            stringArray[i] = mBeanOperationInfo.getSignature()[i].getType();
        }
        Object object = mBeanServerConnection.invoke(objectName, mBeanOperationInfo.getName(), objectArray, stringArray);
        long l2 = System.currentTimeMillis() - l;
        if (this._isLogEnabled) {
            this.log("Done. Operation took " + (float)l2 / 1000.0f + " seconds");
        }
        return object;
    }

    private void setAttribute(MBeanServerConnection mBeanServerConnection, ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo, Object[] objectArray) throws ReflectionException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, InvalidAttributeValueException {
        if (this._isLogEnabled) {
            this.log("Setting attr " + mBeanAttributeInfo.getName());
        }
        long l = System.currentTimeMillis();
        Attribute attribute = new Attribute(mBeanAttributeInfo.getName(), objectArray[0]);
        mBeanServerConnection.setAttribute(objectName, attribute);
        long l2 = System.currentTimeMillis() - l;
        if (this._isLogEnabled) {
            this.log("Done. Set attr took " + (float)l2 / 1000.0f + " seconds");
        }
    }

    private Object getAttribute(MBeanServerConnection mBeanServerConnection, ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo) throws ReflectionException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException {
        if (this._isLogEnabled) {
            this.log("Getting attr " + mBeanAttributeInfo.getName());
        }
        long l = System.currentTimeMillis();
        Object object = mBeanServerConnection.getAttribute(objectName, mBeanAttributeInfo.getName());
        long l2 = System.currentTimeMillis() - l;
        if (this._isLogEnabled) {
            this.log("Done. Get attr took " + (float)l2 / 1000.0f + " seconds");
        }
        return object;
    }

    private void log(String string) {
        if (this._logWriter != null) {
            this._logWriter.println(string);
        }
    }

    private boolean isLogEnabled() {
        return this._logWriter != null;
    }

    private static boolean isMBeanType(Class clazz) {
        return WebLogicMBean.class.isAssignableFrom(clazz) || WLSModelMBean.class.isAssignableFrom(clazz) || Service.class.isAssignableFrom(clazz);
    }

    private static ObjectName getMBeanObjectName(Object object) {
        Object object2;
        if (Proxy.isProxyClass(object.getClass()) && MyInvocationHandler.class.isAssignableFrom((object2 = Proxy.getInvocationHandler(object)).getClass())) {
            MyInvocationHandler myInvocationHandler = (MyInvocationHandler)object2;
            return myInvocationHandler._objectName;
        }
        try {
            if (WebLogicMBean.class.isAssignableFrom(object.getClass())) {
                object2 = ((WebLogicMBean)object).getObjectName();
                return object2;
            }
            if (WLSModelMBean.class.isAssignableFrom(object.getClass())) {
                object2 = ((WLSModelMBean)object).getObjectName();
                return object2;
            }
            throw new IllegalArgumentException("Attempt to extract an ObjectName from non-MBean object: " + object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public static class LoginInfo
    implements Cloneable {
        public String adminHost;
        public int adminPort;
        public String userName;
        public String password;
        public String jmxJndiName;

        public LoginInfo() {
            this(Type.DOMAIN_RUNTIME);
        }

        public LoginInfo(Type type) {
            switch (type) {
                case CONFIG: {
                    this.jmxJndiName = "weblogic.management.mbeanservers.edit";
                    break;
                }
                case RUNTIME: {
                    this.jmxJndiName = "weblogic.management.mbeanservers.runtime";
                    break;
                }
                default: {
                    this.jmxJndiName = "weblogic.management.mbeanservers.domainruntime";
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Admin Server Host:     ").append(this.adminHost).append("\n");
            stringBuffer.append("Admin Server Port:     ").append(this.adminPort).append("\n");
            stringBuffer.append("Admin User Name:       ").append(this.userName).append("\n");
            stringBuffer.append("JMX JNDI Name:         ").append(this.jmxJndiName).append("\n");
            return stringBuffer.toString();
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            DOMAIN_RUNTIME,
            RUNTIME,
            CONFIG;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyInvocationHandler<T>
    implements InvocationHandler {
        private Class _intfClass;
        private ObjectName _objectName;
        private Map<Method, Info> _methodToInfoMap;
        private T _proxy;

        /*
         * WARNING - void declaration
         */
        public MyInvocationHandler(Class clazz, ObjectName objectName) throws ReflectionException, IOException, InstanceNotFoundException, javax.management.IntrospectionException, IntrospectionException {
            Class<?>[] classArray;
            Object object;
            Object object2;
            String string;
            void object3;
            this._intfClass = clazz;
            this._objectName = objectName;
            if (MBeanProxyFactory.this._isLogEnabled) {
                MBeanProxyFactory.this.log("Looking for " + this._intfClass.getName() + " named: " + this._objectName);
            }
            MBeanInfo mBeanInfo = MBeanProxyFactory.this._conn.getMBeanInfo(this._objectName);
            if (MBeanProxyFactory.this._isLogEnabled) {
                MBeanProxyFactory.this.log("MBeanInfo for: " + this._objectName);
            }
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            HashMap<String, MBeanAttributeInfo> hashMap = new HashMap<String, MBeanAttributeInfo>();
            if (MBeanProxyFactory.this._isLogEnabled) {
                MBeanProxyFactory.this.log("Attributes:");
            }
            MBeanFeatureInfo[] mBeanFeatureInfoArray = mBeanAttributeInfoArray;
            int n = mBeanFeatureInfoArray.length;
            boolean bl = false;
            while (object3 < n) {
                MBeanAttributeInfo map = mBeanFeatureInfoArray[object3];
                if (MBeanProxyFactory.this._isLogEnabled) {
                    MBeanProxyFactory.this.log("    Attribute: " + map.getName() + " type: " + map.getType());
                }
                hashMap.put(map.getName(), map);
                ++object3;
            }
            mBeanFeatureInfoArray = mBeanInfo.getOperations();
            HashMap<String, MBeanFeatureInfo> hashMap2 = new HashMap<String, MBeanFeatureInfo>();
            if (MBeanProxyFactory.this._isLogEnabled) {
                MBeanProxyFactory.this.log("Operations:");
            }
            for (MBeanFeatureInfo mBeanFeatureInfo : mBeanFeatureInfoArray) {
                if (MBeanProxyFactory.this._isLogEnabled) {
                    MBeanProxyFactory.this.log("    Operation: " + mBeanFeatureInfo.getName() + " return type: " + ((MBeanOperationInfo)mBeanFeatureInfo).getReturnType());
                }
                hashMap2.put(mBeanFeatureInfo.getName(), mBeanFeatureInfo);
            }
            Maps maps = this.getMapsFromBeanClass(this._intfClass);
            Map<String, PropertyDescriptor> map = maps.propDescMap;
            Map<String, MethodDescriptor> map2 = maps.methodDescMap;
            this._methodToInfoMap = new HashMap<Method, Info>();
            for (MBeanFeatureInfo mBeanFeatureInfo : hashMap.values()) {
                string = mBeanFeatureInfo.getName();
                object2 = Introspector.decapitalize(mBeanFeatureInfo.getName());
                object = map.get(object2);
                if (object == null) {
                    object = map.get(string);
                }
                if (object == null) {
                    throw new IllegalArgumentException("Didn't find a JavaBean property (" + string + " or " + (String)object2 + ") for MBean attribute " + mBeanFeatureInfo.getName() + " on interface: " + this._intfClass.getName());
                }
                if (((PropertyDescriptor)object).getWriteMethod() != null) {
                    classArray = new Info();
                    classArray.type = Type.ATTR;
                    classArray.javaType = ((PropertyDescriptor)object).getPropertyType();
                    classArray.argTypes = new Class[0];
                    classArray.direction = Direction.SET;
                    classArray.attrInfo = mBeanFeatureInfo;
                    classArray.name = mBeanFeatureInfo.getName();
                    this._methodToInfoMap.put(((PropertyDescriptor)object).getWriteMethod(), (Info)classArray);
                }
                classArray = new Info();
                classArray.type = Type.ATTR;
                classArray.javaType = ((PropertyDescriptor)object).getPropertyType();
                classArray.argTypes = new Class[0];
                classArray.direction = Direction.GET;
                classArray.attrInfo = mBeanFeatureInfo;
                classArray.name = mBeanFeatureInfo.getName();
                if (((PropertyDescriptor)object).getReadMethod() == null) continue;
                this._methodToInfoMap.put(((PropertyDescriptor)object).getReadMethod(), (Info)classArray);
            }
            for (MBeanFeatureInfo mBeanFeatureInfo : hashMap2.values()) {
                string = mBeanFeatureInfo.getName();
                object2 = map2.get(string);
                if (object2 == null) {
                    throw new IllegalArgumentException("Didn't find an JavaBean method " + string + " for MBean operation " + mBeanFeatureInfo.getName() + " in interface: " + this._intfClass);
                }
                object = new Info();
                ((Info)object).type = Type.OP;
                ((Info)object).javaType = ((MethodDescriptor)object2).getMethod().getReturnType();
                classArray = ((MethodDescriptor)object2).getMethod().getParameterTypes();
                ((Info)object).argTypes = classArray.length > 0 ? classArray : new Class[0];
                ((Info)object).opInfo = mBeanFeatureInfo;
                ((Info)object).name = mBeanFeatureInfo.getName();
                this._methodToInfoMap.put(((MethodDescriptor)object2).getMethod(), (Info)object);
            }
        }

        public void setProxy(T t) {
            this._proxy = t;
        }

        private Maps getMapsFromBeanClass(Class clazz) throws IntrospectionException {
            Stack<Class> stack = this.findInterfaces(clazz);
            Maps maps = new Maps();
            while (!stack.isEmpty()) {
                Class clazz2 = stack.pop();
                this.updateMapsFromBeanClass(clazz2, maps);
            }
            return maps;
        }

        private Stack<Class> findInterfaces(Class clazz) {
            HashSet<Class> hashSet = new HashSet<Class>();
            Stack<Class> stack = new Stack<Class>();
            this.findInterfaces(clazz, hashSet, stack);
            return stack;
        }

        private void findInterfaces(Class clazz, Set<Class> set, Stack<Class> stack) {
            Class<?>[] classArray;
            if (set.contains(clazz)) {
                return;
            }
            set.add(clazz);
            stack.push(clazz);
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                this.findInterfaces(clazz2, set, stack);
            }
        }

        private void updateMapsFromBeanClass(Class clazz, Maps maps) throws IntrospectionException {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            FeatureDescriptor[] featureDescriptorArray = propertyDescriptorArray;
            int n = featureDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                PropertyDescriptor propertyDescriptor = featureDescriptorArray[i];
                maps.propDescMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            for (FeatureDescriptor featureDescriptor : featureDescriptorArray = beanInfo.getMethodDescriptors()) {
                maps.methodDescMap.put(featureDescriptor.getName(), (MethodDescriptor)featureDescriptor);
            }
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Class<?> clazz;
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, objectArray);
            }
            Info info = this._methodToInfoMap.get(method);
            if (info == null) {
                throw new IllegalArgumentException("Don't know how to handle method " + method.getName() + " on interface: " + this._intfClass.getName());
            }
            Object object2 = null;
            if (info.type == Type.ATTR) {
                if (info.direction == Direction.SET) {
                    MBeanProxyFactory.this.setAttribute(MBeanProxyFactory.this._conn, this._objectName, info.attrInfo, objectArray);
                } else {
                    object2 = MBeanProxyFactory.this.getAttribute(MBeanProxyFactory.this._conn, this._objectName, info.attrInfo);
                }
            } else {
                object2 = MBeanProxyFactory.this.invokeOperation(MBeanProxyFactory.this._conn, this._objectName, info, objectArray);
            }
            if (object2 == null) {
                return object2;
            }
            if (MBeanProxyFactory.isMBeanType(info.javaType)) {
                Class clazz2 = this.getJavaTypeFromObjectName((ObjectName)object2, info.javaType);
                object2 = MBeanProxyFactory.this.createProxy(this.getClass().getClassLoader(), clazz2, (ObjectName)object2);
            } else if (info.javaType.isArray() && MBeanProxyFactory.isMBeanType(clazz = info.javaType.getComponentType())) {
                ObjectName[] objectNameArray = (ObjectName[])object2;
                object2 = Array.newInstance(clazz, objectNameArray.length);
                int n = 0;
                for (ObjectName objectName : objectNameArray) {
                    Class clazz3 = this.getJavaTypeFromObjectName(objectName, clazz);
                    Object t = MBeanProxyFactory.this.createProxy(this.getClass().getClassLoader(), clazz3, objectName);
                    Array.set(object2, n, t);
                    ++n;
                }
            }
            return object2;
        }

        private Class getJavaTypeFromObjectName(ObjectName objectName, Class clazz) {
            String string = objectName.getKeyProperty("Type");
            if (string != null) {
                if (string.startsWith("[")) {
                    return clazz;
                }
                String string2 = "";
                if (!string.startsWith("weblogic.")) {
                    string2 = string.endsWith("Runtime") ? "weblogic.management.runtime." : "weblogic.management.configuration.";
                }
                String string3 = string2 + string + "MBean";
                if (MBeanProxyFactory.this.isLogEnabled()) {
                    MBeanProxyFactory.this.log("Attempting to load specific MBean subclass of " + clazz.getName() + " with class: " + string3);
                }
                try {
                    Class<?> clazz2 = this.getClass().getClassLoader().loadClass(string3);
                    if (clazz.isAssignableFrom(clazz2)) {
                        if (MBeanProxyFactory.this.isLogEnabled()) {
                            MBeanProxyFactory.this.log("Using specific MBean subclass of " + clazz.getName() + " with class: " + string3);
                        }
                        clazz = clazz2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return clazz;
        }

        public int hashCode() {
            return this._objectName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MyInvocationHandler)) {
                return false;
            }
            MyInvocationHandler myInvocationHandler = (MyInvocationHandler)object;
            return myInvocationHandler._objectName.equals(this._objectName);
        }

        public String toString() {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            this.indent(n, stringBuffer).append("Object Name: ").append(this._objectName).append("\n");
            n = 1;
            for (Method method : this._methodToInfoMap.keySet()) {
                Info info = this._methodToInfoMap.get(method);
                if (info.direction == Direction.SET || info.name.equalsIgnoreCase("parent") && method.getDeclaringClass() == WebLogicMBean.class) continue;
                try {
                    Object object = null;
                    try {
                        object = method.invoke(this._proxy, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object != null && object.getClass().isArray()) {
                        this.indent(n, stringBuffer).append(info.name).append(": ").append(object.getClass()).append("\n");
                        ++n;
                        Object[] objectArray = (Object[])object;
                        int n2 = 0;
                        for (Object object2 : objectArray) {
                            this.indent(n, stringBuffer).append("[").append(n2).append("]:").append("\n");
                            String string = object2.toString();
                            string = this.indentString(++n, string);
                            stringBuffer.append(string).append("\n");
                            --n;
                            ++n2;
                        }
                        --n;
                        continue;
                    }
                    this.indent(n, stringBuffer).append(info.name).append(": ").append(object).append("\n");
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString(), exception);
                }
            }
            return stringBuffer.toString();
        }

        private String indentString(int n, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.indent(n, stringBuffer).append(string2).append("\n");
            }
            return stringBuffer.toString();
        }

        private StringBuffer indent(int n, StringBuffer stringBuffer) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("    ");
            }
            return stringBuffer;
        }

        class Maps {
            public Map<String, PropertyDescriptor> propDescMap = new HashMap<String, PropertyDescriptor>();
            public Map<String, MethodDescriptor> methodDescMap = new HashMap<String, MethodDescriptor>();

            Maps() {
            }
        }

        class Info {
            Type type;
            Class javaType;
            Class[] argTypes;
            Direction direction;
            String name;
            MBeanAttributeInfo attrInfo;
            MBeanOperationInfo opInfo;

            Info() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Direction {
        SET,
        GET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        ATTR,
        OP;

    }
}

