/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.IOException;
import java.security.AccessController;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class MBeanUtil {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static ServerMBean getLocalServerMBean() {
        return ManagementService.getRuntimeAccess(kernelId).getServer();
    }

    public static SSLMBean getLocalSSLMBean() {
        return MBeanUtil.getLocalServerMBean().getSSL();
    }

    public static ObjectName[] getServerRuntimeNames(MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        ObjectName objectName = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
        return (ObjectName[])mBeanServerConnection.getAttribute(objectName, "ServerRuntimes");
    }

    public static ObjectName getServerRuntimeName(String string, MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        ObjectName[] objectNameArray;
        for (ObjectName objectName : objectNameArray = MBeanUtil.getServerRuntimeNames(mBeanServerConnection)) {
            if (!objectName.getKeyProperty("Name").equals(string)) continue;
            return objectName;
        }
        return null;
    }
}

