/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import weblogic.utils.encoders.BASE64Encoder;

public class MimeHeadersUtil {
    public static final String AUTH_HEADER = "Authorization";
    public static final String PROXY_AUTH_HEADER = "Proxy-Authorization";
    public static final String BASIC_REALM = "Basic";
    public static final String PROXY_SET = "proxySet";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";

    public static String getEncodedAuthToken(Object object, Object object2) {
        byte[] byArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
        byte[] byArray2 = object2 instanceof String ? ((String)object2).getBytes() : (byte[])object2;
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = 58;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encodeBuffer(byArray3);
    }

    public static String getBasicAuthHeaderValue(Object object, Object object2) {
        String string = null;
        if (object == null || object2 == null) {
            object = MimeHeadersUtil.getSysProp("javax.xml.rpc.security.auth.username");
            object2 = MimeHeadersUtil.getSysProp("javax.xml.rpc.security.auth.password");
        }
        if (object != null && object2 != null) {
            string = "Basic " + MimeHeadersUtil.getEncodedAuthToken(object, object2);
        }
        return string;
    }

    public static String getBasicProxyAuthHeaderValue(Object object, Object object2) {
        String string = null;
        if ((object == null || object2 == null) && Boolean.getBoolean(PROXY_SET)) {
            object = MimeHeadersUtil.getSysProp("weblogic.webservice.client.proxyusername");
            object2 = MimeHeadersUtil.getSysProp("weblogic.webservice.client.proxypassword");
        }
        if (object != null && object2 != null) {
            string = "Basic " + MimeHeadersUtil.getEncodedAuthToken(object, object2);
        }
        return string;
    }

    public static Proxy getProxyFromSysProps() {
        Proxy proxy = null;
        boolean bl = Boolean.getBoolean(PROXY_SET);
        if (bl) {
            String string = System.getProperty(PROXY_HOST);
            String string2 = System.getProperty(PROXY_PORT);
            if (string != null && string2 != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, Integer.parseInt(string2)));
            }
        }
        return proxy;
    }

    private static String getSysProp(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }
}

