/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import com.bea.xbean.util.Base64;
import com.bea.xml.XmlException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public abstract class MtomUtil {
    public static final String MIME_TRANSFER_ENC_HEADER = "Content-Transfer-Encoding";
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final QName XOP_INCLUDE_QNAME = new QName("http://www.w3.org/2004/08/xop/include", "Include");

    public static String getMTOMcid(QName qName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(qName.getLocalPart());
        stringBuffer.append("=");
        stringBuffer.append(UUID.randomUUID());
        stringBuffer.append("@");
        stringBuffer.append(qName.getNamespaceURI());
        return stringBuffer.toString();
    }

    public static void writeHref(SOAPMessage sOAPMessage, SOAPElement sOAPElement, String string) throws XmlException {
        try {
            Name name = sOAPMessage.getSOAPPart().getEnvelope().createName("href");
            sOAPElement.addAttribute(name, "cid:" + string);
        }
        catch (SOAPException sOAPException) {
            throw new XmlException("Failed to add href attribute", (Throwable)sOAPException);
        }
    }

    public static boolean isValidNode(Node node, Node node2) {
        assert (node2 != null);
        assert (node != null);
        if (node2 != null && node2 != node) {
            for (Node node3 = node2.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
                if (node3 != node) continue;
                return true;
            }
        }
        return false;
    }

    public static SOAPElement getCipherValueFromEncryptedData(SOAPElement sOAPElement) throws XmlException {
        assert (sOAPElement != null);
        SOAPElement sOAPElement2 = null;
        try {
            Element element = DOMUtils.getElementByTagNameNS((Element)sOAPElement, "http://www.w3.org/2001/04/xmlenc#", "CipherData");
            if (element == null) {
                throw new XmlException("Failed to retrieve CiphereData element");
            }
            sOAPElement2 = (SOAPElement)DOMUtils.getElementByTagNameNS(element, "http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new XmlException("Failed to retrieve CipherValue element", (Throwable)((Object)dOMProcessingException));
        }
        return sOAPElement2;
    }

    public static void addMtomAttachment(SOAPMessage sOAPMessage, byte[] byArray, String string) throws XmlException {
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart((Object)byArray, DEFAULT_MIME_TYPE);
        String string2 = '<' + string + '>';
        attachmentPart.setContentId(string2);
        attachmentPart.addMimeHeader(MIME_TRANSFER_ENC_HEADER, "binary");
        try {
            attachmentPart.setRawContent((InputStream)new ByteArrayInputStream(byArray), DEFAULT_MIME_TYPE);
        }
        catch (SOAPException sOAPException) {
            throw new XmlException(sOAPException.getMessage());
        }
        sOAPMessage.addAttachmentPart(attachmentPart);
    }

    public static void replaceContentWithIncludeElement(SOAPMessage sOAPMessage, SOAPElement sOAPElement) throws XmlException {
        assert (sOAPMessage != null);
        assert (sOAPElement != null);
        String string = sOAPElement.getTextContent();
        byte[] byArray = Base64.decode((byte[])string.getBytes());
        MtomUtil.replaceContentWithIncludeElement(sOAPMessage, byArray, sOAPElement);
    }

    public static void replaceContentWithIncludeElement(SOAPMessage sOAPMessage, byte[] byArray, SOAPElement sOAPElement) throws XmlException {
        SOAPElement sOAPElement2 = null;
        try {
            sOAPElement.removeContents();
            sOAPElement2 = sOAPElement.addChildElement(XOP_INCLUDE_QNAME);
        }
        catch (SOAPException sOAPException) {
            throw new XmlException(sOAPException.getMessage(), (Throwable)sOAPException);
        }
        String string = MtomUtil.getMTOMcid(sOAPElement.getElementQName());
        MtomUtil.writeHref(sOAPMessage, sOAPElement2, string);
        MtomUtil.addMtomAttachment(sOAPMessage, byArray, string);
    }

    public static int calculateRawBytesLength(int n) {
        int n2 = 0;
        if (n >= 4) {
            n2 = n * 3 / 4 - 2;
        }
        return n2;
    }
}

