/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import weblogic.utils.http.HttpRequestParser;
import weblogic.wsee.util.WLJAXRPCException;

public abstract class MultiByteConverterUtil {
    private static final String DO_NOT_ENCODE_THESE = "/:!&?=";
    private static final String DEFAULT_ENCODING = HttpRequestParser.getURIDecodeEncoding();
    private static final String LEGAL_URL_CHAR_PATTERNS = "[a-zA-Z0-9/$-_.+!*'(),%?;:@=&]+";

    public static String encodeMultiByteURL(String string, String string2) {
        String string3 = string2 == null ? DEFAULT_ENCODING : string2;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(string, DO_NOT_ENCODE_THESE, true);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.length() == 1 && DO_NOT_ENCODE_THESE.indexOf(string4) >= 0) {
                    stringBuilder.append(string4);
                    continue;
                }
                stringBuilder.append(URLEncoder.encode(string4, string3));
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WLJAXRPCException("Unable to encode WSDL URL", unsupportedEncodingException);
        }
    }

    public static String encodeMultiByteURL(String string) {
        return MultiByteConverterUtil.encodeMultiByteURL(string, null);
    }

    public static boolean isEncodedUrl(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        return string.matches(LEGAL_URL_CHAR_PATTERNS);
    }

    public static boolean hasNonAsciiOrSpace(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f' && c != ' ') continue;
            return true;
        }
        return false;
    }
}

