/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import weblogic.wsee.util.ToStringWriter;
import weblogic.xml.xmlnode.EmptyIterator;

public class NameValueList {
    private List list = new ArrayList();

    public void put(String string, Object object) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(new Entry(string, object));
    }

    public Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (this.list == null) {
            return null;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.get(i);
            if (!string.equals(entry.name)) continue;
            return entry.value;
        }
        return null;
    }

    public List getList(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (this.list == null) {
            return linkedList;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.get(i);
            if (!string.equals(entry.name)) continue;
            linkedList.add(entry.value);
        }
        return linkedList;
    }

    public void remove(String string) {
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                Entry entry = (Entry)this.list.get(i);
                if (!string.equals(entry.name)) continue;
                this.list.remove(i);
            }
        }
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Iterator names() {
        if (this.list == null) {
            return EmptyIterator.iterator;
        }
        return new NameIterator();
    }

    public int size() {
        return this.list == null ? 0 : this.list.size();
    }

    public Entry get(int n) {
        return this.list == null ? null : (Entry)this.list.get(n);
    }

    public Iterator values() {
        if (this.list == null) {
            return EmptyIterator.iterator;
        }
        return new ValueIterator();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeArray("list", this.values());
        toStringWriter.end();
    }

    private class ValueIterator
    implements Iterator {
        int index = 0;

        private ValueIterator() {
        }

        public boolean hasNext() {
            return NameValueList.this.list.size() > this.index;
        }

        public Object next() {
            Object object = ((Entry)((NameValueList)NameValueList.this).list.get((int)this.index)).value;
            ++this.index;
            return object;
        }

        public void remove() {
            NameValueList.this.list.remove(this.index);
        }
    }

    private class NameIterator
    implements Iterator {
        int index = 0;

        private NameIterator() {
        }

        public boolean hasNext() {
            return NameValueList.this.list.size() > this.index;
        }

        public Object next() {
            String string = ((Entry)((NameValueList)NameValueList.this).list.get((int)this.index)).name;
            ++this.index;
            return string;
        }

        public void remove() {
            NameValueList.this.list.remove(this.index);
        }
    }

    public static class Entry {
        String name;
        Object value;

        public Entry(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String name() {
            return this.name;
        }

        public Object value() {
            return this.value;
        }
    }
}

