/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.security.AccessController;
import weblogic.common.CompletionRequest;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.path.Member;
import weblogic.messaging.path.helper.KeyString;
import weblogic.messaging.path.helper.MemberString;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class PathServiceUtil {
    private static final ServerMBean server = ManagementService.getRuntimeAccess((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())).getServer();
    private static final boolean isStandAloneServer = server.getCluster() == null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConversationIdMapping(String string) throws Throwable {
        if (isStandAloneServer) {
            return;
        }
        String string2 = PathServiceUtil.makeSureValidConversationId(string);
        CompletionRequest completionRequest = new CompletionRequest();
        PathHelper.manager().cachedPutIfAbsent(PathHelper.DEFAULT_PATH_SERVICE_JNDI, new KeyString(4, string2, string2), new MemberString(server.getName(), server.getName()), 32768, completionRequest);
        CompletionRequest completionRequest2 = completionRequest;
        synchronized (completionRequest2) {
            completionRequest.getResult();
        }
    }

    public static String getServerNameFromPathService(String string) throws Throwable {
        if (isStandAloneServer) {
            return null;
        }
        String string2 = PathServiceUtil.makeSureValidConversationId(string);
        CompletionRequest completionRequest = new CompletionRequest();
        PathHelper.manager().cachedGet(PathHelper.DEFAULT_PATH_SERVICE_JNDI, new KeyString(4, string2, string2), 32768, completionRequest);
        Member member = (Member)completionRequest.getResult();
        if (member == null) {
            return null;
        }
        return member.getWLServerName();
    }

    public static void removeConversationIdMapping(String string) throws Throwable {
        if (isStandAloneServer) {
            return;
        }
        String string2 = PathServiceUtil.makeSureValidConversationId(string);
        PathHelper.manager().cachedRemove(PathHelper.DEFAULT_PATH_SERVICE_JNDI, new KeyString(4, string2, string2), new MemberString(server.getName(), server.getName()), 33280);
    }

    private static String makeSureValidConversationId(String string) {
        String string2 = string.replace(":", ";");
        string2 = string2.replace(",", ".");
        string2 = string2.replace("=", "-");
        string2 = string2.replace("*", "8");
        string2 = string2.replace("?", "-");
        return string2;
    }
}

