/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JMethod;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.BuiltinPolicyFinder;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicyValidateUtil {
    public static final void checkClassScopedOWSMPolicy(JClass jClass, Logger logger) {
        JAnnotation jAnnotation = jClass.getAnnotation(Policy.class);
        JAnnotation jAnnotation2 = jClass.getAnnotation(SecurityPolicy.class);
        JAnnotation jAnnotation3 = jClass.getAnnotation(Policies.class);
        JAnnotation jAnnotation4 = jClass.getAnnotation(SecurityPolicies.class);
        if (jAnnotation != null && jAnnotation2 != null) {
            logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "annotation.WLSPolicy.OWSMSecurityPolicy.notAllowed", Policy.class.getName(), SecurityPolicy.class.getName()));
        }
        if (jAnnotation3 != null && jAnnotation4 != null) {
            logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "annotation.WLSPolicy.OWSMSecurityPolicy.notAllowed", Policy.class.getName(), SecurityPolicy.class.getName()));
        }
        if (jAnnotation2 != null || jAnnotation4 != null) {
            String string = jAnnotation2 != null ? SecurityPolicy.class.getName() : SecurityPolicies.class.getName();
            for (JMethod jMethod : jClass.getMethods()) {
                if (jMethod.getAnnotation(Policy.class) == null && jMethod.getAnnotation(Policies.class) == null) continue;
                String string2 = jMethod.getAnnotation(Policy.class) != null ? Policy.class.getName() : Policies.class.getName();
                logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "annotation.WLSPolicy.OWSMSecurityPolicy.notAllowed", string2, string));
            }
        }
    }

    public static final void checkClassScopedWebLogicProprietaryPolicy(WebServiceSEIDecl webServiceSEIDecl, Logger logger) {
        Iterator<PolicyDecl> iterator = webServiceSEIDecl.getPoilices();
        while (iterator.hasNext()) {
            PolicyDecl policyDecl = iterator.next();
            PolicyStatement policyStatement = PolicyValidateUtil.getPolicyStatement(policyDecl, (JAnnotatedElement)webServiceSEIDecl.getJClass(), logger);
            try {
                if (policyStatement == null || !SecurityPolicyAssertionFactory.hasSecurityPolicy(policyStatement.normalize())) continue;
                logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceSEIDecl.getJClass(), "policy.9.xPolicyOnJAXWS.notallowed", new Object[0]));
            }
            catch (PolicyException policyException) {}
        }
    }

    public static final void checkMethodScopedWebLogicProprietaryPolicy(WebMethodDecl webMethodDecl, Logger logger) {
        Iterator<PolicyDecl> iterator = webMethodDecl.getPoilices();
        while (iterator.hasNext()) {
            PolicyDecl policyDecl = iterator.next();
            PolicyStatement policyStatement = PolicyValidateUtil.getPolicyStatement(policyDecl, (JAnnotatedElement)webMethodDecl.getJMethod(), logger);
            try {
                if (policyStatement == null || !SecurityPolicyAssertionFactory.hasSecurityPolicy(policyStatement.normalize())) continue;
                logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "policy.9.xPolicyOnJAXWS.notallowed", new Object[0]));
            }
            catch (PolicyException policyException) {}
        }
    }

    public static final void checkIllegalPolicyMixUp(WebServiceSEIDecl webServiceSEIDecl, Logger logger) {
        HashSet<PolicyDecl> hashSet = new HashSet<PolicyDecl>();
        Iterator<PolicyDecl> iterator = webServiceSEIDecl.getPoilices();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        Iterator<WebMethodDecl> iterator2 = webServiceSEIDecl.getWebMethods();
        while (iterator2.hasNext()) {
            iterator = iterator2.next().getPoilices();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        PolicyValidateUtil.validatePolicyMixUp(hashSet.iterator(), (JAnnotatedElement)webServiceSEIDecl.getJClass(), logger);
    }

    private static final void validatePolicyMixUp(Iterator<PolicyDecl> iterator, JAnnotatedElement jAnnotatedElement, Logger logger) {
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            PolicyDecl policyDecl = iterator.next();
            try {
                PolicyStatement policyStatement = PolicyValidateUtil.getPolicyStatement(policyDecl, jAnnotatedElement, logger);
                if (policyStatement != null && SecurityPolicyAssertionFactory.hasSecurityPolicy(policyStatement.normalize())) {
                    bl = true;
                }
                if (policyStatement != null && SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(policyStatement.normalize())) {
                    bl2 = true;
                }
                if (!(bl & bl2)) continue;
                logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.9.xPolicyAndWsspPolicy.MixUp.notallowed", new Object[0]));
                return;
            }
            catch (PolicyException policyException) {
            }
        }
    }

    private static PolicyStatement getPolicyStatement(PolicyDecl policyDecl, JAnnotatedElement jAnnotatedElement, Logger logger) {
        PolicyStatement policyStatement = null;
        try {
            if (policyDecl.isBuiltInPolicy()) {
                String string = policyDecl.getBuiltInUriWithoutPrefix();
                policyStatement = BuiltinPolicyFinder.getInstance().findPolicy(string, null);
            } else {
                InputStream inputStream = policyDecl.getPolicyURI().toURL().openConnection().getInputStream();
                policyStatement = PolicyFinder.readPolicyFromStream(policyDecl.getUri(), inputStream, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return policyStatement;
    }
}

